/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.migration.aok;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorityUtil;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.authorization.business.PersonIndependentAuthorizationContext;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.business.EntityMemberReadWriteDataService;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.business.events.EntityMembershipChangedEvent;
import de.justsoftware.onx.container.integration.persistence.EntityChildrenDAO;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityMemberWithEntityType;
import de.justsoftware.onx.container.shared.model.util.EntityMemberUtil;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.events.PersonUpdateEvent;
import de.justsoftware.onx.migration.business.ImportException;
import de.justsoftware.onx.migration.business.ImportPostProcessor;
import de.justsoftware.onx.migration.business.PersonImportService;
import de.justsoftware.onx.migration.business.impl.ImportUpdateEventCollector;
import de.justsoftware.onx.migration.business.impl.MembershipImportModel;
import de.justsoftware.onx.migration.business.impl.MembershipImportPostProcessor;
import de.justsoftware.onx.migration.shared.server.model.PersonImportModel;
import de.justsoftware.onx.person.business.PersonRoleService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.TransactionStatus;

public class AokReadOnlyMembershipImportPostProcessor<I extends PersonImportModel<?>>
implements ImportPostProcessor<I> {
    @Autowired
    private EntityMemberReadWriteDataService _entityMemberReadWriteDataService;
    @Autowired
    private TransactionHelper _transactionHelper;
    @Autowired
    private PersonRoleService _personRoleService;
    @Autowired
    private AuthorizationContextProvider _authContextProvider;
    @Autowired
    private ItemService _itemService;
    @Autowired
    private EntityChildrenDAO _entityChildrenDAO;
    private MembershipImportPostProcessor.MembershipImportDataProvider<I> _importDataProvider;
    private String _readOnlyRoleName;
    private String _requiredRoleForChildEntityMemberships = "PUBLIC";
    private boolean _passMembershipsToChildEntities = false;

    @Required
    public void setImportDataProvider(@Nonnull MembershipImportPostProcessor.MembershipImportDataProvider<I> importDataProvider) {
        this._importDataProvider = importDataProvider;
    }

    @Required
    public void setReadOnlyRoleName(@Nonnull String readOnlyRoleName) {
        this._readOnlyRoleName = readOnlyRoleName;
    }

    public void setPassMembershipsToChildEntities(boolean passMembershipsToChildEntities) {
        this._passMembershipsToChildEntities = passMembershipsToChildEntities;
    }

    public void setRequiredRoleForChildEntityMemberships(@Nonnull String requiredRoleForChildEntityMemberships) {
        this._requiredRoleForChildEntityMemberships = requiredRoleForChildEntityMemberships;
    }

    @Override
    public void process(List<? extends I> importedPersons, ImportUpdateEventCollector importUpdateEventCollector) {
        try {
            SetMultimap<PersonId, EntityId> importPersonMemberships = this.importMemberships(importedPersons);
            ImmutableSet rolesToAdd = ImmutableSet.of((Object)PersonRole.valueOf(this._readOnlyRoleName));
            HashMap<EntityId, Multimap<PersonId, EntityMemberRole>> newRoles = new HashMap<EntityId, Multimap<PersonId, EntityMemberRole>>();
            HashMap<EntityId, Multimap<PersonId, EntityMemberRole>> oldRoles = new HashMap<EntityId, Multimap<PersonId, EntityMemberRole>>();
            this.saveRoles(importUpdateEventCollector, importPersonMemberships, (Set<PersonRole>)rolesToAdd, newRoles, oldRoles);
            Sets.union(newRoles.keySet(), oldRoles.keySet()).forEach(entityId -> {
                Multimap newRolesForEntity = (Multimap)newRoles.getOrDefault(entityId, (Multimap<PersonId, EntityMemberRole>)ImmutableSetMultimap.of());
                Multimap oldRolesForEntity = (Multimap)oldRoles.getOrDefault(entityId, (Multimap<PersonId, EntityMemberRole>)ImmutableSetMultimap.of());
                importUpdateEventCollector.add(new EntityMembershipChangedEvent((EntityId)entityId, (ImmutableSetMultimap<PersonId, EntityMemberRole>)ImmutableSetMultimap.copyOf((Multimap)newRolesForEntity), (ImmutableSetMultimap<PersonId, EntityMemberRole>)ImmutableSetMultimap.copyOf((Multimap)oldRolesForEntity), true));
            });
        }
        catch (ImportException e) {
            PersonImportService.IMPORT_LOG.error("Error occured while importing read only roles. Skipping this chunk.", (Throwable)e);
        }
    }

    private void saveRoles(@Nonnull ImportUpdateEventCollector importUpdateEventCollector, @Nonnull SetMultimap<PersonId, EntityId> importPersonMemberships, @Nonnull Set<PersonRole> rolesToAdd, @Nonnull Map<EntityId, Multimap<PersonId, EntityMemberRole>> addedRoles, @Nonnull Map<EntityId, Multimap<PersonId, EntityMemberRole>> removedRoles) {
        ImmutableSetMultimap<PersonId, PersonRole> rolesFromDb = this._personRoleService.getPersonRoles(importPersonMemberships.keySet());
        importPersonMemberships.asMap().forEach((personId, parentIds) -> {
            try {
                ImmutableSet.Builder importedMembershipEntities = ImmutableSet.builder();
                importedMembershipEntities.addAll((Iterable)parentIds);
                if (this._passMembershipsToChildEntities) {
                    ImmutableSetMultimap<EntityId, EntityId> childrenIds = this._entityChildrenDAO.getEntityChildren((Set<EntityId>)ImmutableSet.copyOf((Collection)parentIds));
                    importedMembershipEntities.addAll(Iterables.filter((Iterable)childrenIds.values(), (Predicate)new EntityIsVisibleForRolePredicate(this._requiredRoleForChildEntityMemberships)));
                }
                ImmutableSet importedMemberships = importedMembershipEntities.build();
                ImmutableMap memberships = Maps.uniqueIndex((Iterable)this._entityMemberReadWriteDataService.getByPersonIds((Set<PersonId>)ImmutableSet.of((Object)personId)).get(personId), EntityMemberWithEntityType::getEntityId);
                ImmutableMap existingMemberships = ImmutableMap.copyOf((Map)Maps.filterValues((Map)memberships, EntityMemberUtil.composeRoleFilterPredicate(EntityMemberRole.MEMBER)));
                Sets.SetView membershipsToRemove = Sets.difference(existingMemberships.keySet(), (Set)importedMemberships);
                Sets.SetView membershipsToAdd = Sets.difference((Set)importedMemberships, existingMemberships.keySet());
                this._transactionHelper.doInTransactionWithoutResult(arg_0 -> this.lambda$saveRoles$1(importUpdateEventCollector, rolesToAdd, personId, rolesFromDb, addedRoles, removedRoles, (Set)membershipsToRemove, (Set)membershipsToAdd, memberships, arg_0));
                ImmutableSet entitiesToUpdate = ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)membershipsToAdd, (Iterable)membershipsToRemove));
                if (!entitiesToUpdate.isEmpty()) {
                    importUpdateEventCollector.add(new PersonUpdateEvent(personId.asProfileId()));
                }
                this._entityMemberReadWriteDataService.invalidateCache((Set<PersonId>)ImmutableSet.of((Object)personId), (Set<EntityId>)entitiesToUpdate);
                PersonImportService.IMPORT_LOG.info("Imported read-only memberships for person id " + personId.getId() + " and entities " + importedMemberships.toString());
                PersonImportService.IMPORT_LOG.info("Removed memberships " + membershipsToRemove.toString() + " for person " + personId.getId());
            }
            catch (RuntimeException e) {
                PersonImportService.IMPORT_LOG.error("Failed to add read-only membership for person id " + personId.getId(), (Throwable)e);
            }
        });
    }

    private void updateEntityRoles(Map<EntityId, Multimap<PersonId, EntityMemberRole>> newRoles, Map<EntityId, Multimap<PersonId, EntityMemberRole>> oldRoles, PersonId personId, Set<EntityId> membershipsToRemove, Set<EntityId> membershipsToAdd, ImmutableMap<EntityId, EntityMemberWithEntityType> memberships) {
        Map memberRoles = Maps.transformValues(memberships, EntityMemberWithEntityType::getRoles);
        this._entityMemberReadWriteDataService.persistMemberRoles(membershipsToRemove, (Set<PersonId>)ImmutableSet.of((Object)personId), (Set<EntityMemberRole>)ImmutableSet.of());
        this._entityMemberReadWriteDataService.mergeMemberRoles(membershipsToAdd, (Set<PersonId>)ImmutableSet.of((Object)personId), (Set<EntityMemberRole>)ImmutableSet.of(), (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.MEMBER));
        Sets.union(membershipsToAdd, membershipsToRemove).forEach(entityId -> oldRoles.computeIfAbsent((EntityId)entityId, e -> HashMultimap.create()).replaceValues((Object)personId, (Iterable)memberRoles.getOrDefault(entityId, ImmutableSet.of())));
        membershipsToAdd.forEach(entityId -> {
            ImmutableSet currentRoles = memberRoles.getOrDefault(entityId, ImmutableSet.of());
            ImmutableSet<EntityMemberRole> r = EntityMemberRoles.replaceRoles((Set<EntityMemberRole>)currentRoles, (Set<EntityMemberRole>)ImmutableSet.of(), (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.MEMBER));
            newRoles.computeIfAbsent((EntityId)entityId, e -> HashMultimap.create()).putAll((Object)personId, r);
        });
    }

    private void updatePersonRoles(@Nonnull ImportUpdateEventCollector importUpdateEventCollector, @Nonnull Set<PersonRole> rolesToAdd, PersonId personId, Set<PersonRole> personRoles) {
        if (Iterables.any(rolesToAdd, (Predicate)Predicates.not((Predicate)Predicates.in(personRoles)))) {
            this._personRoleService.savePersonRoles(personId, rolesToAdd, false, importUpdateEventCollector);
        }
    }

    @Nonnull
    private SetMultimap<PersonId, EntityId> importMemberships(@Nonnull List<? extends I> importedPersons) throws ImportException {
        HashMultimap importPersonMemberships = HashMultimap.create();
        for (MembershipImportModel memberShip : this._importDataProvider.getAdditionalImportDataFor(importedPersons)) {
            importPersonMemberships.putAll(memberShip.getMembershipsByPersonId());
        }
        return importPersonMemberships;
    }

    private /* synthetic */ void lambda$saveRoles$1(ImportUpdateEventCollector importUpdateEventCollector, Set rolesToAdd, PersonId personId, ImmutableSetMultimap rolesFromDb, Map addedRoles, Map removedRoles, Set membershipsToRemove, Set membershipsToAdd, ImmutableMap memberships, TransactionStatus status) {
        this.updatePersonRoles(importUpdateEventCollector, rolesToAdd, personId, (Set<PersonRole>)rolesFromDb.get((Object)personId));
        this.updateEntityRoles(addedRoles, removedRoles, personId, membershipsToRemove, membershipsToAdd, (ImmutableMap<EntityId, EntityMemberWithEntityType>)memberships);
    }

    private class EntityIsVisibleForRolePredicate
    implements Predicate<EntityId> {
        private final Role _role;

        public EntityIsVisibleForRolePredicate(String roleName) {
            ImmutableMap<String, ? extends Role> allRoles = AokReadOnlyMembershipImportPostProcessor.this._personRoleService.getAllPersonAndStaticRoles();
            this._role = AuthorityUtil.valueOf(allRoles, roleName);
        }

        public boolean apply(@Nullable EntityId input) {
            if (input == null) {
                return false;
            }
            Item<EntityId> entity = AokReadOnlyMembershipImportPostProcessor.this._itemService.getById(input);
            if (entity == null) {
                PersonImportService.IMPORT_LOG.warn("Unable to import membership for entity with id " + input.toString() + " since entity does not exist.");
                return false;
            }
            PersonIndependentAuthorizationContext auth = AokReadOnlyMembershipImportPostProcessor.this._authContextProvider.getPersonIndependentAuthorizationContext();
            return auth.may(entity, (Action)StaticEntityAction.ENTITY_READ_DETAILS, (ImmutableSet<? extends Role>)ImmutableSet.of((Object)this._role));
        }
    }
}

