/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.search.shared.model.db;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.container.shared.model.AbstractUUIDBasedItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.message.search.shared.model.db.ChatSearchQueueItemId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class DBChatSearchQueueItem {
    public static final NullPermeableFunction<DBChatSearchQueueItem, AbstractUUIDBasedItemId> TO_ITEM_ID = new NullPermeableFunction<DBChatSearchQueueItem, AbstractUUIDBasedItemId>(){

        @Override
        protected AbstractUUIDBasedItemId applySafe(DBChatSearchQueueItem input) {
            return input.toItemId();
        }
    };
    public static final NullPermeableFunction<DBChatSearchQueueItem, ChatSearchQueueItemId> TO_ID = new NullPermeableFunction<DBChatSearchQueueItem, ChatSearchQueueItemId>(){

        @Override
        protected ChatSearchQueueItemId applySafe(DBChatSearchQueueItem input) {
            return input.getId();
        }
    };
    private ChatSearchQueueItemId _id;
    private UUID _itemId;
    private ItemType _itemType;
    private DateTime _createdAt;
    private DateTime _modifiedAt;

    @Deprecated
    public DBChatSearchQueueItem() {
    }

    public DBChatSearchQueueItem(ChatSearchQueueItemId id, AbstractUUIDBasedItemId itemId, DateTime createdAt, DateTime modifiedAt) {
        this._id = id;
        this._itemId = itemId.getId();
        this._itemType = itemId.getType();
        this._createdAt = createdAt;
        this._modifiedAt = modifiedAt;
    }

    @Nonnull
    public ChatSearchQueueItemId getId() {
        return this._id;
    }

    public void setId(ChatSearchQueueItemId id) {
        this._id = id;
    }

    @Nonnull
    public UUID getItemId() {
        return this._itemId;
    }

    public void setItemId(UUID itemId) {
        this._itemId = itemId;
    }

    @Nonnull
    public ItemType getItemType() {
        return this._itemType;
    }

    public void setItemType(ItemType itemType) {
        this._itemType = itemType;
    }

    @Nonnull
    public AbstractUUIDBasedItemId toItemId() {
        return AbstractUUIDBasedItemId.create(this._itemId, this._itemType);
    }

    @Nonnull
    public DateTime getCreatedAt() {
        return this._createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this._createdAt = createdAt;
    }

    @Nonnull
    public DateTime getModifiedAt() {
        return this._modifiedAt;
    }

    public void setModifiedAt(DateTime modifiedAt) {
        this._modifiedAt = modifiedAt;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("itemId", (Object)this._itemId).add("itemType", (Object)this._itemType).add("createdAt", (Object)this._createdAt).add("modifiedAt", (Object)this._modifiedAt).toString();
    }
}

