/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.search.integration.persistence.ibatis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.chat.model.ChatMessageType;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.container.shared.model.AbstractUUIDBasedItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.message.search.integration.persistence.ChatSearchQueueDAO;
import de.justsoftware.onx.message.search.shared.model.db.ChatSearchQueueItemId;
import de.justsoftware.onx.message.search.shared.model.db.DBChatSearchQueueItem;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.toolbox.clock.Clock;
import java.util.Map;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IbatisChatSearchQueueDAO
implements ChatSearchQueueDAO {
    private final IbatisStatementBuilder _ibatisStatementBuilder;
    private final Random _random = new Random();
    private final Clock _clock;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisChatSearchQueueDAO(StatementBuilderFactory statementBuilderFactory, Clock clock) {
        this._ibatisStatementBuilder = statementBuilderFactory.ibatistStatementBuilder("ChatSearchQueue");
        this._clock = clock;
    }

    @Override
    public void insert(Iterable<? extends AbstractUUIDBasedItemId> ids, DateTime creationDate) {
        DateTime commonDate = creationDate != null ? creationDate : DateTime.now();
        this._ibatisStatementBuilder.insert("insertItems").partition("itemIds", ImmutableSet.copyOf(ids), (Map<String, ?>)ImmutableMap.of((Object)"createdAt", (Object)commonDate, (Object)"modifiedAt", (Object)commonDate));
    }

    @Override
    public void insertChatMessages(Iterable<ConversationId> conversationIds, DateTime creationDate) {
        DateTime commonDate = creationDate != null ? creationDate : DateTime.now();
        this._ibatisStatementBuilder.insert("insertChatMessages").partition("conversationIds", ImmutableSet.copyOf(conversationIds), (Map<String, ?>)ImmutableMap.of((Object)"itemType", (Object)ItemType.CHAT_MESSAGE, (Object)"createdAt", (Object)commonDate, (Object)"modifiedAt", (Object)commonDate, (Object)"messageTypes", (Object)ImmutableList.of((Object)((Object)ChatMessageType.CHAT_MESSAGE), (Object)((Object)ChatMessageType.ATTACHMENT_CHAT_MESSAGE))));
    }

    @Override
    public ImmutableList<DBChatSearchQueueItem> fetchNext(int count) {
        Long lockId;
        ImmutableSet nextIds;
        int numUpdated;
        do {
            if ((nextIds = this._ibatisStatementBuilder.select("getNextItems").param(count).asSet()).isEmpty()) {
                return ImmutableList.of();
            }
            lockId = this._random.nextLong();
        } while ((numUpdated = ((Integer)this._ibatisStatementBuilder.update("updateMarkInProgress").partition("ids", nextIds, (Map<String, ?>)ImmutableMap.of((Object)"lockId", (Object)lockId, (Object)"modifiedAt", (Object)this._clock.now()))).intValue()) == 0);
        if (numUpdated < count) {
            nextIds = ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getLockedItemIds").partition("ids", nextIds, (Map<String, ?>)ImmutableMap.of((Object)"lockId", (Object)lockId))).asSet();
        }
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getByIds").partition(nextIds)).asList();
    }

    @Override
    public void deleteByIds(Iterable<ChatSearchQueueItemId> ids) {
        this._ibatisStatementBuilder.delete("deleteByIds").partition(ImmutableSet.copyOf(ids));
    }

    @Override
    public void deleteAll() {
        this._ibatisStatementBuilder.delete("deleteAll").noParam();
    }

    @Override
    public void unlockStuckIds(long minProgressDuration) {
        DateTime maxProgressDate = this._clock.now().minus(minProgressDuration);
        this._ibatisStatementBuilder.update("unlockStuckEvents").param(ImmutableMap.of((Object)"modifiedAt", (Object)this._clock.now(), (Object)"maxProgressDate", (Object)maxProgressDate));
    }

    @Override
    public int getQueueSize() {
        Integer result = (Integer)((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getQueueSize").noParam()).singleObject();
        return result != null ? result : 0;
    }
}

