/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.search.business.impl;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ChatSearchSolrClientConfiguration {
    private static final String CORE_NAME = "chat";
    @Autowired
    @Value(value="${SOLR.readChatUrl}")
    private String _readUrl;
    @Autowired
    @Value(value="${SOLR.writeChatUrl}")
    private String _writeUrl;
    private SolrClient _writeChatSolrClient;
    private SolrClient _readChatSolrClient;

    @PostConstruct
    public void init() {
        this._writeChatSolrClient = this.createWriteChatSolrClient();
        this._readChatSolrClient = this.createReadChatSolrClient();
    }

    @CheckForNull
    private SolrClient createReadChatSolrClient() {
        if (this._writeUrl.equals(this._readUrl)) {
            return null;
        }
        return new HttpSolrClient.Builder(this._readUrl).build();
    }

    @Nonnull
    private SolrClient createWriteChatSolrClient() {
        return new HttpSolrClient.Builder(this._writeUrl).build();
    }

    @Bean(name={"writeChatSolrServer"})
    @Nonnull
    public SolrClient getWriteChatSolrClient() {
        return this._writeChatSolrClient;
    }

    @Bean(name={"readChatSolrServer"})
    @Nonnull
    public SolrClient getReadChatSolrClient() {
        return (SolrClient)MoreObjects.firstNonNull((Object)this._readChatSolrClient, (Object)this._writeChatSolrClient);
    }

    @PreDestroy
    public void destroy() throws IOException {
        if (this._readChatSolrClient != null) {
            this._readChatSolrClient.close();
        }
        this._writeChatSolrClient.close();
    }
}

