/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.search.business.impl;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.chat.model.AttachmentChatMessage;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.chat.model.ChatMessageType;
import de.justsoftware.onx.chat.model.TextChatMessage;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.AbstractUUIDBasedItemId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.message.business.MessageReadDataService;
import de.justsoftware.onx.message.business.events.ChatMessageAddedOrDeletedEvent;
import de.justsoftware.onx.message.business.events.ConversationDeletedEvent;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.search.business.ChatSearchService;
import de.justsoftware.onx.message.search.integration.persistence.ChatSearchQueueDAO;
import de.justsoftware.onx.message.search.shared.model.ChatSearchResult;
import de.justsoftware.onx.message.search.shared.model.ChatSearchResultEntry;
import de.justsoftware.onx.message.search.shared.model.ChatSearchSortType;
import de.justsoftware.onx.message.search.shared.model.db.ChatSearchQueueItemId;
import de.justsoftware.onx.message.search.shared.model.db.DBChatSearchQueueItem;
import de.justsoftware.onx.message.shared.model.ChatMessageId;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.monitoring.business.QueueStatisticsService;
import de.justsoftware.onx.monitoring.business.model.QueueName;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="chatSearchService")
@ParametersAreNonnullByDefault
public class ChatSearchServiceImpl
implements ServerEventHandler,
ChatSearchService {
    private static final Logger LOG = LoggerFactory.getLogger(ChatSearchServiceImpl.class);
    private static final int CONVERSATION_QUEUE_BATCH_SIZE = 10;
    private static final long UNLOCK_EVENT_TIME = 300000L;
    private static final int QUEUE_PROCESS_BATCH_SIZE = 100;
    private final ChatSearchQueueDAO _chatSearchQueueDAO;
    private final MessageReadDataService _messageReadDataService;
    private final SolrClient _readChatSolrServer;
    private final SolrClient _writeChatSolrServer;
    private final QueueStatisticsService _queueStatisticsService;
    private final boolean _useSoftCommit;

    @Autowired
    public ChatSearchServiceImpl(ChatSearchQueueDAO chatSearchQueueDAO, MessageReadDataService messageReadDataService, @Qualifier(value="readChatSolrServer") SolrClient readChatSolrServer, @Qualifier(value="writeChatSolrServer") SolrClient writeChatSolrServer, QueueStatisticsService queueStatisticsService, @Value(value="${SOLR.useSoftCommit}") boolean useSoftCommit) {
        this._chatSearchQueueDAO = chatSearchQueueDAO;
        this._messageReadDataService = messageReadDataService;
        this._readChatSolrServer = readChatSolrServer;
        this._writeChatSolrServer = writeChatSolrServer;
        this._queueStatisticsService = queueStatisticsService;
        this._useSoftCommit = useSoftCommit;
    }

    @Override
    public ChatSearchResult search(ConversationId conversationId, String searchString, ChatSearchSortType sortType, int offset, int numberOfResults, AuthorizationCheckContextWithUserId authorizationContext) throws ServiceException {
        authorizationContext.check((ItemId)conversationId, (Action)StaticAction.CONVERSATION_READ);
        if (searchString.trim().isEmpty()) {
            return new ChatSearchResult(0, (ImmutableList<ChatSearchResultEntry>)ImmutableList.of());
        }
        SolrQuery query = new SolrQuery();
        query.setQuery(searchString);
        query.addFilterQuery(new String[]{"parent_id:" + conversationId.asString()});
        query.set("start", offset);
        query.set("rows", numberOfResults);
        query.set("sort", new String[]{sortType != null ? sortType.getSortValue() : ChatSearchSortType.DATE_DESCENDING.getSortValue()});
        try {
            QueryResponse response = this._readChatSolrServer.query((SolrParams)query, SolrRequest.METHOD.POST);
            List entries = response.getBeans(ChatSearchResultEntry.class);
            ImmutableList entriesWithHighlights = FluentIterable.from((Iterable)entries).transform((Function)new HighlightAddingFn(response.getHighlighting())).filter(Predicates.notNull()).toList();
            return new ChatSearchResult((int)response.getResults().getNumFound(), (ImmutableList<ChatSearchResultEntry>)entriesWithHighlights);
        }
        catch (IOException | SolrServerException e) {
            LOG.error("Error searching for chat messages", e);
            throw new ServiceException("Error searching for chat messages", e);
        }
    }

    @Override
    public void fullImport(boolean deleteFirst) throws ServiceException {
        if (deleteFirst) {
            this.clearIndex();
        }
        this._chatSearchQueueDAO.deleteAll();
        this.enqueueAllMessages();
    }

    @Override
    public void clearIndex() {
        try {
            this._writeChatSolrServer.deleteByQuery("*:*");
            this._writeChatSolrServer.commit(false, true, this._useSoftCommit);
            LOG.debug("Successfully deleted all chat messages from index");
        }
        catch (IOException | SolrServerException e) {
            LOG.error("Error while deleting chat messages from index for full import", e);
            throw new ServiceException("Error while deleting chat messages from index for full import", e);
        }
    }

    private void enqueueAllMessages() {
        ImmutableSet<ConversationId> allConversations = this._messageReadDataService.getConversationIdsForAllUsers();
        List conversationPartitions = Lists.partition((List)ImmutableList.copyOf(allConversations), (int)10);
        for (List conversationPartition : conversationPartitions) {
            this._chatSearchQueueDAO.insertChatMessages(conversationPartition, DateTime.now());
        }
        LOG.debug("Added messages from {} conversations to queue.", (Object)allConversations.size());
    }

    @Override
    public void processQueue() {
        this._chatSearchQueueDAO.unlockStuckIds(300000L);
        ImmutableList<DBChatSearchQueueItem> items = this._chatSearchQueueDAO.fetchNext(100);
        while (!items.isEmpty()) {
            this.reportStatistics(items);
            this.processQueueItems(items);
            items = this._chatSearchQueueDAO.fetchNext(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueueItems(ImmutableList<DBChatSearchQueueItem> items) {
        try {
            ImmutableSet itemIds = (ImmutableSet)items.stream().map(DBChatSearchQueueItem.TO_ITEM_ID).collect(ImmutableSet.toImmutableSet());
            ImmutableSet messageIds = (ImmutableSet)itemIds.stream().filter(id -> id instanceof ChatMessageId).map(id -> (ChatMessageId)id).collect(ImmutableSet.toImmutableSet());
            this.handleSingleMessageEvents((ImmutableSet<ChatMessageId>)messageIds);
            ImmutableSet conversationIds = (ImmutableSet)itemIds.stream().filter(id -> id instanceof ConversationId).map(id -> (ConversationId)id).collect(ImmutableSet.toImmutableSet());
            this.handleWholeConversationEvents((ImmutableSet<ConversationId>)conversationIds);
            this._writeChatSolrServer.commit(false, true, this._useSoftCommit);
            LOG.debug("Indexing chat messages successfully finished.");
        }
        catch (IOException | RuntimeException | SolrServerException e) {
            LOG.error("Error while indexing chat messages", e);
        }
        finally {
            this._chatSearchQueueDAO.deleteByIds((Iterable<ChatSearchQueueItemId>)FluentIterable.from(items).transform(DBChatSearchQueueItem.TO_ID));
        }
    }

    private void handleWholeConversationEvents(ImmutableSet<ConversationId> conversationIds) throws IOException, SolrServerException {
        if (conversationIds.isEmpty()) {
            return;
        }
        ImmutableMap<ConversationId, Conversation> existingConversations = this._messageReadDataService.getConversationsByIds((Set<ConversationId>)conversationIds);
        ImmutableSet conversationsToDelete = (ImmutableSet)conversationIds.stream().filter(id -> !existingConversations.containsKey(id)).collect(ImmutableSet.toImmutableSet());
        if (!conversationsToDelete.isEmpty()) {
            for (ConversationId id2 : conversationsToDelete) {
                this._writeChatSolrServer.deleteByQuery("parent_id:" + id2);
            }
            LOG.debug("Indexing chat messages will delete messages for {}", conversationIds);
        }
    }

    private void handleSingleMessageEvents(ImmutableSet<ChatMessageId> messageIds) throws SolrServerException, IOException {
        if (messageIds.isEmpty()) {
            return;
        }
        ImmutableMap<ChatMessageId, ChatMessage> messagesFromDb = this._messageReadDataService.getMessagesByIds(messageIds);
        ImmutableList.Builder idsToDeleteBuilder = ImmutableList.builder();
        ImmutableList.Builder docsToUpdateBuilder = ImmutableList.builder();
        for (ChatMessageId messageId : messageIds) {
            ChatMessage message = (ChatMessage)messagesFromDb.get((Object)messageId);
            if (message != null && message instanceof TextChatMessage) {
                TextChatMessage textMessage = (TextChatMessage)message;
                docsToUpdateBuilder.add((Object)this.toSolrInputDocument(textMessage, textMessage.getMessage()));
                continue;
            }
            if (message != null && message instanceof AttachmentChatMessage) {
                AttachmentChatMessage attachmentMessage = (AttachmentChatMessage)message;
                docsToUpdateBuilder.add((Object)this.toSolrInputDocument(attachmentMessage, attachmentMessage.getAttachment().getFilename()));
                continue;
            }
            idsToDeleteBuilder.add((Object)messageId.asString());
        }
        ImmutableList idsToDelete = idsToDeleteBuilder.build();
        ImmutableList docsToUpdate = docsToUpdateBuilder.build();
        if (!idsToDelete.isEmpty()) {
            this._writeChatSolrServer.deleteById((List)idsToDelete);
        }
        if (!docsToUpdate.isEmpty()) {
            this._writeChatSolrServer.add((Collection)docsToUpdate);
        }
        LOG.debug("Indexing chat messages will update {} messages and delete {} messages...", (Object)docsToUpdate.size(), (Object)idsToDelete.size());
    }

    private void reportStatistics(ImmutableList<DBChatSearchQueueItem> items) {
        ImmutableList timestamps = FluentIterable.from(items).transform((Function)new Function<DBChatSearchQueueItem, DateTime>(){

            public DateTime apply(DBChatSearchQueueItem input) {
                return input.getCreatedAt();
            }
        }).toList();
        this._queueStatisticsService.itemsDequeued(QueueName.CHAT_SEARCH, (Iterable<DateTime>)timestamps);
    }

    @Nonnull
    private SolrInputDocument toSolrInputDocument(ChatMessage message, String text) {
        SolrInputDocument result = new SolrInputDocument(new String[0]);
        result.addField("id", (Object)message.getId().asString());
        result.addField("parent_id", (Object)message.getConversationId().asString());
        result.addField("author_id", (Object)message.getSentFrom().asString());
        result.addField("text", (Object)text);
        result.addField("create_date", (Object)message.getCreateDate().toDate());
        result.addField("type", (Object)message.getType().name());
        return result;
    }

    @Subscribe
    public void onChatMessageAddedOrDeleted(ChatMessageAddedOrDeletedEvent event) {
        ChatMessage message = event.getMessage();
        if (message.getType() == ChatMessageType.CHAT_MESSAGE || message.getType() == ChatMessageType.ATTACHMENT_CHAT_MESSAGE || message.getType() == ChatMessageType.DELETED_CHAT_MESSAGE) {
            this._chatSearchQueueDAO.insert((Iterable<? extends AbstractUUIDBasedItemId>)ImmutableSet.of((Object)message.getId()), DateTime.now());
        }
    }

    @Subscribe
    public void onConversationDeleted(ConversationDeletedEvent event) {
        this._chatSearchQueueDAO.insert((Iterable<? extends AbstractUUIDBasedItemId>)ImmutableSet.of((Object)event.getConversationId()), DateTime.now());
    }

    @Override
    public long getQueueSize() {
        return this._chatSearchQueueDAO.getQueueSize();
    }

    private static final class HighlightAddingFn
    implements Function<ChatSearchResultEntry, ChatSearchResultEntry> {
        private final Map<String, Map<String, List<String>>> _highlights;

        @ParametersAreNonnullByDefault
        private HighlightAddingFn(Map<String, Map<String, List<String>>> highlights) {
            this._highlights = highlights;
        }

        public ChatSearchResultEntry apply(ChatSearchResultEntry input) {
            if (input == null) {
                return null;
            }
            List<String> textHighlighted = null;
            Map<String, List<String>> highlightedFields = this._highlights.get(input.getId());
            if (highlightedFields != null) {
                textHighlighted = highlightedFields.get("text");
            }
            if (textHighlighted != null) {
                input.setTextHighlighted((ImmutableList<String>)ImmutableList.copyOf(textHighlighted));
            } else {
                input.setTextHighlighted((ImmutableList<String>)ImmutableList.of());
            }
            return input;
        }
    }
}

