/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationSettings;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class ConversationSettings {
    public static final Function<DBConversationSettings, ConversationSettings> FROM_DB = new NullPermeableFunction<DBConversationSettings, ConversationSettings>(){

        @Override
        protected ConversationSettings applySafe(DBConversationSettings dbSettings) {
            return new ConversationSettings(dbSettings.getConversationId(), dbSettings.getParticipantId(), dbSettings.isMuted(), dbSettings.isHidden(), dbSettings.getModifyDate());
        }
    };
    public static final boolean MUTED_DEFAULT = false;
    public static final boolean HIDDEN_DEFAULT = false;
    private final ConversationId _conversationId;
    private final PersonId _participantId;
    private final boolean _muted;
    private final boolean _hidden;
    private final DateTime _modifyDate;

    public ConversationSettings(ConversationId conversationId, PersonId participantId, boolean muted, boolean hidden) {
        this(conversationId, participantId, muted, hidden, DateTime.now());
    }

    public ConversationSettings(ConversationId conversationId, PersonId participantId, boolean muted, boolean hidden, DateTime modifyDate) {
        this._conversationId = conversationId;
        this._participantId = participantId;
        this._muted = muted;
        this._hidden = hidden;
        this._modifyDate = modifyDate;
    }

    @Nonnull
    public ConversationId getConversationId() {
        return this._conversationId;
    }

    @Nonnull
    public PersonId getParticipantId() {
        return this._participantId;
    }

    public boolean isMuted() {
        return this._muted;
    }

    public boolean isHidden() {
        return this._hidden;
    }

    @Nonnull
    public DateTime getModifyDate() {
        return this._modifyDate;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("conversationId", (Object)this._conversationId).add("participantId", (Object)this._participantId).add("muted", this._muted).add("hidden", this._hidden).add("modifyDate", (Object)this._modifyDate).toString();
    }
}

