/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.message.shared.model.ConversationType;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class Conversation
implements Serializable,
Item<ConversationId> {
    public static final NullPermeableFunction<Conversation, ConversationId> TO_ID = new NullPermeableFunction<Conversation, ConversationId>(){

        @Override
        protected ConversationId applySafe(Conversation input) {
            return input.getId();
        }
    };
    public static final NullPermeableFunction<Conversation, ImmutableSet<PersonId>> TO_PARTICIPANTS = new NullPermeableFunction<Conversation, ImmutableSet<PersonId>>(){

        @Override
        protected ImmutableSet<PersonId> applySafe(Conversation conversation) {
            return conversation.getParticipants();
        }
    };
    public static final NullPermeableFunction<Conversation, ImmutableSet<PersonId>> TO_DELETED_PARTICIPANTS = new NullPermeableFunction<Conversation, ImmutableSet<PersonId>>(){

        @Override
        protected ImmutableSet<PersonId> applySafe(Conversation conversation) {
            return conversation.getDeletedParticipants();
        }
    };
    private static final long serialVersionUID = 1L;
    private final ConversationId _id;
    private final ConversationType _type;
    private final ImmutableSet<PersonId> _participants;
    private final ImmutableSet<PersonId> _deletedParticipants;
    private final ImmutableSet<UserGroupId> _userGroups;
    private final ImmutableSet<UserGroupId> _deletedUserGroups;
    private final TenantId _tenantId;
    private final String _customTitle;
    private final DateTime _lastMessageDate;

    public Conversation(ConversationId id, ConversationType type, ImmutableSet<PersonId> participants, ImmutableSet<PersonId> deletedParticipants, ImmutableSet<UserGroupId> userGroups, ImmutableSet<UserGroupId> deletedUserGroups, TenantId tenantId, @Nullable String customTitle, DateTime lastMessageDate) {
        this._id = id;
        this._type = type;
        this._participants = participants;
        this._deletedParticipants = deletedParticipants;
        this._userGroups = userGroups;
        this._deletedUserGroups = deletedUserGroups;
        this._tenantId = tenantId;
        this._customTitle = customTitle;
        this._lastMessageDate = lastMessageDate;
    }

    @Override
    public ConversationId getId() {
        return this._id;
    }

    @Nonnull
    public ConversationType getType() {
        return this._type;
    }

    @Nonnull
    public ImmutableSet<PersonId> getParticipants() {
        return this._participants;
    }

    @Nonnull
    public ImmutableSet<PersonId> getDeletedParticipants() {
        return this._deletedParticipants;
    }

    @Nonnull
    public ImmutableSet<UserGroupId> getUserGroups() {
        return this._userGroups;
    }

    @Nonnull
    public ImmutableSet<UserGroupId> getDeletedUserGroups() {
        return this._deletedUserGroups;
    }

    @Nonnull
    public TenantId getTenantId() {
        return this._tenantId;
    }

    @CheckForNull
    public String getCustomTitle() {
        return this._customTitle;
    }

    @Nonnull
    public DateTime getLastMessageDate() {
        return this._lastMessageDate;
    }

    @Nonnull
    private Object[] hashObjects() {
        return new Object[]{this._id};
    }

    public int hashCode() {
        return Arrays.hashCode(this.hashObjects());
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Conversation && Arrays.equals(this.hashObjects(), ((Conversation)obj).hashObjects());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("type", (Object)this._type).add("participants", this._participants.size()).add("deletedParticipants", this._deletedParticipants.size()).add("userGroups", this._userGroups.size()).add("deletedUserGroups", this._deletedUserGroups.size()).add("tenantId", (Object)this._tenantId).add("customTitle", (Object)this._customTitle).add("lastMessageDate", (Object)this._lastMessageDate).toString();
    }

    @Override
    public GlobalId getParentId() {
        return null;
    }

    @Override
    public ComponentType getModuleType() {
        return null;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }
}

