/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.chat.model.ChatMessageType;
import de.justsoftware.onx.common.integration.persistence.DBConversationAlreadyExists;
import de.justsoftware.onx.common.integration.persistence.DBMessageAlreadyExists;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.Id;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.message.integration.persistence.MessageDAO;
import de.justsoftware.onx.message.integration.persistence.ibatis.ConversationChangeId;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBChatAttachment;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBChatAttachmentCreationModel;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversation;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationChange;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationParticipant;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationReadData;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationSettings;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationUserGroup;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBMailMessageInfo;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBMessage;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBMessageCreationModel;
import de.justsoftware.onx.message.model.ConversationReadData;
import de.justsoftware.onx.message.model.MessageLoadDirection;
import de.justsoftware.onx.message.shared.model.ChatAttachmentId;
import de.justsoftware.onx.message.shared.model.ChatMessageId;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.message.shared.model.ConversationType;
import de.justsoftware.onx.person.integration.persistence.PersonRelation;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class IbatisMessageDAO
implements MessageDAO {
    public static final DateTime READ_DATE_FOR_NEWLY_ADDED_PARTICIPANTS = new LocalDate(1970, 1, 1).toDateTimeAtStartOfDay();
    private static final String NAMESPACE = "Message.";
    private final SqlMapClient _sqlMapper;
    private final TransactionHelper _transactionHelper;
    private final IbatisStatementBuilder _ibatisStatementBuilder;

    @Autowired
    public IbatisMessageDAO(@Qualifier(value="sqlMapClient") SqlMapClient sqlMapper, TransactionHelper transactionHelper, StatementBuilderFactory statementBuilderFactory) {
        this._sqlMapper = sqlMapper;
        this._transactionHelper = transactionHelper;
        this._ibatisStatementBuilder = statementBuilderFactory.ibatistStatementBuilder("Message");
    }

    @Override
    public DBMessage insertMessage(DBMessageCreationModel message) {
        return (DBMessage)this._transactionHelper.doInTransaction(status -> {
            UUID creationId = message.getCreationId();
            DBMessage insertedMessage = creationId != null ? this.internalInsertMessageWithGivenId(message, new ChatMessageId(creationId)) : this.internalInsertMessage(message);
            DBChatAttachmentCreationModel attachmentCreationModel = message.getAttachment();
            if (attachmentCreationModel != null) {
                DBChatAttachment attachment = this.insertAttachment(attachmentCreationModel, insertedMessage.getId(), insertedMessage.getCreateDate());
                insertedMessage.setAttachment(attachment);
            }
            return insertedMessage;
        });
    }

    @Nonnull
    private DBMessage createDBMessage(DBMessageCreationModel messageCreationModel) {
        DBMessage message = new DBMessage();
        message.setConversationId(messageCreationModel.getConversationId());
        message.setSentFrom(messageCreationModel.getSentFrom());
        message.setType(messageCreationModel.getType());
        message.setMessage(messageCreationModel.getMessage());
        DateTime createDate = (DateTime)MoreObjects.firstNonNull((Object)messageCreationModel.getCreateDate(), (Object)this.getChatTime());
        message.setCreateDate(createDate);
        message.setModifyDate(createDate);
        return message;
    }

    @Nonnull
    private DBChatAttachment insertAttachment(DBChatAttachmentCreationModel attachmentCreationModel, ChatMessageId messageId, DateTime createDate) {
        DBChatAttachment attachment = new DBChatAttachment();
        attachment.setId(ChatAttachmentId.random());
        attachment.setMessageId(messageId);
        attachment.setDocumentId(attachmentCreationModel.getDocumentId());
        attachment.setDocumentVersionId(attachmentCreationModel.getDocumentVersionId());
        attachment.setFilename(attachmentCreationModel.getFilename());
        attachment.setSize(attachmentCreationModel.getSize());
        attachment.setContentType(attachmentCreationModel.getContentType());
        attachment.setVersion(attachmentCreationModel.getVersion());
        attachment.setAttachmentType(attachmentCreationModel.getAttachmentType());
        attachment.setImageWidth(attachmentCreationModel.getImageWidth());
        attachment.setImageHeight(attachmentCreationModel.getImageHeight());
        attachment.setCreateDate(createDate);
        this._ibatisStatementBuilder.insert("insertNewAttachment").param(attachment);
        return attachment;
    }

    @Nonnull
    private DBMessage internalInsertMessage(DBMessageCreationModel messageCreationModel) {
        DBMessage message = this.createDBMessage(messageCreationModel);
        message.setId(ChatMessageId.random());
        this._ibatisStatementBuilder.insert("insertNewConversationMessage").param(message);
        this.updateConversationSetLastMessageDatesAndId(message.getConversationId(), message.getId(), message.getCreateDate());
        return message;
    }

    private void updateConversationSetLastMessageDatesAndId(ConversationId conversationId, ChatMessageId messageId, DateTime createDate) {
        this._ibatisStatementBuilder.update("updateConversationSetLastMessageDatesAndId").param("message_date", createDate, "message_id", messageId, "conversation_id", conversationId);
    }

    @Nonnull
    private DBMessage internalInsertMessageWithGivenId(DBMessageCreationModel messageCreationModel, ChatMessageId creationId) {
        DBMessage message = this.createDBMessage(messageCreationModel);
        message.setId(creationId);
        Integer rowNum = this._ibatisStatementBuilder.update("insertNewConversationMessageWithGivenId").param(message);
        if (rowNum > 0) {
            this.updateConversationSetLastMessageDatesAndId(message.getConversationId(), message.getId(), message.getCreateDate());
            return message;
        }
        throw new DBMessageAlreadyExists(creationId);
    }

    @Override
    public ImmutableMap<ChatMessageId, DBMessage> getMessagesByIds(Set<? extends ChatMessageId> messageIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getMessagesByIds").partition(messageIds)).asMap("id", null);
    }

    @Override
    public ImmutableSet<PersonId> getOneOnOneConversationPartnersByPersonId(PersonId personId) {
        return IbatisDAOUtil.wrappedQueryForImmutableSet(this._sqlMapper, "Message.getOneOnOneConversationPartnersByPersonId", ImmutableMap.of((Object)"personId", (Object)personId));
    }

    @Override
    public ImmutableSet<ConversationId> getOneOnOneConversationWithUser(PersonId currentUser, PersonId otherUser) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getOneOnOneConversationWithUser").param("currentUser", currentUser, "otherUser", otherUser)).asSet();
    }

    @Override
    public ImmutableList<DBConversation> getAllConversationsByDirectParticipant(PersonId user) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getAllConversationsByDirectParticipant").param("personId", user)).asList();
    }

    @Override
    public ConversationId createNewConversation(ConversationType type, Set<PersonId> participants, ImmutableSet<UserGroupId> userGroupIds, @Nullable String title, DateTime createDate, @Nullable UUID creationId, TenantId tenantId) {
        return creationId != null ? this.internalCreateNewConversationWithGivenId(new ConversationId(creationId), type, participants, userGroupIds, title, createDate, tenantId) : this.internalCreateNewConversation(type, participants, userGroupIds, title, createDate, tenantId);
    }

    @Nonnull
    private ConversationId internalCreateNewConversation(ConversationType type, Set<PersonId> participants, ImmutableSet<UserGroupId> userGroupIds, @Nullable String title, DateTime createDate, TenantId tenantId) {
        return (ConversationId)this._transactionHelper.doInTransaction(status -> {
            ConversationId conversationId = ConversationId.random();
            HashMap<String, Object> conversationParams = this.createConversationMap(conversationId, type, title, createDate, tenantId);
            IbatisDAOUtil.wrappedInsert(this._sqlMapper, "Message.insertNewConversation", conversationParams);
            this.insertConversationParticipants(conversationId, participants, createDate);
            this.insertAddedConversationUserGroups(conversationId, userGroupIds, createDate);
            return conversationId;
        });
    }

    @Nonnull
    private ConversationId internalCreateNewConversationWithGivenId(ConversationId id, ConversationType type, Set<PersonId> participants, ImmutableSet<UserGroupId> userGroupIds, @Nullable String title, DateTime createDate, TenantId tenantId) {
        return (ConversationId)this._transactionHelper.doInTransaction(status -> {
            HashMap<String, Object> conversationParams = this.createConversationMap(id, type, title, createDate, tenantId);
            int numRows = IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "Message.insertNewConversationWithGivenId", conversationParams);
            if (numRows > 0) {
                this.insertConversationParticipants(id, participants, createDate);
                this.insertAddedConversationUserGroups(id, userGroupIds, createDate);
                return id;
            }
            throw new DBConversationAlreadyExists(id);
        });
    }

    @Nonnull
    private HashMap<String, Object> createConversationMap(ConversationId id, ConversationType type, @Nullable String title, DateTime createDate, TenantId tenantId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("type", type);
        map.put("title", title);
        map.put("createDate", createDate);
        map.put("tenantId", tenantId);
        return map;
    }

    @Override
    public ImmutableList<DBMessage> getMessagesByConversation(ConversationId conversationId, DateTime offset, int limit, MessageLoadDirection direction) {
        ImmutableMap.Builder paramsBuilder = ImmutableMap.builder();
        paramsBuilder.put((Object)"conversationId", (Object)conversationId);
        paramsBuilder.put((Object)"limit", (Object)limit);
        if (offset != null) {
            paramsBuilder.put((Object)"offset", (Object)offset);
        }
        switch (direction) {
            case LOAD_NEWER_MESSAGES: {
                return this._ibatisStatementBuilder.select("getMessagesByConversationCreatedAfter").param(paramsBuilder.build()).asList();
            }
        }
        return this._ibatisStatementBuilder.select("getMessagesByConversation").param(paramsBuilder.build()).asList();
    }

    @Override
    public ImmutableList<DBMessage> getTextMessagesByConversations(ImmutableSet<ConversationId> conversationIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getTextMessagesByConversations").partition("conversationIds", conversationIds, (Map<String, ?>)ImmutableMap.of((Object)"messageType", (Object)((Object)ChatMessageType.CHAT_MESSAGE)))).asList();
    }

    @Override
    public ImmutableList<DBMessage> getLatestChatMessage(Set<ConversationId> conversationIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getLatestChatMessage").partition(conversationIds)).asList();
    }

    @Override
    @Nonnull
    public ImmutableList<DBMessage> getUpdatedMessages(Set<ConversationId> conversationIds, @Nullable DateTime updatedSince, int limit) {
        if (conversationIds.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"limit", (Object)limit);
        if (updatedSince != null) {
            params.put((Object)"updatedSince", (Object)updatedSince);
        }
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.selectDbSpecific("getUpdatedMessages").partition("conversationIds", conversationIds, (Map<String, ?>)params.build())).asList();
    }

    @Override
    public ImmutableMap<ConversationId, ConversationReadData> getUnreadMessagesCountForUser(PersonId person, Set<? extends ConversationId> conversationIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getUnreadMessageCountForUser").partition("conversations", conversationIds, "personId", person)).asMap(DBConversationReadData::getConversationId, db -> new ConversationReadData(db.getParticipantId(), db.getConversationId(), db.getReadDate(), db.getUnreadCount()));
    }

    @Override
    public ImmutableList<DBConversation> getDBConversationsByIds(Set<? extends ConversationId> conversationIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForImmutableList(this._sqlMapper, "Message.getDBConversationsByIds", conversationIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public ImmutableList<DBConversationParticipant> getDBConversationParticipantsByConversationIds(Set<? extends ConversationId> conversationIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForImmutableList(this._sqlMapper, "Message.getDBConversationParticipantsByConversationIds", conversationIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public ImmutableSet<PersonId> getDirectParticipantIdsByConversationIds(Set<ConversationId> conversationIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getDirectParticipantIdsByConversationIds").partition(conversationIds)).asSet();
    }

    @Override
    public ImmutableList<DBConversationUserGroup> getDBConversationUserGroupsByConversationIds(Set<? extends ConversationId> conversationIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getDBConversationUserGroupsByConversationIds").partition(conversationIds)).asList();
    }

    @Override
    public void updateConversationParticipants(ConversationId id, Set<PersonId> removed, Set<PersonId> added, @Nullable DateTime updateDate) {
        this._transactionHelper.doInTransactionWithoutResult(status -> {
            this.deleteConversationParticipantsByConversationId(id, removed, updateDate);
            this.insertAddedConversationParticipants(id, added, updateDate);
        });
    }

    @Override
    public void updateConversationUserGroups(ConversationId id, ImmutableSet<UserGroupId> removed, ImmutableSet<UserGroupId> added, @Nullable DateTime updateDate) {
        this._transactionHelper.doInTransactionWithoutResult(status -> {
            this.deleteConversationUserGroupByConversationId(id, removed, updateDate);
            this.insertAddedConversationUserGroups(id, added, updateDate);
        });
    }

    private void deleteConversationParticipantsByConversationId(ConversationId id, Set<PersonId> removed, @Nullable DateTime modifyDate) {
        if (removed.isEmpty()) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("conversationId", id);
        params.put("removed", IbatisDAOUtil.toIbatisList(removed));
        params.put("modifyDate", modifyDate);
        IbatisDAOUtil.wrappedInsert(this._sqlMapper, "Message.markConversationParticipantsDeletedByConversationId", params);
    }

    private void deleteConversationUserGroupByConversationId(ConversationId id, ImmutableSet<UserGroupId> removed, @Nullable DateTime modifyDate) {
        if (removed.isEmpty()) {
            return;
        }
        HashMap<String, ConversationId> params = new HashMap<String, ConversationId>();
        params.put("conversationId", id);
        params.put("modifyDate", (ConversationId)modifyDate);
        this._ibatisStatementBuilder.update("markConversationUserGroupsDeletedByConversationId").partition("removed", removed, (Map<String, ?>)params);
    }

    private void insertAddedConversationParticipants(ConversationId id, Set<PersonId> added, @Nullable DateTime createDate) {
        if (added.isEmpty()) {
            return;
        }
        IbatisDAOUtil.wrappedInsert(this._sqlMapper, "Message.deleteConversationParticipantsByConversationId", ImmutableMap.of((Object)"conversationId", (Object)id, (Object)"removed", IbatisDAOUtil.toIbatisList(added)));
        this.insertConversationParticipants(id, added, createDate);
    }

    private void insertConversationParticipants(ConversationId id, Set<PersonId> participants, @Nullable DateTime createDate) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("conversationId", id);
        params.put("participants", IbatisDAOUtil.toIbatisList(participants));
        params.put("createDate", createDate);
        IbatisDAOUtil.wrappedInsert(this._sqlMapper, "Message.insertConversationParticipants", params);
    }

    private void insertAddedConversationUserGroups(ConversationId id, ImmutableSet<UserGroupId> added, @Nullable DateTime createDate) {
        if (added.isEmpty()) {
            return;
        }
        this._transactionHelper.doInTransactionWithoutResult(status -> {
            this._ibatisStatementBuilder.delete("deleteConversationUserGroupsByConversationId").partition("removed", added, "conversationId", id);
            HashMap<String, ConversationId> insertParams = new HashMap<String, ConversationId>();
            insertParams.put("conversationId", id);
            insertParams.put("createDate", (ConversationId)createDate);
            this._ibatisStatementBuilder.insertDbSpecific("insertConversationUserGroups").partition("userGroups", added, (Map<String, ?>)insertParams);
        });
    }

    @Override
    public ImmutableList<DBConversation> getRecentConversationsForUser(PersonId person, TenantId tenantId, int offset, int limit) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getRecentConversationsForUser").param("personId", person, "tenantId", tenantId)).sublist(offset, offset + limit).toList();
    }

    @Override
    public ImmutableList<DBConversation> getUpdatedConversationsForUser(PersonId person, TenantId tenantId, DateTime startingFrom) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getUpdatedConversationsForUser").param("personId", person, "tenantId", tenantId, "startingFrom", startingFrom)).asList();
    }

    @Override
    public ImmutableList<DBConversation> getMultiUserConversationsForUser(PersonId person, TenantId tenantId, int offset, int limit) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getMultiUserConversationsForUser").param("personId", person, "tenantId", tenantId)).sublist(offset, offset + limit).toList();
    }

    @Override
    public ImmutableList<DBConversation> getOneOnOneConversationsForUser(PersonId person, TenantId tenantId, int offset, int limit) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getOneOnOneConversationsForUser").param("personId", person, "tenantId", tenantId)).sublist(offset, offset + limit).toList();
    }

    @Override
    public ImmutableSet<ConversationId> getConversationIdsForAllUsers() {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getConversationIdsForAllUsers").noParam()).asSet();
    }

    @Override
    public boolean markConversationAsRead(PersonId person, ConversationId conversation) {
        return this.markConversationAsRead(person, conversation, this.getChatTime());
    }

    @Override
    public boolean markConversationAsRead(PersonId person, ConversationId conversation, DateTime readDate) {
        int updates = (Integer)this._ibatisStatementBuilder.update("markConversationRead").param("conversationId", conversation, "participantId", person, "readDate", readDate);
        return updates > 0;
    }

    @Override
    public ImmutableList<DBMailMessageInfo> getUnreadMessagesForMail() {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getUnreadMessagesForMail").noParam()).asList();
    }

    @Override
    public void markEmailsSent(SetMultimap<PersonId, ConversationId> participants, DateTime date) {
        ImmutableList.Builder paramsBuilder = ImmutableList.builder();
        for (Map.Entry entry : participants.entries()) {
            paramsBuilder.add((Object)ImmutableMap.of((Object)"personId", (Object)((Id)entry.getKey()), (Object)"conversationId", (Object)((Id)entry.getValue())));
        }
        ImmutableList params = paramsBuilder.build();
        if (!params.isEmpty()) {
            List partitions = Lists.partition((List)params, (int)1000);
            for (List partition : partitions) {
                IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "Message.markEmailsSent", ImmutableMap.of((Object)"entries", IbatisDAOUtil.toIbatisList(partition), (Object)"date", (Object)date));
            }
        }
    }

    @Override
    public ImmutableSet<ConversationId> getUnreadConversationsForPerson(PersonId personId, TenantId tenantId) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getUnreadConversationsForUser").param("personId", personId, "tenantId", tenantId)).asSet();
    }

    @Override
    @Nonnull
    public ImmutableMap<PersonId, Integer> getUnreadConversationsCountsForPersons(ImmutableSet<PersonId> personIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getUnreadConversationsCountsForPersons").partition(personIds)).asMap("participantId", "count");
    }

    @Override
    public ImmutableMap<PersonId, Integer> getUnreadMessagesCountsForPersons(ImmutableSet<PersonId> personIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getUnreadMessagesCountsForPersons").partition(personIds)).asMap("participantId", "count");
    }

    @Override
    public boolean isConversationUnreadForPerson(ConversationId conversationId, PersonId personId) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getUnreadConversationIdForPerson").param("conversationId", conversationId, "personId", personId)).asList().size() > 0;
    }

    @Override
    public ImmutableList<PersonRelation> getParticipantsSharingAConversationOfPersons(Set<? extends PersonId> personIds) {
        return IbatisDAOUtil.wrappedPartitionQueryForImmutableList(this._sqlMapper, "Message.getMembersSharingAConversationForPersonIdSet", personIds, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public void markConversationParticipantsAsDeleted(Set<PersonId> persons) {
        if (persons.isEmpty()) {
            return;
        }
        IbatisDAOUtil.wrappedPartitionDelete(this._sqlMapper, "Message.markConversationParticipantsAsDeleted", persons, IbatisDAOUtil.createParameterFunctionForIdsWithMapData("personIds", ImmutableMap.of()));
    }

    @Override
    public void setConversationTitle(ConversationId id, String title) {
        IbatisDAOUtil.wrappedUpdate(this._sqlMapper, "Message.setConversationTitle", ImmutableMap.of((Object)"id", (Object)id, (Object)"title", (Object)title));
    }

    @Override
    public ImmutableSetMultimap<PersonId, ConversationId> getConversationIdsByParticipants(Set<PersonId> personIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getConversationIdsByParticipants").partition(personIds)).asSetMultimap("participantId", "conversationId");
    }

    @Override
    public DateTime getChatTime() {
        return (DateTime)((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getDBTime").noParam()).asOptional().get();
    }

    @Override
    public ImmutableList<DBMessage> getAttachmentMessagesByConversation(ConversationId conversationId, int limit, DateTime offset) {
        ImmutableMap<String, Object> params = this.paramsForGettingAttachmentMessagesByConversation(conversationId, limit, offset, null);
        return this._ibatisStatementBuilder.select("getMessagesByConversationAndMessageType").param(params).asList();
    }

    @Override
    public ImmutableList<DBMessage> getAttachmentMessagesByConversationFiltered(ConversationId conversationId, int limit, DateTime offset, ImmutableSet<String> contentTypes) {
        ImmutableMap<String, Object> params = this.paramsForGettingAttachmentMessagesByConversation(conversationId, limit, offset, contentTypes);
        return this._ibatisStatementBuilder.selectDbSpecific("getAttachmentMessagesByConversationFiltered").param(params).asList();
    }

    @Override
    public ImmutableList<DBMessage> getAttachmentMessagesByConversationExcluded(ConversationId conversationId, int limit, DateTime offset, ImmutableSet<String> contentTypes) {
        ImmutableMap<String, Object> params = this.paramsForGettingAttachmentMessagesByConversation(conversationId, limit, offset, contentTypes);
        return this._ibatisStatementBuilder.selectDbSpecific("getAttachmentMessagesByConversationExcluded").param(params).asList();
    }

    @Nonnull
    private ImmutableMap<String, Object> paramsForGettingAttachmentMessagesByConversation(ConversationId conversationId, int limit, DateTime offset, @Nullable ImmutableSet<String> contentTypes) {
        ImmutableMap.Builder paramsBuilder = ImmutableMap.builder();
        paramsBuilder.put((Object)"conversationId", (Object)conversationId);
        paramsBuilder.put((Object)"messageType", (Object)ChatMessageType.ATTACHMENT_CHAT_MESSAGE);
        paramsBuilder.put((Object)"limit", (Object)limit);
        if (offset != null) {
            paramsBuilder.put((Object)"offset", (Object)offset);
        }
        this.addAttachmentContentTypeFilterParams((ImmutableMap.Builder<String, Object>)paramsBuilder, contentTypes);
        return paramsBuilder.build();
    }

    private void addAttachmentContentTypeFilterParams(ImmutableMap.Builder<String, Object> paramsBuilder, @Nullable ImmutableSet<String> contentTypes) {
        if (contentTypes == null) {
            return;
        }
        ArrayList<String> contentTypeValues = new ArrayList<String>();
        ArrayList<String> contentTypePatterns = new ArrayList<String>();
        for (String contentType : contentTypes) {
            if (contentType.contains("*")) {
                contentTypePatterns.add(contentType.replace('*', '%'));
                continue;
            }
            contentTypeValues.add(contentType);
        }
        paramsBuilder.put((Object)"contentTypes", contentTypeValues);
        paramsBuilder.put((Object)"contentTypePatterns", contentTypePatterns);
    }

    @Override
    public void iterateOverParticipantsWithRowHandler(Consumer<DBConversationParticipant> participantHandler) {
        ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getAnyParticipantsByDate").noParam()).executeWithConsumer(participantHandler);
    }

    @Override
    public void insertConversationSettings(DBConversationSettings settings) {
        this._ibatisStatementBuilder.insert("insertConversationSettings").param(settings);
    }

    @Override
    public boolean updateConversationSettings(DBConversationSettings settings) {
        return this._ibatisStatementBuilder.update("updateConversationSettings").param(settings) > 0;
    }

    @Override
    public ImmutableTable<PersonId, ConversationId, DBConversationSettings> getConversationsSettings(ImmutableSetMultimap<PersonId, ConversationId> participantConversations) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getConversationsSettings").partition(participantConversations.entries())).asTable("participantId", "conversationId", null);
    }

    @Override
    public ImmutableSet<PersonId> updateConversationParticipantsAsDeletedWithConversation(ConversationId conversationId) {
        this._ibatisStatementBuilder.update("markConversationParticipantsDeletedWithConversation").param(conversationId);
        return this._ibatisStatementBuilder.select("getConversationParticipantsDeletedWithConversation").param(conversationId).asSet();
    }

    @Override
    public ImmutableSet<UserGroupId> updateConversationUserGroupsAsDeletedWithConversation(ConversationId conversationId) {
        this._ibatisStatementBuilder.update("markConversationUserGroupsDeletedWithConversation").param(conversationId);
        return this._ibatisStatementBuilder.select("getConversationUserGroupsDeletedWithConversation").param(conversationId).asSet();
    }

    @Override
    public void unhideConversation(ConversationId conversationId, Set<PersonId> participants, DateTime modifyDate) {
        if (participants.isEmpty()) {
            return;
        }
        this._ibatisStatementBuilder.update("unhideConversation").partition("participants", participants, "conversationId", conversationId, "modifyDate", modifyDate);
    }

    @Override
    public ImmutableSet<ConversationId> getAbandonedConversationsOlderThan(DateTime beforeThen, int limit) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("selectAbandonedConversationsOlderThan").param("before", beforeThen, "limit", limit)).asSet();
    }

    @Override
    public ImmutableMap<ConversationId, DBMessage> getLastMessageOfConversations(Set<ConversationId> conversationIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getLatestChatMessage").partition(conversationIds)).asMap(DBMessage.TO_CONVERSATION_ID);
    }

    @Override
    public int deleteMessages(ConversationId conversationId) {
        return (Integer)this._ibatisStatementBuilder.delete("deleteAllMessagesOfConversation").param("conversationId", conversationId);
    }

    @Override
    public int deleteConversationSettings(ConversationId conversationId) {
        return (Integer)this._ibatisStatementBuilder.delete("deleteAllConversationSettingsOfConversation").param("conversationId", conversationId);
    }

    @Override
    public int deleteParticipants(ConversationId conversationId) {
        return (Integer)this._ibatisStatementBuilder.delete("deleteAllParticipantsOfConversation").param("conversationId", conversationId);
    }

    @Override
    public int deleteUserGroups(ConversationId conversationId) {
        return (Integer)this._ibatisStatementBuilder.delete("deleteAllUserGroupsOfConversation").param("conversationId", conversationId);
    }

    @Override
    public int deleteConversation(ConversationId conversationId) {
        return (Integer)this._ibatisStatementBuilder.delete("deleteConversation").param("conversationId", conversationId);
    }

    @Override
    public void upsertConversationChange(DBConversationChange conversationChange) {
        this._transactionHelper.doInTransactionWithoutResult(status -> {
            conversationChange.setId(ConversationChangeId.random());
            this._ibatisStatementBuilder.updateDbSpecific("upsertConversationChange").param(conversationChange);
        });
    }

    @Override
    @Nonnull
    public ImmutableList<DBConversationChange> getEffectiveConversationChangesSince(PersonId personId, TenantId tenantId, DateTime startingFrom) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getEffectiveConversationChangesSince").param("personId", personId, "tenantId", tenantId, "startingFrom", startingFrom)).asList();
    }

    @Override
    public int deleteAllConversationChangesBefore(DateTime before) {
        return (Integer)this._ibatisStatementBuilder.delete("deleteConversationChangeOlderThan").param("before", before);
    }

    @Override
    public ImmutableList<DBConversationSettings> getUpdatedConversationSettingsForUser(PersonId personId, TenantId tenantId, DateTime since) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getUpdatedConversationSettingsForUser").param("personId", personId, "tenantId", tenantId, "since", since)).asList();
    }

    @Override
    @Nonnull
    public ImmutableSet<PersonId> getUpdatedPersonsForUser(PersonId personId, TenantId tenantId, DateTime since) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getUpdatedPersonsForUser").param("personId", personId, "tenantId", tenantId, "since", since)).asSet();
    }

    @Override
    @Nonnull
    public ImmutableList<DBConversation> getOneOnOneConversationsWithUpdatedUsers(PersonId personId, TenantId tenantId, DateTime since) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getOneOnOneConversationsWithUpdatedUsers").param("personId", personId, "tenantId", tenantId, "since", since)).asList();
    }

    @Override
    public ImmutableMap<PersonId, DateTime> getConversationReadDates(ConversationId conversationId, ImmutableSet<PersonId> participantIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getConversationReadDates").partition("participantIds", participantIds, "conversationId", conversationId)).asMap("participantId", "readDate");
    }

    @Override
    public DBMessage updateMessageAsDeleted(ChatMessageId messageId, ChatMessageType messageType) {
        return (DBMessage)this._transactionHelper.doInTransaction(status -> {
            DateTime deleteDate = this.getChatTime();
            this._ibatisStatementBuilder.update("updateMessageAsDeleted").param("messageId", messageId, "messageType", (Object)messageType, "deleteDate", deleteDate);
            this._ibatisStatementBuilder.delete("deleteAttachmentByMessageId").param(messageId);
            DBMessage message = (DBMessage)this.getMessagesByIds((Set<? extends ChatMessageId>)ImmutableSet.of((Object)messageId)).get((Object)messageId);
            if (message == null) {
                return null;
            }
            this._ibatisStatementBuilder.update("updateConversationLastMessageUpdateWithDate").param("message_date", deleteDate, "conversation_id", message.getConversationId());
            return message;
        });
    }

    @Override
    public ImmutableList<DBMessage> getMessagesByDocumentIds(ImmutableSet<DriveDocumentId> documentIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getMessagesByDocumentIds").partition(documentIds)).asList();
    }

    @Override
    public ImmutableMap<ConversationId, TenantId> getAllConversations(int offset, int limit) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.selectDbSpecific("getAllConversations").param("offset", offset, "limit", limit)).asMap("conversationId", "tenantId");
    }

    @Override
    public ImmutableList<ConversationId> getAllGroupConversations(int offset, int limit) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.selectDbSpecific("getAllGroupConversations").param("offset", offset, "limit", limit)).asList();
    }

    @Override
    public ImmutableSet<ConversationId> getConversationIdsOfTenant(TenantId tenantId) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getConversationIdsOfTenant").param("tenantId", tenantId)).asSet();
    }

    @Override
    public ImmutableSet<PersonId> filterConversationAuthors(ConversationId conversationId, ImmutableSet<PersonId> personIdsToFilter) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("filterConversationAuthors").partition("personIdsToFilter", personIdsToFilter, "conversationId", conversationId)).asSet();
    }

    @Override
    public ImmutableSet<DBConversationUserGroup> deleteUserGroupsFromAllConversations(ImmutableSet<UserGroupId> userGroupIds) {
        return (ImmutableSet)this._transactionHelper.doInTransaction(status -> {
            ImmutableSet conversationUserGroups = ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getConversationUserGroupsByUserGroupIds").partition(userGroupIds)).asSet();
            if (conversationUserGroups.isEmpty()) {
                return ImmutableSet.of();
            }
            this._ibatisStatementBuilder.delete("deleteConversationUserGroupByConversationIdsAndUserGroupIds").partition(((ImmutableSetMultimap)conversationUserGroups.stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(DBConversationUserGroup::getConversationId, DBConversationUserGroup::getUserGroupId))).entries());
            return conversationUserGroups;
        });
    }

    @Override
    public ImmutableSetMultimap<UserGroupId, ConversationId> getConversationIdsByUserGroupIds(ImmutableSet<UserGroupId> userGroupIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getConversationUserGroupsByUserGroupIds").partition(userGroupIds)).asSetMultimap(DBConversationUserGroup::getUserGroupId, DBConversationUserGroup::getConversationId);
    }

    @Override
    @Nonnull
    public ImmutableSet<UserGroupId> getUpdatedUserGroupsForUser(PersonId personId, TenantId tenantId, DateTime since) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getUpdatedUserGroupsForUser").param("personId", personId, "tenantId", tenantId, "since", since)).asSet();
    }

    @Override
    @Nonnull
    public ImmutableSet<ConversationId> getRecentlyJoinedConversations(PersonId personId, TenantId tenantId, DateTime since) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getRecentlyJoinedConversations").param("personId", personId, "tenantId", tenantId, "since", since)).asSet();
    }

    @Override
    @Nonnull
    public ImmutableSet<UserGroupId> getUserGroupIdsByConversations(ImmutableSet<ConversationId> conversationIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getUserGroupIdsByConversations").partition(conversationIds)).asSet();
    }
}

