/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.integration.persistence.ibatis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.chat.model.ChatMessageType;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBChatAttachmentCreationModel;
import de.justsoftware.onx.message.shared.model.ConversationId;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class DBMessageCreationModel {
    private final UUID _creationId;
    private final ConversationId _conversationId;
    private final PersonId _sentFrom;
    private final String _message;
    private final DateTime _createDate;
    private final ChatMessageType _type;
    private final DBChatAttachmentCreationModel _attachment;

    public DBMessageCreationModel(ConversationId conversationId, PersonId sentFrom, @Nullable String message, ChatMessageType type) {
        this(conversationId, sentFrom, message, type, null, null, null);
    }

    public DBMessageCreationModel(ConversationId conversationId, PersonId sentFrom, @Nullable String message, ChatMessageType type, @Nullable UUID creationId, @Nullable DBChatAttachmentCreationModel attachment) {
        this(conversationId, sentFrom, message, type, creationId, attachment, null);
    }

    @VisibleForTesting
    public DBMessageCreationModel(ConversationId conversationId, PersonId sentFrom, @Nullable String message, ChatMessageType type, @Nullable DateTime createDate) {
        this(conversationId, sentFrom, message, type, null, null, createDate);
    }

    @VisibleForTesting
    public DBMessageCreationModel(ConversationId conversationId, PersonId sentFrom, @Nullable String message, ChatMessageType type, @Nullable UUID creationId, @Nullable DBChatAttachmentCreationModel attachment, @Nullable DateTime createDate) {
        this._creationId = creationId;
        this._conversationId = conversationId;
        this._sentFrom = sentFrom;
        this._message = message;
        this._createDate = createDate;
        this._type = type;
        this._attachment = attachment;
    }

    @CheckForNull
    public UUID getCreationId() {
        return this._creationId;
    }

    @Nonnull
    public ConversationId getConversationId() {
        return this._conversationId;
    }

    @Nonnull
    public PersonId getSentFrom() {
        return this._sentFrom;
    }

    @CheckForNull
    public String getMessage() {
        return this._message;
    }

    @CheckForNull
    public DateTime getCreateDate() {
        return this._createDate;
    }

    @Nonnull
    public ChatMessageType getType() {
        return this._type;
    }

    @CheckForNull
    public DBChatAttachmentCreationModel getAttachment() {
        return this._attachment;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("creationId", (Object)this._creationId).add("conversationId", (Object)this._conversationId).add("sentFrom", (Object)this._sentFrom).add("message", (Object)this._message).add("createDate", (Object)this._createDate).add("type", (Object)this._type).add("attachment", (Object)this._attachment).toString();
    }
}

