/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.integration.persistence.ibatis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.message.integration.persistence.ibatis.IbatisMessageDAO;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class DBConversationParticipant {
    public static final NullPermeableFunction<DBConversationParticipant, ConversationId> TO_CONVERSATION_ID = new NullPermeableFunction<DBConversationParticipant, ConversationId>(){

        @Override
        protected ConversationId applySafe(DBConversationParticipant input) {
            return input.getConversationId();
        }
    };
    public static final NullPermeableFunction<DBConversationParticipant, PersonId> TO_PARTICIPANT_ID = new NullPermeableFunction<DBConversationParticipant, PersonId>(){

        @Override
        protected PersonId applySafe(DBConversationParticipant input) {
            return input.getParticipantId();
        }
    };
    public static final Predicate<DBConversationParticipant> IS_DELETED = new NullIsFalsePredicate<DBConversationParticipant>(){

        @Override
        protected boolean applySafe(DBConversationParticipant participant) {
            return participant.isDeleted();
        }
    };
    private ConversationId _conversationId;
    private PersonId _participantId;
    private DateTime _createDate;
    private DateTime _modifyDate;
    private DateTime _readDate;
    private boolean _deleted = false;
    private boolean _deletedWithConversation = false;

    @Deprecated
    protected DBConversationParticipant() {
    }

    public DBConversationParticipant(ConversationId conversationId, PersonId participantId, DateTime createDate, DateTime modifyDate, DateTime readDate, boolean deleted, boolean deletedWithConversation) {
        this._conversationId = conversationId;
        this._participantId = participantId;
        this._createDate = createDate;
        this._modifyDate = modifyDate;
        this._readDate = readDate;
        this._deleted = deleted;
        this._deletedWithConversation = deletedWithConversation;
    }

    @Nonnull
    public ConversationId getConversationId() {
        return this._conversationId;
    }

    public void setConversationId(ConversationId conversationId) {
        this._conversationId = conversationId;
    }

    @Nonnull
    public PersonId getParticipantId() {
        return this._participantId;
    }

    public void setParticipantId(PersonId participantId) {
        this._participantId = participantId;
    }

    @Nonnull
    public DateTime getCreateDate() {
        return this._createDate;
    }

    public void setCreateDate(DateTime createDate) {
        this._createDate = createDate;
    }

    @Nonnull
    public DateTime getModifyDate() {
        return this._modifyDate;
    }

    public void setModifyDate(DateTime modifyDate) {
        this._modifyDate = modifyDate;
    }

    @Nonnull
    public DateTime getReadDate() {
        return this._readDate == null ? IbatisMessageDAO.READ_DATE_FOR_NEWLY_ADDED_PARTICIPANTS : this._readDate;
    }

    public void setReadDate(DateTime readDate) {
        this._readDate = readDate;
    }

    public boolean isDeleted() {
        return this._deleted;
    }

    public void setDeleted(boolean deleted) {
        this._deleted = deleted;
    }

    public boolean isDeletedWithConversation() {
        return this._deletedWithConversation;
    }

    public void setDeletedWithConversation(boolean deletedWithConversation) {
        this._deletedWithConversation = deletedWithConversation;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("conversationId", (Object)this._conversationId).add("participantId", (Object)this._participantId).add("createDate", (Object)this._createDate).add("modifyDate", (Object)this._modifyDate).add("readDate", (Object)this._readDate).add("deleted", this._deleted).add("deletedWithConversation", this._deletedWithConversation).toString();
    }
}

