/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.integration.persistence;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.chat.model.ChatMessageType;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversation;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationChange;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationParticipant;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationSettings;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationUserGroup;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBMailMessageInfo;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBMessage;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBMessageCreationModel;
import de.justsoftware.onx.message.model.ConversationReadData;
import de.justsoftware.onx.message.model.MessageLoadDirection;
import de.justsoftware.onx.message.shared.model.ChatMessageId;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.message.shared.model.ConversationType;
import de.justsoftware.onx.person.integration.persistence.PersonRelation;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public interface MessageDAO {
    @Nonnull
    public DBMessage insertMessage(DBMessageCreationModel var1);

    @Nonnull
    public ImmutableList<DBMessage> getMessagesByConversation(ConversationId var1, @Nullable DateTime var2, int var3, MessageLoadDirection var4);

    @Nonnull
    public ImmutableList<DBMessage> getTextMessagesByConversations(ImmutableSet<ConversationId> var1);

    @Nonnull
    public ImmutableMap<ChatMessageId, DBMessage> getMessagesByIds(Set<? extends ChatMessageId> var1);

    @Nonnull
    public ImmutableSet<PersonId> getOneOnOneConversationPartnersByPersonId(PersonId var1);

    @Nonnull
    public ImmutableSet<ConversationId> getOneOnOneConversationWithUser(PersonId var1, PersonId var2);

    @Nonnull
    public ImmutableList<DBConversation> getAllConversationsByDirectParticipant(PersonId var1);

    @Nonnull
    public ConversationId createNewConversation(ConversationType var1, Set<PersonId> var2, ImmutableSet<UserGroupId> var3, @Nullable String var4, DateTime var5, @Nullable UUID var6, TenantId var7);

    public void setConversationTitle(ConversationId var1, String var2);

    @Nonnull
    public ImmutableList<DBConversation> getDBConversationsByIds(Set<? extends ConversationId> var1);

    @Nonnull
    public ImmutableList<DBConversationParticipant> getDBConversationParticipantsByConversationIds(Set<? extends ConversationId> var1);

    @Nonnull
    public ImmutableSet<PersonId> getDirectParticipantIdsByConversationIds(Set<ConversationId> var1);

    @Nonnull
    public ImmutableList<DBConversationUserGroup> getDBConversationUserGroupsByConversationIds(Set<? extends ConversationId> var1);

    public void updateConversationParticipants(ConversationId var1, Set<PersonId> var2, Set<PersonId> var3, @Nullable DateTime var4);

    public void updateConversationUserGroups(ConversationId var1, ImmutableSet<UserGroupId> var2, ImmutableSet<UserGroupId> var3, @Nullable DateTime var4);

    @Nonnull
    public ImmutableMap<ConversationId, ConversationReadData> getUnreadMessagesCountForUser(PersonId var1, Set<? extends ConversationId> var2);

    @Nonnull
    public ImmutableList<DBConversation> getRecentConversationsForUser(PersonId var1, TenantId var2, int var3, int var4);

    @Nonnull
    public ImmutableList<DBConversation> getUpdatedConversationsForUser(PersonId var1, TenantId var2, DateTime var3);

    @Nonnull
    public ImmutableList<DBConversation> getMultiUserConversationsForUser(PersonId var1, TenantId var2, int var3, int var4);

    @Nonnull
    public ImmutableList<DBConversation> getOneOnOneConversationsForUser(PersonId var1, TenantId var2, int var3, int var4);

    @Nonnull
    public ImmutableSet<ConversationId> getConversationIdsForAllUsers();

    public boolean markConversationAsRead(PersonId var1, ConversationId var2);

    public boolean markConversationAsRead(PersonId var1, ConversationId var2, DateTime var3);

    @Nonnull
    public ImmutableList<DBMailMessageInfo> getUnreadMessagesForMail();

    public void markEmailsSent(SetMultimap<PersonId, ConversationId> var1, DateTime var2);

    @Nonnull
    public ImmutableSet<ConversationId> getUnreadConversationsForPerson(PersonId var1, TenantId var2);

    @Nonnull
    public ImmutableMap<PersonId, Integer> getUnreadConversationsCountsForPersons(ImmutableSet<PersonId> var1);

    @Nonnull
    public ImmutableMap<PersonId, Integer> getUnreadMessagesCountsForPersons(ImmutableSet<PersonId> var1);

    public boolean isConversationUnreadForPerson(ConversationId var1, PersonId var2);

    @Nonnull
    public ImmutableList<PersonRelation> getParticipantsSharingAConversationOfPersons(Set<? extends PersonId> var1);

    public void markConversationParticipantsAsDeleted(Set<PersonId> var1);

    @Nonnull
    public ImmutableList<DBMessage> getLatestChatMessage(Set<ConversationId> var1);

    @Nonnull
    public ImmutableList<DBMessage> getUpdatedMessages(Set<ConversationId> var1, @Nullable DateTime var2, int var3);

    @Nonnull
    public ImmutableSetMultimap<PersonId, ConversationId> getConversationIdsByParticipants(Set<PersonId> var1);

    @Nonnull
    public DateTime getChatTime();

    @Nonnull
    public ImmutableList<DBMessage> getAttachmentMessagesByConversation(ConversationId var1, int var2, @Nullable DateTime var3);

    @Nonnull
    public ImmutableList<DBMessage> getAttachmentMessagesByConversationFiltered(ConversationId var1, int var2, @Nullable DateTime var3, ImmutableSet<String> var4);

    @Nonnull
    public ImmutableList<DBMessage> getAttachmentMessagesByConversationExcluded(ConversationId var1, int var2, @Nullable DateTime var3, ImmutableSet<String> var4);

    public void iterateOverParticipantsWithRowHandler(Consumer<DBConversationParticipant> var1);

    public void insertConversationSettings(DBConversationSettings var1);

    public boolean updateConversationSettings(DBConversationSettings var1);

    @Nonnull
    public ImmutableTable<PersonId, ConversationId, DBConversationSettings> getConversationsSettings(ImmutableSetMultimap<PersonId, ConversationId> var1);

    @Nonnull
    public ImmutableSet<PersonId> updateConversationParticipantsAsDeletedWithConversation(ConversationId var1);

    @Nonnull
    public ImmutableSet<UserGroupId> updateConversationUserGroupsAsDeletedWithConversation(ConversationId var1);

    public void unhideConversation(ConversationId var1, Set<PersonId> var2, DateTime var3);

    @Nonnull
    public ImmutableSet<ConversationId> getAbandonedConversationsOlderThan(DateTime var1, int var2);

    @Nonnull
    public ImmutableMap<ConversationId, DBMessage> getLastMessageOfConversations(Set<ConversationId> var1);

    public int deleteMessages(ConversationId var1);

    public int deleteConversationSettings(ConversationId var1);

    public int deleteParticipants(ConversationId var1);

    public int deleteUserGroups(ConversationId var1);

    public int deleteConversation(ConversationId var1);

    public void upsertConversationChange(DBConversationChange var1);

    @Nonnull
    public ImmutableList<DBConversationChange> getEffectiveConversationChangesSince(PersonId var1, TenantId var2, DateTime var3);

    public int deleteAllConversationChangesBefore(DateTime var1);

    @Nonnull
    public ImmutableList<DBConversationSettings> getUpdatedConversationSettingsForUser(PersonId var1, TenantId var2, DateTime var3);

    @Nonnull
    public ImmutableSet<PersonId> getUpdatedPersonsForUser(PersonId var1, TenantId var2, DateTime var3);

    @Nonnull
    public ImmutableList<DBConversation> getOneOnOneConversationsWithUpdatedUsers(PersonId var1, TenantId var2, DateTime var3);

    @Nonnull
    public ImmutableMap<PersonId, DateTime> getConversationReadDates(ConversationId var1, ImmutableSet<PersonId> var2);

    @CheckForNull
    public DBMessage updateMessageAsDeleted(ChatMessageId var1, ChatMessageType var2);

    @Nonnull
    public ImmutableList<DBMessage> getMessagesByDocumentIds(ImmutableSet<DriveDocumentId> var1);

    @Nonnull
    public ImmutableMap<ConversationId, TenantId> getAllConversations(int var1, int var2);

    @Nonnull
    public ImmutableList<ConversationId> getAllGroupConversations(int var1, int var2);

    @Nonnull
    public ImmutableSet<ConversationId> getConversationIdsOfTenant(TenantId var1);

    @Nonnull
    public ImmutableSet<PersonId> filterConversationAuthors(ConversationId var1, ImmutableSet<PersonId> var2);

    @Nonnull
    public ImmutableSet<DBConversationUserGroup> deleteUserGroupsFromAllConversations(ImmutableSet<UserGroupId> var1);

    @Nonnull
    public ImmutableSetMultimap<UserGroupId, ConversationId> getConversationIdsByUserGroupIds(ImmutableSet<UserGroupId> var1);

    @Nonnull
    public ImmutableSet<UserGroupId> getUpdatedUserGroupsForUser(PersonId var1, TenantId var2, DateTime var3);

    @Nonnull
    public ImmutableSet<ConversationId> getRecentlyJoinedConversations(PersonId var1, TenantId var2, DateTime var3);

    @Nonnull
    public ImmutableSet<UserGroupId> getUserGroupIdsByConversations(ImmutableSet<ConversationId> var1);
}

