/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.mail.business.MailModelService;
import de.justsoftware.onx.mail.business.MailService;
import de.justsoftware.onx.mail.business.model.FooterMailModel;
import de.justsoftware.onx.mail.business.model.HeaderMailModel;
import de.justsoftware.onx.mail.business.model.MailReceiver;
import de.justsoftware.onx.mail.business.model.MailReceivers;
import de.justsoftware.onx.mail.business.model.NewChatMessageMailModel;
import de.justsoftware.onx.mail.business.model.ThemeMailModel;
import de.justsoftware.onx.mail.i18n.EmailMessages;
import de.justsoftware.onx.message.business.MessageReadWriteDataService;
import de.justsoftware.onx.message.business.MessageService;
import de.justsoftware.onx.message.business.NewChatMessageEmailSender;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBMailMessageInfo;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.model.ConversationSettings;
import de.justsoftware.onx.message.shared.model.ChatMessageId;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.message.shared.model.ConversationType;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.server.business.ClusterConfiguration;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import de.justsoftware.toolbox.clock.Clock;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="newChatMessageEmailSender")
@ParametersAreNonnullByDefault
public class NewChatMessageEmailSenderImpl
implements NewChatMessageEmailSender {
    private static final Logger LOG = LoggerFactory.getLogger(NewChatMessageEmailSenderImpl.class);
    private final MessageReadWriteDataService _messageReadWriteDataService;
    private final MailService _mailService;
    private final PersonService _personService;
    private final MailModelService _mailModelService;
    private final Settings _settings;
    private final I18nService _i18nService;
    private final MessageService _messageService;
    private final Clock _clock;
    private final ClusterConfiguration _clusterConfiguration;

    @Autowired
    public NewChatMessageEmailSenderImpl(MessageReadWriteDataService messageReadWriteDataService, MailService mailService, PersonService personService, MailModelService mailModelService, Settings settings, I18nService i18nService, MessageService messageService, Clock clock, ClusterConfiguration clusterConfiguration) {
        this._messageReadWriteDataService = messageReadWriteDataService;
        this._mailService = mailService;
        this._personService = personService;
        this._mailModelService = mailModelService;
        this._settings = settings;
        this._i18nService = i18nService;
        this._messageService = messageService;
        this._clock = clock;
        this._clusterConfiguration = clusterConfiguration;
    }

    @Override
    public void sendMail() {
        if (!this._clusterConfiguration.isMaster()) {
            return;
        }
        ImmutableList<DBMailMessageInfo> unreadMessages = this._messageReadWriteDataService.getUnreadMessagesForMail();
        this._messageReadWriteDataService.markEmailsSent((SetMultimap<PersonId, ConversationId>)this.getConversationIdsByPersonId((Iterable<DBMailMessageInfo>)unreadMessages), this._clock.now());
        FluentIterable filteredMessages = FluentIterable.from(unreadMessages).filter(this.getRecipientFilter((Iterable<DBMailMessageInfo>)unreadMessages)).filter(this.getConversationFilter((Iterable<DBMailMessageInfo>)unreadMessages));
        this.sendMail((Iterable<DBMailMessageInfo>)filteredMessages);
    }

    private void sendMail(Iterable<DBMailMessageInfo> mailDataIds) {
        ImmutableMap messagesByRecipient = FluentIterable.from(mailDataIds).index(DBMailMessageInfo.TO_RECIPIENT_ID).asMap();
        ImmutableSet allConversationIds = FluentIterable.from(mailDataIds).transform(DBMailMessageInfo.TO_CONVERSATION_ID).toSet();
        ImmutableMap<ConversationId, Conversation> conversations = this._messageReadWriteDataService.getConversationsByIds((Set<ConversationId>)allConversationIds);
        ImmutableSet allPersonIds = FluentIterable.from(mailDataIds).transform(DBMailMessageInfo.TO_AUTHOR_ID).append((Iterable)messagesByRecipient.keySet()).append((Iterable)FluentIterable.from((Iterable)conversations.values()).filter(c -> c.getType() == ConversationType.ONE_ON_ONE).transformAndConcat(c -> Sets.union(c.getParticipants(), c.getDeletedParticipants()))).toSet();
        ImmutableMap<PersonId, DBPerson> persons = this._personService.getPersonsByIds((Set<PersonId>)allPersonIds);
        this.sendMail((Map<PersonId, Collection<DBMailMessageInfo>>)messagesByRecipient, (Map<ConversationId, Conversation>)conversations, (Map<PersonId, DBPerson>)persons);
    }

    private void sendMail(Map<PersonId, Collection<DBMailMessageInfo>> messagesByRecipient, Map<ConversationId, Conversation> conversations, Map<PersonId, DBPerson> persons) {
        for (Map.Entry<PersonId, Collection<DBMailMessageInfo>> entry : messagesByRecipient.entrySet()) {
            PersonId recipientId = entry.getKey();
            DBPerson recipient = persons.get(recipientId);
            if (recipient == null) {
                LOG.error("Person with id " + recipientId + " does not exist. Unable to send mail.");
                continue;
            }
            if (!recipient.canLogin()) continue;
            MailReceiver receiver = MailReceivers.forPerson(recipient, this._settings);
            EmailMessages mailMessages = this._i18nService.createProxy(EmailMessages.class, receiver.getLocale().getLanguage());
            ImmutableSet messageIds = FluentIterable.from((Iterable)entry.getValue()).transform(DBMailMessageInfo.TO_MESSAGE_ID).toSet();
            ImmutableList unreadMessages = Ordering.natural().nullsLast().onResultOf(ChatMessage.TO_CREATE_DATE).immutableSortedCopy((Iterable)this._messageReadWriteDataService.getMessagesByIds((ImmutableSet<ChatMessageId>)messageIds).values());
            ImmutableListMultimap unreadMultiMap = (ImmutableListMultimap)unreadMessages.stream().collect(ImmutableListMultimap.toImmutableListMultimap(ChatMessage::getConversationId, x -> x));
            this.sendMail((ListMultimap<ConversationId, ChatMessage>)unreadMultiMap, recipientId, receiver, conversations, persons, mailMessages);
        }
    }

    private void sendMail(ListMultimap<ConversationId, ChatMessage> messagesByConversation, PersonId recipientId, MailReceiver receiver, Map<ConversationId, Conversation> conversations, Map<PersonId, DBPerson> persons, EmailMessages mailMessages) {
        for (ConversationId conversationId : messagesByConversation.keySet()) {
            List conversationMessages = messagesByConversation.get((Object)conversationId);
            if (conversationMessages == null || conversationMessages.isEmpty()) continue;
            Conversation conversation = conversations.get(conversationId);
            if (conversation == null) {
                LOG.error("Could not find conversation with id " + conversationId + ". Unable to send mail.");
                continue;
            }
            this.sendMail(recipientId, receiver, mailMessages, conversation, persons, conversationMessages.size());
        }
    }

    private void sendMail(PersonId receiverId, MailReceiver mailReceiver, EmailMessages mailMessages, Conversation conversation, Map<PersonId, DBPerson> persons, int numberOfUnreadMessages) {
        String title = this._messageService.getConversationTitleForUser(conversation, receiverId, mailReceiver.getLocale().getLanguage(), persons);
        String subject = numberOfUnreadMessages == 1 ? mailMessages.oneNewMessageInConversation(title) : mailMessages.newMessagesInConversation(numberOfUnreadMessages, title);
        this._mailService.sendEmail(new NewChatMessageMailModelImpl(mailReceiver, subject, conversation.getId(), title, numberOfUnreadMessages));
    }

    @Nonnull
    private ImmutableSetMultimap<PersonId, ConversationId> getConversationIdsByPersonId(Iterable<DBMailMessageInfo> messages) {
        return (ImmutableSetMultimap)Streams.stream(messages).collect(ImmutableSetMultimap.toImmutableSetMultimap(DBMailMessageInfo::getRecipientId, DBMailMessageInfo::getConversationId));
    }

    @Nonnull
    private Predicate<DBMailMessageInfo> getRecipientFilter(Iterable<DBMailMessageInfo> messages) {
        final ImmutableSet<PersonId> notificationsEnabled = this._personService.getEmailNotificationEnabledPersons((Set<PersonId>)FluentIterable.from(messages).transform(DBMailMessageInfo.TO_RECIPIENT_ID).toSet());
        return new NullIsFalsePredicate<DBMailMessageInfo>(){

            @Override
            protected boolean applySafe(DBMailMessageInfo mailInfo) {
                return notificationsEnabled.contains(mailInfo.getRecipientId());
            }
        };
    }

    @Nonnull
    private Predicate<DBMailMessageInfo> getConversationFilter(Iterable<DBMailMessageInfo> messages) {
        final ImmutableTable<PersonId, ConversationId, ConversationSettings> allConversationSettings = this._messageService.getConversationsSettingsOrDefaults(this.getConversationIdsByPersonId(messages));
        return new NullIsFalsePredicate<DBMailMessageInfo>(){

            @Override
            protected boolean applySafe(DBMailMessageInfo mailInfo) {
                ConversationSettings conversationSettings = (ConversationSettings)allConversationSettings.get((Object)mailInfo.getRecipientId(), (Object)mailInfo.getConversationId());
                return conversationSettings != null && !conversationSettings.isMuted();
            }
        };
    }

    @ParametersAreNonnullByDefault
    private final class NewChatMessageMailModelImpl
    implements NewChatMessageMailModel {
        private final MailReceiver _receiver;
        private final String _subject;
        private final ConversationId _conversationId;
        private final String _title;
        private final int _numberOfUnreadMessages;

        public NewChatMessageMailModelImpl(MailReceiver receiver, String subject, ConversationId conversationId, String title, int numberOfUnreadMessages) {
            this._receiver = receiver;
            this._subject = subject;
            this._conversationId = conversationId;
            this._title = title;
            this._numberOfUnreadMessages = numberOfUnreadMessages;
        }

        @Override
        public String getSubject() {
            return this._subject;
        }

        @Override
        public MailReceiver getReceiver() {
            return this._receiver;
        }

        @Override
        public HeaderMailModel getHeader() {
            return NewChatMessageEmailSenderImpl.this._mailModelService.getHeaderMailModel();
        }

        @Override
        public FooterMailModel getFooter() {
            return NewChatMessageEmailSenderImpl.this._mailModelService.getFooterMailModel();
        }

        @Override
        public ThemeMailModel getTheme() {
            return NewChatMessageEmailSenderImpl.this._mailModelService.getThemeMailModel();
        }

        @Override
        public ConversationId getConversationId() {
            return this._conversationId;
        }

        @Override
        public String getTitle() {
            return this._title;
        }

        @Override
        public int getNumberOfUnreadMessages() {
            return this._numberOfUnreadMessages;
        }
    }
}

