/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.authorization.business.AuthorizationContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationKey;
import de.justsoftware.onx.authorization.business.ProfileReadRole;
import de.justsoftware.onx.chat.integration.admin.XmppService;
import de.justsoftware.onx.chat.integration.persistence.ChatAttachmentRepository;
import de.justsoftware.onx.chat.model.AttachmentChatMessage;
import de.justsoftware.onx.chat.model.AttachmentFilter;
import de.justsoftware.onx.chat.model.ChatAttachment;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.chat.model.ChatMessageType;
import de.justsoftware.onx.chat.model.ConversationControlMessage;
import de.justsoftware.onx.chat.model.ConversationControlMessageType;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.business.events.util.CollectingServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ImmediatelyFiringServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.server.model.HasMoreList;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.business.events.DriveDocumentsDeletedEvent;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import de.justsoftware.onx.message.business.ChatBotService;
import de.justsoftware.onx.message.business.MessageModelFactory;
import de.justsoftware.onx.message.business.MessageReadDataService;
import de.justsoftware.onx.message.business.MessageService;
import de.justsoftware.onx.message.business.MessageWriteDataService;
import de.justsoftware.onx.message.business.events.ChatMessageAddedOrDeletedEvent;
import de.justsoftware.onx.message.business.events.ConversationUpdatedEvent;
import de.justsoftware.onx.message.business.impl.ConversationPermissionService;
import de.justsoftware.onx.message.i18n.ConversationMessages;
import de.justsoftware.onx.message.integration.persistence.MessageDAO;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBChatAttachmentCreationModel;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversation;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationChange;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationUserGroup;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBMessageCreationModel;
import de.justsoftware.onx.message.model.ChatUserGroupMode;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.model.ConversationReadData;
import de.justsoftware.onx.message.model.ConversationSettings;
import de.justsoftware.onx.message.model.MessageLoadDirection;
import de.justsoftware.onx.message.model.MessagesSection;
import de.justsoftware.onx.message.shared.model.ChatMessageId;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.message.shared.model.ConversationType;
import de.justsoftware.onx.person.business.PersonReadDataService;
import de.justsoftware.onx.person.business.events.ConversationDeletedEvent;
import de.justsoftware.onx.person.business.events.PersonNameChangedEvent;
import de.justsoftware.onx.person.business.events.RemovedFromConversationEvent;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import de.justsoftware.onx.push.business.PushNotificationSendService;
import de.justsoftware.onx.tenant.business.PersonTenantService;
import de.justsoftware.onx.thumbor.business.ThumborService;
import de.justsoftware.onx.usergroup.business.UserGroupDeletionHandler;
import de.justsoftware.onx.usergroup.business.impl.UserGroupService;
import de.justsoftware.onx.usergroup.event.UserGroupMemberAddedEvent;
import de.justsoftware.onx.usergroup.event.UserGroupMemberRemovedEvent;
import de.justsoftware.onx.usergroup.model.UserGroup;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import de.justsoftware.toolbox.clock.Clock;
import de.justsoftware.toolbox.guava.collect.Multimaps2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class MessageServiceImpl
implements UserGroupDeletionHandler,
ServerEventHandler,
MessageService {
    private static final Logger LOG = LoggerFactory.getLogger(MessageServiceImpl.class);
    private static final long BOT_DELAY_MS = 750L;
    @Autowired
    private XmppService _xmppService;
    @Autowired
    private MessageReadDataService _messageReadDataService;
    @Autowired
    private MessageWriteDataService _messageWriteDataService;
    @Autowired
    private MessageDAO _messageDAO;
    @Autowired
    private MessageModelFactory _messageFactory;
    @Autowired
    private JCEventBus _eventBus;
    @Autowired
    private Settings _settings;
    @Autowired
    private PersonReadDataService _personService;
    @Autowired
    private PersonTenantService _personTenantService;
    @Autowired
    private ChatBotService _chatBotService;
    @Autowired
    private TransactionHelper _transactions;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private PushNotificationSendService _pushNotificationSendService;
    @Autowired
    private AuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private Clock _clock;
    @Autowired
    private ThumborService _thumborService;
    @Autowired
    private ChatAttachmentRepository _chatAttachmentRepository;
    @Autowired
    private UserGroupService _userGroupService;
    @Autowired
    private ConversationPermissionService _conversationPermissionService;
    @Autowired
    @Qualifier(value="distributeChatMessageExecutor")
    private TaskExecutor _distributeChatMessageExecutor;
    private final ScheduledExecutorService _chatBotExecutorService = Executors.newScheduledThreadPool(15);
    private ImmutableSet<String> _supportedImagesAndVideosContentTypes;
    private volatile DateTime _lastChatUserGroupModeUpdate;

    @PostConstruct
    public void buildSupportedImagesAndVideos() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this._thumborService.supportedImageTypes());
        builder.add((Object)"video/*");
        this._supportedImagesAndVideosContentTypes = builder.build();
    }

    @PostConstruct
    public void listenForSettingsUpdates() {
        this._lastChatUserGroupModeUpdate = this._clock.now();
        this._settings.getChatUserGroupModeProperty().addSuperopertyChangeListener(event -> {
            this._lastChatUserGroupModeUpdate = this._clock.now();
        });
    }

    @Override
    public Conversation getOrCreateConversation(ConversationType type, ImmutableSet<PersonId> participants, ImmutableSet<UserGroupId> userGroupIds, @Nullable String title, @Nullable UUID creationId, AuthorizationCheckContextWithUserId authContext) {
        authContext.check(StaticAction.CONNECT_USE);
        ImmutableCollection groupMembers = this._userGroupService.getUserGroupMembersByIds(userGroupIds).values();
        PersonId currentUser = authContext.getUserId();
        if (!participants.contains((Object)currentUser) && !groupMembers.contains((Object)currentUser)) {
            throw new IllegalArgumentException("You may not create a conversation without being a participant yourself!");
        }
        this.checkParticipants((Set<PersonId>)participants, (Set<PersonId>)participants, authContext, authContext.getTenantId());
        this.checkUserGroups(userGroupIds, userGroupIds, authContext, authContext.getTenantId());
        if (type == ConversationType.ONE_ON_ONE) {
            if (participants.size() != 2) {
                throw new IllegalArgumentException("Number of participants in a conversation of type ONE_ON_ONE must be 2!");
            }
            if (userGroupIds.size() > 0) {
                throw new IllegalArgumentException("Can't add user groups to ONE_ON_ONE chats!");
            }
            PersonId participant1 = (PersonId)Iterables.get(participants, (int)0);
            PersonId participant2 = (PersonId)Iterables.get(participants, (int)1);
            PersonId otherUser = currentUser.equals(participant1) ? participant2 : participant1;
            ImmutableSet<ConversationId> conversations = this._messageReadDataService.getOneOnOneConversationWithUser(currentUser, otherUser);
            if (conversations.isEmpty()) {
                return this.internalCreateConversation(type, (Set<PersonId>)participants, userGroupIds, null, creationId, authContext);
            }
            if (conversations.size() == 1) {
                ConversationId conversationId = (ConversationId)Iterables.getOnlyElement(conversations);
                authContext.check((ItemId)conversationId, (Action)StaticAction.CONVERSATION_READ);
                return this.getConversationById(conversationId, authContext);
            }
            return this.resolveDuplicateOneOnOneConversations(conversations, authContext);
        }
        if (StringUtil.isBlank(title)) {
            throw new IllegalArgumentException("Multi user conversations need to have a title!");
        }
        return this.internalCreateConversation(type, (Set<PersonId>)participants, userGroupIds, title.trim(), creationId, authContext);
    }

    @Nonnull
    private Conversation resolveDuplicateOneOnOneConversations(ImmutableSet<ConversationId> duplicates, AuthorizationCheckContextWithUserId authContext) throws IllegalStateException {
        ConversationId resolved;
        ImmutableSet withMessages = (ImmutableSet)duplicates.stream().filter(conversationId -> this._messageReadDataService.getMessagesByConversation((ConversationId)conversationId, null, 0, MessageLoadDirection.LOAD_NEWER_MESSAGES).isHasMore()).collect(ImmutableSet.toImmutableSet());
        ConversationId conversationId2 = withMessages.isEmpty() ? (ConversationId)Iterables.getFirst(duplicates, null) : (resolved = withMessages.size() == 1 ? (ConversationId)Iterables.getOnlyElement((Iterable)withMessages) : null);
        if (withMessages.size() < duplicates.size()) {
            this._transactions.doInTransactionWithoutResult(status -> duplicates.forEach(conversationId -> {
                if (conversationId != resolved && !withMessages.contains(conversationId)) {
                    this._messageDAO.deleteConversationSettings((ConversationId)conversationId);
                    this._messageDAO.deleteParticipants((ConversationId)conversationId);
                    this._messageWriteDataService.deleteConversation((ConversationId)conversationId);
                }
            }));
        }
        if (resolved == null) {
            throw new IllegalStateException("Got multiple conversations of type ONE_ON_ONE with the same two participants with existing messages. " + Arrays.toString(withMessages.toArray()));
        }
        authContext.check((ItemId)resolved, (Action)StaticAction.CONVERSATION_READ);
        return this.getConversationById(resolved, authContext);
    }

    @Nonnull
    private Conversation internalCreateConversation(ConversationType type, Set<PersonId> participants, ImmutableSet<UserGroupId> userGroupIds, @Nullable String title, @Nullable UUID creationId, AuthorizationCheckContextWithUserId authContext) {
        authContext.check(StaticAction.CONVERSATION_CREATE);
        PersonId creator = authContext.getUserId();
        TenantId tenant = authContext.getTenantId();
        DateTime now = this._clock.now();
        ImmutableList.Builder messagesToSend = ImmutableList.builder();
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        ConversationId conversationId = (ConversationId)this._transactions.doInTransaction(status -> {
            ConversationId newConversationId = this._messageWriteDataService.createNewConversation(type, participants, userGroupIds, title, now, creationId, tenant);
            if (type == ConversationType.MULTI_USER_CHAT) {
                DBMessageCreationModel messageCreationModel = this._messageFactory.createConversationCreatedNotificationModel(newConversationId, creator, title, now);
                ChatMessage message = this.insertMessageIntoDBAndDistributeViaPush(messageCreationModel, eventCollector, true);
                messagesToSend.add((Object)new SystemMessage(message, (Iterable<PersonId>)participants, (Iterable<UserGroupId>)userGroupIds));
            } else {
                this._messageWriteDataService.markConversationAsRead(creator, newConversationId, now);
            }
            return newConversationId;
        });
        Conversation conversation = this.getConversationById(conversationId, authContext);
        this._conversationPermissionService.addPermissionItemForNewConversation(conversationId, tenant);
        this._conversationPermissionService.publishPermissionsForConversation(conversationId, (ImmutableSet<PersonId>)ImmutableSet.copyOf(participants), userGroupIds);
        this._eventBus.post(ConversationUpdatedEvent.forNewConversation(conversation));
        eventCollector.fireEvents(this._eventBus);
        if (type == ConversationType.MULTI_USER_CHAT) {
            this._xmppService.enqueueCreateNodeTask(conversationId);
            this._xmppService.enqueueSubscribeTask(conversationId, (ImmutableList<PersonId>)ImmutableList.copyOf(participants));
        }
        this.distributeViaXmpp((ImmutableList<SystemMessage>)messagesToSend.build());
        return conversation;
    }

    private void checkParticipants(@Nullable Set<PersonId> allParticipants, Set<PersonId> newParticipants, AuthorizationCheckContextWithUserId authContext, TenantId conversationTenantId) {
        if (allParticipants == null || newParticipants.isEmpty()) {
            return;
        }
        this.checkNumberOfParticipants(allParticipants);
        ImmutableMap<PersonId, DBPerson> participantMap = this.checkParticipantsExist(allParticipants);
        this.checkNewParticipantsVisible(newParticipants, authContext);
        this.checkNewParticipantsAreInSameTenant(newParticipants, conversationTenantId);
        this.checkNewParticipantsAllowedToUseChat(newParticipants, participantMap);
    }

    private void checkNewParticipantsAreInSameTenant(Set<PersonId> newParticipants, TenantId conversationTenantId) {
        if (!this._personTenantService.areAllPersonsMembersOfTenant((ImmutableSet<PersonId>)ImmutableSet.copyOf(newParticipants), conversationTenantId)) {
            throw new PermissionDeniedException("At least one newly added user is not in the same tenant as the chat.");
        }
    }

    private void checkNewParticipantsAllowedToUseChat(Set<PersonId> participants, ImmutableMap<PersonId, DBPerson> participantMap) {
        Set authKeys = participants.stream().map(arg_0 -> participantMap.get(arg_0)).filter(Objects::nonNull).map(p -> new AuthorizationKey<Object, StaticAction>(null, (DBPerson)p, StaticAction.CONNECT_USE)).collect(Collectors.toSet());
        ImmutableSet authKeysFiltered = this._authorizationContextProvider.getPersonIndependentAuthorizationContext().may(authKeys);
        if (authKeysFiltered.size() < participants.size()) {
            throw new PermissionDeniedException("At least one other user is not allowed to use the chat.");
        }
    }

    private void checkNewParticipantsVisible(Set<PersonId> participants, AuthorizationCheckContextWithUserId authContext) throws PermissionDeniedException {
        ImmutableSet<ProfileId> visibleProfiles = authContext.filterRoles((ImmutableCollection<ProfileReadRole>)((ImmutableCollection)participants.stream().map(ProfileReadRole::of).collect(ImmutableSet.toImmutableSet())));
        if (visibleProfiles.size() < participants.size()) {
            throw new PermissionDeniedException("You are not allowed to chat with at least one other user");
        }
    }

    private void checkNumberOfParticipants(Set<PersonId> participants) throws ServiceException {
        int maxParticipants = this._settings.getMaxParticipantsInConversation();
        if (participants.size() > maxParticipants) {
            throw new IllegalArgumentException("A maximum of " + maxParticipants + " participants are allowed in a conversation.");
        }
    }

    @Nonnull
    private ImmutableMap<PersonId, DBPerson> checkParticipantsExist(Set<PersonId> participants) {
        ImmutableMap<PersonId, DBPerson> participantMap = this._personService.getPersonsByIds(participants);
        ImmutableSet existingPersons = participantMap.keySet();
        if (!existingPersons.containsAll(participants)) {
            throw new ServiceException("Can't start conversation with not existing user.");
        }
        return participantMap;
    }

    private void checkUserGroups(@Nullable ImmutableSet<UserGroupId> allUserGroups, ImmutableSet<UserGroupId> newUserGroups, AuthorizationCheckContextWithUserId authContext, TenantId conversationTenantId) {
        if (allUserGroups == null || newUserGroups.isEmpty()) {
            return;
        }
        this.checkUserGroupsCanBeAdded(newUserGroups);
        this._userGroupService.checkReadUserGroups(newUserGroups, authContext.getUserId());
        ImmutableMap<UserGroupId, UserGroup> userGroupMap = this.checkUserGroupsExist(allUserGroups);
        this.checkAllTenantUserGroupCanBeAdded(userGroupMap, newUserGroups);
        this.checkNewUserGroupsAreInSameTenant((ImmutableCollection<UserGroup>)userGroupMap.values(), conversationTenantId);
    }

    private void checkUserGroupsCanBeAdded(ImmutableSet<UserGroupId> newUserGroups) {
        if (this._settings.getChatUserGroupMode().equals((Object)ChatUserGroupMode.NO_USER_GROUPS) && !newUserGroups.isEmpty()) {
            throw new IllegalStateException("Adding of new user groups is not allowed while the feature toggle is disabled.");
        }
    }

    private void checkAllTenantUserGroupCanBeAdded(ImmutableMap<UserGroupId, UserGroup> userGroupMap, ImmutableSet<UserGroupId> newUserGroups) {
        boolean allTenantGroupIsAboutToBeAdded;
        if (this._settings.getChatUserGroupMode().equals((Object)ChatUserGroupMode.USER_GROUPS_WITHOUT_ALL_TENANT_GROUP) && (allTenantGroupIsAboutToBeAdded = userGroupMap.values().stream().filter(userGroup -> newUserGroups.contains((Object)userGroup.getGroupId())).anyMatch(UserGroup::getIsAllTenantUsersGroup))) {
            throw new IllegalStateException("Adding of the all tenant group is not allowed while the feature toggle is disabled.");
        }
    }

    private void checkNewUserGroupsAreInSameTenant(ImmutableCollection<UserGroup> newUserGroups, TenantId conversationTenantId) {
        Optional<TenantId> differentTenantId = newUserGroups.stream().map(UserGroup::getTenantId).filter(tenantId -> !tenantId.getId().equals(conversationTenantId.getId())).findAny();
        if (differentTenantId.isPresent()) {
            throw new PermissionDeniedException("At least one newly added user group is not in the same tenant as the chat.");
        }
    }

    @Nonnull
    private ImmutableMap<UserGroupId, UserGroup> checkUserGroupsExist(ImmutableSet<UserGroupId> userGroupIds) {
        ImmutableMap<UserGroupId, UserGroup> userGroupsMap = this._userGroupService.getUserGroupsByIds(userGroupIds);
        ImmutableSet existingUserGroups = userGroupsMap.keySet();
        if (!existingUserGroups.containsAll((Collection<?>)userGroupIds)) {
            throw new ServiceException("Can't start conversation with non-existent user groups.");
        }
        return userGroupsMap;
    }

    @Override
    public void updateConversationParticipants(ConversationId conversationId, @Nullable ImmutableSet<PersonId> participants, @Nullable ImmutableSet<UserGroupId> userGroups, @Nullable DateTime updateDate, AuthorizationCheckContextWithUserId authContext) {
        Conversation originalConversation = this.checkModifiable(conversationId, authContext);
        ImmutableSet<PersonId> originalParticipants = originalConversation.getParticipants();
        ImmutableSet<UserGroupId> originalUserGroups = originalConversation.getUserGroups();
        Changes<PersonId> participantChanges = new Changes<PersonId>((Set<PersonId>)originalParticipants, (Set<PersonId>)participants);
        this.checkParticipants((Set<PersonId>)participants, (Set<PersonId>)participantChanges.getAdded(), authContext, originalConversation.getTenantId());
        Changes<UserGroupId> userGroupChanges = new Changes<UserGroupId>((Set<UserGroupId>)originalUserGroups, (Set<UserGroupId>)userGroups);
        this.checkUserGroups(userGroups, userGroupChanges.getAdded(), authContext, originalConversation.getTenantId());
        if (participantChanges.hasChanges() || userGroupChanges.hasChanges()) {
            PersonId updatingPerson = authContext.getUserId();
            CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
            this._transactions.doInTransactionWithoutResult(status -> {
                if (userGroupChanges.hasChanges()) {
                    ImmutableSet removedMembers = ImmutableSet.copyOf((Collection)this._userGroupService.getUserGroupMembersByIds(userGroupChanges.getRemoved()).values());
                    this._messageWriteDataService.updateConversationUserGroups(conversationId, userGroupChanges.getRemoved(), userGroupChanges.getAdded(), (ImmutableSet<PersonId>)removedMembers, updateDate);
                }
                if (participantChanges.hasChanges()) {
                    this._messageWriteDataService.updateConversationParticipants(conversationId, (Set<PersonId>)participantChanges.getRemoved(), (Set<PersonId>)participantChanges.getAdded(), updateDate);
                }
                this.distributeSystemMessagesForParticipantUpdate(conversationId, updatingPerson, participantChanges, userGroupChanges, updateDate, eventCollector);
            });
            Changes<PersonId> effectiveParticipantChanges = this.getEffectiveParticipantChanges(participantChanges, userGroupChanges);
            this.notifyAboutParticipantsChanged(conversationId, participantChanges, userGroupChanges, effectiveParticipantChanges, eventCollector);
            this.sendNotificationsToRemovedUsers(conversationId, updatingPerson, effectiveParticipantChanges, eventCollector);
            eventCollector.fireEvents(this._eventBus);
        }
    }

    private void sendNotificationsToRemovedUsers(ConversationId conversationId, PersonId updatingPerson, Changes<PersonId> effectiveParticipantChanges, ServerEventCollector eventCollector) {
        ImmutableSet removedWithoutUpdatingPerson = (ImmutableSet)effectiveParticipantChanges.getRemoved().stream().filter(pId -> !pId.equals(updatingPerson)).collect(ImmutableSet.toImmutableSet());
        if (!removedWithoutUpdatingPerson.isEmpty()) {
            eventCollector.add(new RemovedFromConversationEvent((ImmutableSet<PersonId>)removedWithoutUpdatingPerson, updatingPerson, this.getDBConversationById(conversationId)));
        }
    }

    @Nonnull
    private Conversation checkModifiable(ConversationId id, AuthorizationCheckContextWithUserId authContext) {
        Conversation originalConversation = InvalidIdServiceException.check((Conversation)this._messageReadDataService.getConversationsByIds((Set<ConversationId>)ImmutableSet.of((Object)id)).get((Object)id));
        authContext.check(originalConversation, (Action)StaticAction.CONVERSATION_MODIFY);
        if (originalConversation.getType() == ConversationType.ONE_ON_ONE) {
            throw new IllegalStateException("One-on-one conversations may not be updated");
        }
        return originalConversation;
    }

    private void notifyAboutParticipantsChanged(ConversationId conversationId, Changes<PersonId> participantChanges, Changes<UserGroupId> userGroupChanges, Changes<PersonId> effectiveParticipantChanges, ServerEventCollector eventCollector) {
        if (participantChanges.hasChanges()) {
            this._xmppService.enqueueSubscribeTask(conversationId, (ImmutableList<PersonId>)ImmutableList.copyOf(participantChanges.getAdded()));
            this._xmppService.enqueueUnsubscribeTask(conversationId, (ImmutableList<PersonId>)ImmutableList.copyOf(participantChanges.getRemoved()));
        }
        if (participantChanges.hasChanges() || userGroupChanges.hasChanges()) {
            this._conversationPermissionService.publishPermissionsForConversation(conversationId, participantChanges.getNewData(), userGroupChanges.getNewData());
            this.pushChatUpdates(conversationId, effectiveParticipantChanges.getChanged());
            if (!effectiveParticipantChanges.getRemoved().isEmpty()) {
                this._xmppService.sendMessage(effectiveParticipantChanges.getRemoved(), new ConversationControlMessage(ConversationControlMessageType.YOU_WERE_REMOVED, conversationId));
            }
            eventCollector.add(ConversationUpdatedEvent.forParticipantUpdate(conversationId, participantChanges.getAdded(), participantChanges.getRemoved()));
        }
    }

    @Nonnull
    private Changes<PersonId> getEffectiveParticipantChanges(Changes<PersonId> participantChanges, Changes<UserGroupId> userGroupChanges) {
        ImmutableSetMultimap<UserGroupId, PersonId> loadedGroupMembers = this._userGroupService.getUserGroupMembersByIds((ImmutableSet<UserGroupId>)Sets.union(userGroupChanges.getOriginalData(), userGroupChanges.getNewData()).immutableCopy());
        ImmutableSet<PersonId> originalParticipants = participantChanges.getOriginalData();
        ImmutableSet<PersonId> originalMembers = MessageServiceImpl.getAll(loadedGroupMembers, userGroupChanges.getOriginalData());
        ImmutableSet<PersonId> newParticipants = participantChanges.getNewData();
        ImmutableSet<PersonId> newMembers = MessageServiceImpl.getAll(loadedGroupMembers, userGroupChanges.getNewData());
        return new Changes<PersonId>((Set<PersonId>)Sets.union(originalParticipants, originalMembers), (Set<PersonId>)Sets.union(newParticipants, newMembers));
    }

    private void distributeSystemMessagesForParticipantUpdate(ConversationId conversationId, PersonId updatingPerson, Changes<PersonId> participantChanges, Changes<UserGroupId> userGroupChanges, @Nullable DateTime updateDate, CollectingServerEventCollector eventCollector) {
        if (!participantChanges.hasChanges() && !userGroupChanges.hasChanges()) {
            return;
        }
        ImmutableList<SystemMessage> systemMessages = this.createSystemMessagesForParticipantsUpdate(conversationId, updatingPerson, participantChanges, userGroupChanges, updateDate);
        this.insertMessageIntoDBAndDistributeViaPush((Iterable<SystemMessage>)systemMessages, eventCollector);
        this.distributeViaXmpp(systemMessages);
    }

    @Nonnull
    private ChatMessage insertMessageIntoDBAndDistributeViaPush(DBMessageCreationModel message, ServerEventCollector eventCollector, boolean markAsRead) {
        ChatMessage insertedMessage = this.persist(message, markAsRead);
        eventCollector.add(new ChatMessageAddedOrDeletedEvent(insertedMessage));
        this.distributeWithPush(insertedMessage);
        return insertedMessage;
    }

    private void insertMessageIntoDBAndDistributeViaPush(Iterable<SystemMessage> messages, ServerEventCollector eventCollector) {
        messages.forEach(message -> {
            DBMessageCreationModel messageCreationModel = message.getMessageCreationModel();
            if (messageCreationModel == null) {
                return;
            }
            ChatMessage chatMessage = this.insertMessageIntoDBAndDistributeViaPush(messageCreationModel, eventCollector, true);
            message.replaceMessageCreationModel(chatMessage);
        });
    }

    @Nonnull
    private ChatMessage persist(DBMessageCreationModel message, boolean markAsRead) {
        ConversationId conversationId = message.getConversationId();
        boolean shouldBeMarkedAsRead = markAsRead || !this._messageReadDataService.isConversationUnreadForPerson(conversationId, message.getSentFrom());
        ChatMessage result = this._messageWriteDataService.insertNewMessage(message);
        if (shouldBeMarkedAsRead) {
            this.markChatAsRead(message);
        }
        this.unhideConversation(conversationId);
        return result;
    }

    private void markChatAsRead(DBMessageCreationModel message) {
        DateTime updateDate = message.getCreateDate();
        if (updateDate != null) {
            this._messageWriteDataService.markConversationAsRead(message.getSentFrom(), message.getConversationId(), updateDate);
        }
        this._messageWriteDataService.markConversationAsRead(message.getSentFrom(), message.getConversationId());
    }

    private void unhideConversation(ConversationId conversationId) {
        ImmutableSet conversationIds = ImmutableSet.of((Object)conversationId);
        Conversation conversation = (Conversation)this.getConversationsByIdsWithoutAuthorizationCheck((ImmutableCollection<ConversationId>)conversationIds).get((Object)conversationId);
        if (conversation != null) {
            ImmutableTable<PersonId, ConversationId, ConversationSettings> settings = this.getConversationSettings((Set<ConversationId>)conversationIds, (Set<PersonId>)conversation.getParticipants());
            Set<PersonId> usersWithHiddenConversation = Maps.filterValues((Map)settings.column((Object)conversationId), ConversationSettings::isHidden).keySet();
            if (usersWithHiddenConversation.isEmpty()) {
                return;
            }
            this._messageWriteDataService.unhideConversation(conversationId, usersWithHiddenConversation, this._clock.now());
        }
    }

    @Nonnull
    private ImmutableList<SystemMessage> createSystemMessagesForParticipantsUpdate(ConversationId id, PersonId updatingPerson, Changes<PersonId> participantChanges, Changes<UserGroupId> userGroupChanges, @Nullable DateTime updateDate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.createSystemMessageForAddedParticipants(id, updatingPerson, participantChanges, userGroupChanges, updateDate).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        this.createSystemMessageForSenderLeftChat(id, updatingPerson, participantChanges, userGroupChanges, updateDate).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        this.createSystemMessageForRemovedParticipants(id, updatingPerson, participantChanges, userGroupChanges, updateDate).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Nonnull
    private ImmutableSet<PersonId> getParticipantsInUserGroups(ImmutableSet<PersonId> participants, ImmutableSet<UserGroupId> userGroupIds) {
        HashSet userGroupPersonIds = new HashSet(this._userGroupService.getUserGroupMembersByIds(userGroupIds).values());
        return Sets.intersection(participants, userGroupPersonIds).immutableCopy();
    }

    @Nonnull
    private Optional<SystemMessage> createSystemMessageForAddedParticipants(ConversationId id, PersonId updatingPerson, Changes<PersonId> participantChanges, Changes<UserGroupId> userGroupChanges, @Nullable DateTime updateDate) {
        if (participantChanges.getAdded().isEmpty() && userGroupChanges.getAdded().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new SystemMessage(this._messageFactory.createAddedParticipantsMessageModel(id, updatingPerson, participantChanges.getAdded(), userGroupChanges.getAdded(), updateDate), (Iterable<PersonId>)participantChanges.getNewData(), (Iterable<UserGroupId>)userGroupChanges.getNewData()));
    }

    @Nonnull
    private Optional<SystemMessage> createSystemMessageForSenderLeftChat(ConversationId id, PersonId updatingPerson, Changes<PersonId> participantChanges, Changes<UserGroupId> userGroupChanges, @Nullable DateTime updateDate) {
        if (!participantChanges.getRemoved().contains((Object)updatingPerson)) {
            return Optional.empty();
        }
        boolean senderIsStayingInUserGroup = !this.getParticipantsInUserGroups((ImmutableSet<PersonId>)ImmutableSet.of((Object)updatingPerson), userGroupChanges.getNewData()).isEmpty();
        return Optional.of(new SystemMessage(this._messageFactory.createSenderLeftChatMessageModel(id, updatingPerson, senderIsStayingInUserGroup, updateDate), (Iterable<PersonId>)participantChanges.getNewData(), (Iterable<UserGroupId>)userGroupChanges.getNewData()));
    }

    @Nonnull
    private Optional<SystemMessage> createSystemMessageForRemovedParticipants(ConversationId id, PersonId updatingPerson, Changes<PersonId> participantChanges, Changes<UserGroupId> userGroupChanges, @Nullable DateTime updateDate) {
        ImmutableSet removedParticipantsWithoutUpdatingPerson = Sets.difference(participantChanges.getRemoved(), Set.of(updatingPerson)).immutableCopy();
        if (removedParticipantsWithoutUpdatingPerson.isEmpty() && userGroupChanges.getRemoved().isEmpty()) {
            return Optional.empty();
        }
        ImmutableSet<PersonId> removedParticipantsInUserGroups = this.getParticipantsInUserGroups((ImmutableSet<PersonId>)removedParticipantsWithoutUpdatingPerson, userGroupChanges.getNewData());
        return Optional.of(new SystemMessage(this._messageFactory.createRemovedParticipantsMessageModel(id, updatingPerson, (ImmutableSet<PersonId>)removedParticipantsWithoutUpdatingPerson, userGroupChanges.getRemoved(), removedParticipantsInUserGroups, updateDate), (Iterable<PersonId>)participantChanges.getNewData(), (Iterable<UserGroupId>)userGroupChanges.getNewData()));
    }

    @Nonnull
    private SystemMessage createSystemMessageForChangedTitle(Conversation conversation, PersonId updatingPerson, String oldTitle, String newTitle, @Nullable DateTime updateTime) {
        DBMessageCreationModel message = this._messageFactory.createConversationTitleChangedNotificationModel(conversation.getId(), updatingPerson, oldTitle, newTitle, conversation.getParticipants(), updateTime);
        return new SystemMessage(message, (Iterable<PersonId>)conversation.getParticipants(), (Iterable<UserGroupId>)conversation.getUserGroups());
    }

    @Nonnull
    private ImmutableTable<PersonId, ConversationId, ConversationSettings> getConversationSettings(Set<ConversationId> conversationIds, Set<PersonId> participants) {
        ImmutableSetMultimap participantConversations = Multimaps2.cartesianProduct(participants, conversationIds);
        return this.getConversationsSettingsOrDefaults((ImmutableSetMultimap<PersonId, ConversationId>)participantConversations);
    }

    @Override
    public Conversation getConversationById(ConversationId conversationId, AuthorizationCheckContext authContext) throws InvalidIdServiceException, PermissionDeniedException {
        Conversation conversation = this.getConversationById(conversationId);
        authContext.check(conversation, (Action)StaticAction.CONVERSATION_READ);
        return conversation;
    }

    @Nonnull
    private Conversation getConversationById(ConversationId conversationId) {
        return InvalidIdServiceException.check((Conversation)this._messageReadDataService.getConversationsByIds((Set<ConversationId>)ImmutableSet.of((Object)conversationId)).get((Object)conversationId));
    }

    @Nonnull
    private DBConversation getDBConversationById(ConversationId conversationId) {
        return (DBConversation)this._messageDAO.getDBConversationsByIds((Set<? extends ConversationId>)ImmutableSet.of((Object)conversationId)).stream().findFirst().get();
    }

    @Override
    public HasMoreList<ChatMessage> getMessagesByConversation(ConversationId conversationId, @Nullable DateTime offset, int limit, MessageLoadDirection direction, AuthorizationCheckContext authContext) {
        Conversation conversation = InvalidIdServiceException.check((Conversation)this._messageReadDataService.getConversationsByIds((Set<ConversationId>)ImmutableSet.of((Object)conversationId)).get((Object)conversationId));
        authContext.check(conversation, (Action)StaticAction.CONVERSATION_READ);
        return this._messageReadDataService.getMessagesByConversation(conversationId, offset, limit, direction);
    }

    @Override
    public ImmutableList<ChatMessage> getUpdatedMessagesForLoggedInUser(AuthorizationCheckContextWithUserId authContext, Set<ConversationId> conversationIds, @Nullable DateTime updatedSince, int limit) {
        ImmutableSet<ConversationId> visibleConversations = authContext.filterAllowedIds(conversationIds, StaticAction.CONVERSATION_READ);
        return this._messageReadDataService.getUpdatedMessages((Set<ConversationId>)visibleConversations, updatedSince, limit);
    }

    @Override
    public ImmutableMap<ConversationId, Conversation> getRecentConversationsForLoggedInUser(AuthorizationCheckContextWithUserId authContext, int offset, int limit) {
        return this._messageReadDataService.getRecentConversationsForUser(authContext.getUserId(), authContext.getTenantId(), offset, limit);
    }

    @Override
    public ImmutableMap<ConversationId, Conversation> getUpdatedConversationsForLoggedInUser(AuthorizationCheckContextWithUserId authContext, DateTime startingFrom) {
        return this._messageReadDataService.getUpdatedConversationsForUser(authContext.getUserId(), authContext.getTenantId(), startingFrom);
    }

    @Override
    public ImmutableList<DBConversationChange> getRecentConversationChangesForLoggedInUser(AuthorizationCheckContextWithUserId authContext, DateTime startingFrom) {
        return this._messageReadDataService.getRecentConversationChangesForUser(authContext.getUserId(), authContext.getTenantId(), startingFrom);
    }

    @Override
    public ImmutableMap<ConversationId, Conversation> getConversationsForLoggedInUser(ConversationType type, AuthorizationCheckContextWithUserId authContext, int offset, int limit) {
        return this._messageReadDataService.getConversationsForUser(type, authContext.getUserId(), authContext.getTenantId(), offset, limit);
    }

    @Override
    public ImmutableMap<ConversationId, ConversationReadData> getUnreadMessagesCountForConversations(AuthorizationCheckContextWithUserId authContext, ImmutableSet<ConversationId> conversations) {
        conversations.forEach(conversationId -> authContext.check((ItemId)conversationId, (Action)StaticAction.CONVERSATION_READ));
        return this._messageReadDataService.getUnreadMessagesCountForConversations(authContext.getUserId(), conversations);
    }

    @Override
    public DateTime markConversationAsRead(AuthorizationCheckContextWithUserId authContext, ConversationId conversationId) {
        return this.internalMarkConversationAsRead(authContext, conversationId, null);
    }

    @Override
    public void markConversationAsRead(AuthorizationCheckContextWithUserId authContext, ConversationId conversationId, DateTime readTime) {
        this.internalMarkConversationAsRead(authContext, conversationId, readTime);
    }

    @Nonnull
    private DateTime internalMarkConversationAsRead(AuthorizationCheckContextWithUserId authContext, ConversationId conversationId, @Nullable DateTime readTime) {
        boolean updated;
        authContext.check((ItemId)conversationId, (Action)StaticAction.CONVERSATION_READ);
        ConversationReadData readData = (ConversationReadData)this.getUnreadMessagesCountForConversations(authContext, (ImmutableSet<ConversationId>)ImmutableSet.of((Object)conversationId)).get((Object)conversationId);
        if (readData != null && readData.getUnreadCount() == 0) {
            return readData.getReadDate();
        }
        DateTime lastReadDate = readData != null ? readData.getReadDate() : new DateTime(0L);
        PersonId personId = authContext.getUserId();
        boolean bl = updated = readTime != null ? this._messageWriteDataService.markConversationAsRead(personId, conversationId, readTime) : this._messageWriteDataService.markConversationAsRead(personId, conversationId);
        if (updated) {
            this.publishConversationRead(conversationId, personId);
        }
        return lastReadDate;
    }

    private void publishConversationRead(ConversationId conversationId, PersonId personId) {
        this.pushChatUpdates(conversationId, (ImmutableSet<PersonId>)ImmutableSet.of((Object)personId));
        ConversationControlMessage controlMessage = new ConversationControlMessage(ConversationControlMessageType.MARK_CONVERSATION_AS_READ, new ConversationControlMessage.ConversationControlMessageParameters(conversationId));
        this._xmppService.sendMessage(personId, controlMessage);
    }

    @Override
    public ImmutableMap<ConversationId, Conversation> getConversationsByIds(ImmutableCollection<ConversationId> ids, AuthorizationCheckContextWithUserId authCtx) {
        return this._messageReadDataService.getConversationsByIds((Set<ConversationId>)authCtx.filterAllowedIds(ids, StaticAction.CONVERSATION_READ));
    }

    @Override
    public ImmutableMap<ConversationId, Conversation> getConversationsByIdsWithoutAuthorizationCheck(ImmutableCollection<ConversationId> ids) {
        return this._messageReadDataService.getConversationsByIds((Set<ConversationId>)ImmutableSet.copyOf(ids));
    }

    @Override
    public int getUnreadConversationsCountForPerson(PersonId personId, TenantId tenantId) {
        return this._messageReadDataService.getUnreadConversationsForPerson(personId, tenantId).size();
    }

    @Override
    public String getConversationTitleForUser(Conversation conversation, PersonId currentUserId, String locale, @Nullable Map<PersonId, DBPerson> preloadedPersons) {
        if (conversation.getType() == ConversationType.MULTI_USER_CHAT) {
            return (String)MoreObjects.firstNonNull((Object)conversation.getCustomTitle(), (Object)"");
        }
        ArrayList<PersonId> allParticipants = new ArrayList<PersonId>((Collection<PersonId>)conversation.getParticipants());
        allParticipants.addAll((Collection<PersonId>)conversation.getDeletedParticipants());
        if (allParticipants.size() < 2) {
            return this._i18nService.createProxy(ConversationMessages.class, locale).conversationTitleJustMe();
        }
        PersonId otherParticipant = currentUserId.equals(allParticipants.get(0)) ? allParticipants.get(1) : allParticipants.get(0);
        Map personCache = (Map)MoreObjects.firstNonNull(preloadedPersons, (Object)ImmutableMap.of());
        DBPerson otherPerson = (DBPerson)MoreObjects.firstNonNull((Object)((DBPerson)personCache.get(otherParticipant)), (Object)this._personService.getPersonById(otherParticipant));
        if (otherPerson.isDeleted()) {
            return this._i18nService.createProxy(ProfileConstants.class, locale).deletedUser();
        }
        return otherPerson.getFullName();
    }

    @Override
    public void updateMultiUserConversationTitle(AuthorizationCheckContextWithUserId authContext, ConversationId id, @Nullable String newTitle, @Nullable DateTime updateTime) {
        Conversation originalConversation = InvalidIdServiceException.check((Conversation)this._messageReadDataService.getConversationsByIds((Set<ConversationId>)ImmutableSet.of((Object)id)).get((Object)id));
        authContext.check(originalConversation, (Action)StaticAction.CONVERSATION_MODIFY);
        if (originalConversation.getType() == ConversationType.ONE_ON_ONE) {
            throw new IllegalStateException("One-on-one conversations may not be updated");
        }
        String trimmedOldTitle = ((String)MoreObjects.firstNonNull((Object)originalConversation.getCustomTitle(), (Object)"")).trim();
        String trimmedNewTitle = ((String)MoreObjects.firstNonNull((Object)newTitle, (Object)"")).trim();
        if (StringUtil.isBlank(trimmedNewTitle)) {
            throw new IllegalArgumentException("Multi user conversations need to have a title!");
        }
        if (!StringUtils.equals((String)trimmedOldTitle, (String)trimmedNewTitle)) {
            SystemMessage message = this.createSystemMessageForChangedTitle(originalConversation, authContext.getUserId(), trimmedOldTitle, trimmedNewTitle, updateTime);
            CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
            DBMessageCreationModel messageCreationModel = message.getMessageCreationModel();
            if (messageCreationModel == null) {
                return;
            }
            this._transactions.doInTransactionWithoutResult(status -> {
                this._messageWriteDataService.setConversationTitle(id, trimmedNewTitle);
                ChatMessage chatMessage = this.insertMessageIntoDBAndDistributeViaPush(messageCreationModel, eventCollector, true);
                message.replaceMessageCreationModel(chatMessage);
            });
            eventCollector.add(ConversationUpdatedEvent.forTitleUpdate(id, newTitle));
            this.distributeViaXmpp((ImmutableList<SystemMessage>)ImmutableList.of((Object)message));
            eventCollector.fireEvents(this._eventBus);
        }
    }

    @Override
    public ImmutableMap<ConversationId, ChatMessage> getLatestChatMessage(ImmutableCollection<ConversationId> ids, AuthorizationCheckContext authCtx) {
        ImmutableSet<ConversationId> visibleConversations = authCtx.filterAllowedIds(ids, StaticAction.CONVERSATION_READ);
        return this._messageReadDataService.getLatestChatMessage((Set<ConversationId>)visibleConversations);
    }

    @Override
    public ChatMessage addTextChatMessage(ConversationId conversationId, String message, @Nullable UUID creationId, boolean markAsRead, AuthorizationCheckContextWithUserId authCtx) {
        authCtx.check((ItemId)conversationId, (Action)StaticAction.CONVERSATION_MODIFY);
        DBMessageCreationModel chatMessageModel = this._messageFactory.createChatMessageModel(conversationId, authCtx.getUserId(), message, creationId);
        ChatMessage addedMessage = this.insertAndDistributeTextOrAttachmentMessage(chatMessageModel, authCtx, markAsRead);
        Conversation conversation = this.getConversationById(addedMessage.getConversationId(), authCtx);
        this.addChatBotResponseIfRequired(addedMessage, conversation, authCtx);
        return addedMessage;
    }

    @Override
    public ChatMessage addAttachmentChatMessage(ConversationId conversationId, ChatAttachment attachment, @Nullable UUID creationId, boolean markAsRead, AuthorizationCheckContextWithUserId authCtx) {
        authCtx.check((ItemId)conversationId, (Action)StaticAction.CONVERSATION_MODIFY);
        DBChatAttachmentCreationModel dbAttachment = new DBChatAttachmentCreationModel(attachment.getDocumentId(), attachment.getDocumentVersionId(), attachment.getFilename(), attachment.getSize(), attachment.getContentType(), attachment.getVersion(), attachment.getAttachmentType(), attachment.getImageWidth(), attachment.getImageHeight());
        DBMessageCreationModel attachmentChatMessageModel = this._messageFactory.createAttachmentChatMessageModel(conversationId, authCtx.getUserId(), dbAttachment, creationId);
        return this.insertAndDistributeTextOrAttachmentMessage(attachmentChatMessageModel, authCtx, markAsRead);
    }

    @Nonnull
    private ChatMessage insertAndDistributeTextOrAttachmentMessage(DBMessageCreationModel message, AuthorizationCheckContextWithUserId authCtx, boolean markAsRead) {
        ChatMessage insertedMessage = this.insertMessageIntoDBAndDistributeViaPush(message, new ImmediatelyFiringServerEventCollector(this._eventBus), markAsRead);
        Conversation conversation = this.getConversationById(insertedMessage.getConversationId(), authCtx);
        this.distributeViaXmpp(conversation, insertedMessage);
        return insertedMessage;
    }

    private void addChatBotResponseIfRequired(ChatMessage userMessage, Conversation conversation, AuthorizationCheckContextWithUserId userAuthCtx) {
        Optional<PersonId> chatBotPersonId = this._chatBotService.getChatBotPersonId();
        if (chatBotPersonId.isEmpty()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this._chatBotExecutorService.execute(() -> {
            try {
                Optional<String> response = this._chatBotService.getResponse(conversation, userMessage, userAuthCtx.getLocale());
                if (response.isEmpty()) {
                    return;
                }
                DBMessageCreationModel chatMessageModel = this._messageFactory.createChatMessageModel(conversation.getId(), (PersonId)chatBotPersonId.get(), response.get(), null);
                long timeRemaining = 750L - (System.currentTimeMillis() - startTime);
                if (timeRemaining > 0L) {
                    this._chatBotExecutorService.schedule(() -> this.insertAndDistributeTextOrAttachmentMessage(chatMessageModel, userAuthCtx, true), timeRemaining, TimeUnit.MILLISECONDS);
                } else {
                    this.insertAndDistributeTextOrAttachmentMessage(chatMessageModel, userAuthCtx, true);
                }
            }
            catch (RuntimeException e) {
                LOG.error("Error getting/posting response from chat bot", (Throwable)e);
            }
        });
    }

    @Nonnull
    private ChatMessage getMessageById(ChatMessageId id) throws InvalidIdServiceException {
        return InvalidIdServiceException.check((ChatMessage)this._messageReadDataService.getMessagesByIds((ImmutableSet<ChatMessageId>)ImmutableSet.of((Object)id)).get((Object)id));
    }

    @Override
    public MessagesSection getMessagesAroundId(ChatMessageId id, int limit, AuthorizationCheckContextWithUserId authContext) {
        ChatMessage msg = (ChatMessage)this._messageReadDataService.getMessagesByIds((ImmutableSet<ChatMessageId>)ImmutableSet.of((Object)id)).get((Object)id);
        InvalidIdServiceException.check(msg);
        authContext.check((ItemId)msg.getConversationId(), (Action)StaticAction.CONVERSATION_READ);
        HasMoreList<ChatMessage> messagesBefore = this._messageReadDataService.getMessagesByConversation(msg.getConversationId(), msg.getCreateDate(), limit, MessageLoadDirection.LOAD_OLDER_MESSAGES);
        HasMoreList<ChatMessage> messagesAfter = this._messageReadDataService.getMessagesByConversation(msg.getConversationId(), msg.getCreateDate(), limit, MessageLoadDirection.LOAD_NEWER_MESSAGES);
        return new MessagesSection(messagesBefore, messagesAfter, msg);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onParticipantNameChangedEvent(PersonNameChangedEvent event) {
        ImmutableSet activeConversationsOfPerson = this._messageReadDataService.getConversationIdsByParticipants((Set<PersonId>)ImmutableSet.of((Object)event.getPersonId())).get((Object)event.getPersonId());
        for (ConversationId conversationId : activeConversationsOfPerson) {
            this._eventBus.post(ConversationUpdatedEvent.forUnspecificUpdate(conversationId));
        }
    }

    @Override
    public ImmutableList<ConversationSettings> getUpdatedConversationSettingsForLoggedInUser(AuthorizationContextWithUserId authCtx, DateTime since) {
        return this._messageReadDataService.getUpdatedConversationSettings(authCtx.getUserId(), authCtx.getTenantId(), since);
    }

    @Override
    public ImmutableSet<PersonId> getUpdatedPersonsForLoggedInUser(AuthorizationContextWithUserId authCtx, ImmutableSet<ConversationId> recentlyJoinedConversations, DateTime since) {
        PersonId userId = authCtx.getUserId();
        ImmutableSet<PersonId> updatedPersons = this._messageReadDataService.getUpdatedPersonsForUser(userId, authCtx.getTenantId(), since);
        ImmutableSet<PersonId> participantsOfRecentlyJoinedConversations = this._messageReadDataService.getDirectParticipantIdsByConversationIds((Set<ConversationId>)recentlyJoinedConversations);
        DBPerson user = this._personService.getPersonById(userId);
        ImmutableSet.Builder allUpdatedPersons = ImmutableSet.builder();
        allUpdatedPersons.addAll(updatedPersons);
        allUpdatedPersons.addAll(participantsOfRecentlyJoinedConversations);
        if (user != null && new DateTime((Object)user.getModifyDate()).isAfter((ReadableInstant)since)) {
            allUpdatedPersons.add((Object)userId);
        }
        return allUpdatedPersons.build();
    }

    @Override
    public ImmutableSet<UserGroupId> getUpdatedUserGroupsForLoggedInUser(AuthorizationContextWithUserId authCtx, ImmutableSet<ConversationId> recentlyJoinedConversations, DateTime since) {
        PersonId userId = authCtx.getUserId();
        TenantId tenantId = authCtx.getTenantId();
        ImmutableSet<UserGroupId> updatedUserGroups = this._messageReadDataService.getUpdatedUserGroupsForUser(userId, tenantId, since);
        ImmutableSet<UserGroupId> userGroupsOfRecentlyJoinedConversations = this._messageReadDataService.getUserGroupIdsByConversations(recentlyJoinedConversations);
        UserGroup allGroup = since.isBefore((ReadableInstant)this._lastChatUserGroupModeUpdate) ? this._userGroupService.getAllUsersGroup(tenantId) : null;
        ImmutableSet.Builder allUpdatedGroups = ImmutableSet.builder().addAll(updatedUserGroups).addAll(userGroupsOfRecentlyJoinedConversations);
        if (allGroup != null) {
            allUpdatedGroups.add((Object)allGroup.getGroupId());
        }
        return allUpdatedGroups.build();
    }

    @Override
    public ImmutableSet<ConversationId> getRecentlyJoinedConversations(AuthorizationContextWithUserId authCtx, DateTime since) {
        return this._messageReadDataService.getRecentlyJoinedConversations(authCtx.getUserId(), authCtx.getTenantId(), since);
    }

    @Override
    public ImmutableMap<ConversationId, Conversation> getOneOnOneConversationsWithUpdatedUsersForLoggedInUser(AuthorizationContextWithUserId authCtx, DateTime since) {
        return this._messageReadDataService.getOneOnOneConversationsWithUpdatedUsers(authCtx.getUserId(), authCtx.getTenantId(), since);
    }

    @Override
    public HasMoreList<AttachmentChatMessage> getConversationAttachments(ConversationId conversationId, int limit, @Nullable DateTime offset, @Nullable AttachmentFilter filter, AuthorizationCheckContextWithUserId authContext) {
        authContext.check((ItemId)conversationId, (Action)StaticAction.CONVERSATION_READ);
        HasMoreList<ChatMessage> messages = this.getConversationAttachmentsFiltered(conversationId, (AttachmentFilter)((Object)MoreObjects.firstNonNull((Object)((Object)filter), (Object)((Object)AttachmentFilter.ALL))), limit, offset);
        return new HasMoreList<AttachmentChatMessage>((ImmutableList)messages.getSubList().stream().filter(AttachmentChatMessage.class::isInstance).map(AttachmentChatMessage.class::cast).collect(ImmutableList.toImmutableList()), messages.isHasMore());
    }

    @Nonnull
    private HasMoreList<ChatMessage> getConversationAttachmentsFiltered(ConversationId conversationId, AttachmentFilter filter, int limit, @Nullable DateTime offset) {
        switch (filter) {
            case ALL: {
                return this._messageReadDataService.getAttachmentMessagesByConversation(conversationId, limit, offset);
            }
            case IMAGES: {
                return this._messageReadDataService.getAttachmentMessagesByConversationFiltered(conversationId, limit, offset, this._thumborService.supportedImageTypes());
            }
            case VIDEOS: {
                return this._messageReadDataService.getAttachmentMessagesByConversationFiltered(conversationId, limit, offset, (ImmutableSet<String>)ImmutableSet.of((Object)"video/*"));
            }
            case MEDIA: {
                return this._messageReadDataService.getAttachmentMessagesByConversationFiltered(conversationId, limit, offset, this._supportedImagesAndVideosContentTypes);
            }
            case DOCUMENTS: {
                return this._messageReadDataService.getAttachmentMessagesByConversationExcluded(conversationId, limit, offset, this._supportedImagesAndVideosContentTypes);
            }
        }
        throw new ServiceException("Unexpected attachment filter " + filter);
    }

    @Override
    public ChatMessage getMessageById(ChatMessageId messageId, AuthorizationCheckContextWithUserId authContext) {
        ChatMessage message = this.getMessageById(messageId);
        authContext.check((ItemId)message.getConversationId(), (Action)StaticAction.CONVERSATION_READ);
        return message;
    }

    @Override
    public ImmutableMap<ConversationId, ConversationSettings> getConversationsSettingsOrDefaults(ImmutableSet<ConversationId> conversationIds, AuthorizationCheckContextWithUserId authContext) {
        ImmutableSet<ConversationId> allowedConversationIds = authContext.filterAllowedIds(conversationIds, StaticAction.CONVERSATION_READ);
        if (allowedConversationIds.isEmpty()) {
            return ImmutableMap.of();
        }
        PersonId participantId = authContext.getUserId();
        ImmutableSetMultimap params = ImmutableSetMultimap.builder().putAll((Object)participantId, allowedConversationIds).build();
        ImmutableTable<PersonId, ConversationId, ConversationSettings> settingsTable = this.getConversationsSettingsOrDefaults((ImmutableSetMultimap<PersonId, ConversationId>)params);
        return settingsTable.row((Object)participantId);
    }

    @Override
    public ImmutableTable<PersonId, ConversationId, ConversationSettings> getConversationsSettingsOrDefaults(ImmutableSetMultimap<PersonId, ConversationId> participantConversations) {
        ImmutableTable<PersonId, ConversationId, ConversationSettings> settingsTable = this._messageReadDataService.getConversationsSettings(participantConversations);
        ImmutableMap<PersonId, DBPerson> personsByIds = this._personService.getPersonsByIds((Set<PersonId>)participantConversations.keySet());
        ImmutableTable.Builder resultTableBuilder = ImmutableTable.builder();
        resultTableBuilder.putAll(settingsTable);
        for (Map.Entry participantConversation : participantConversations.entries()) {
            PersonId participantId = (PersonId)participantConversation.getKey();
            ConversationId conversationId = (ConversationId)participantConversation.getValue();
            DBPerson person = (DBPerson)personsByIds.get((Object)participantId);
            if (settingsTable.contains((Object)participantId, (Object)conversationId) || person == null) continue;
            resultTableBuilder.put((Object)participantId, (Object)conversationId, (Object)MessageServiceImpl.createDefaultConversationSettings(conversationId, person));
        }
        return resultTableBuilder.build();
    }

    @Override
    public void setConversationSettings(ConversationSettings settings, AuthorizationCheckContextWithUserId authContext) {
        boolean muteUpdated;
        ConversationId conversationId = settings.getConversationId();
        authContext.check((ItemId)conversationId, (Action)StaticAction.CONVERSATION_READ);
        PersonId participantId = authContext.getUserId();
        ConversationSettings currentSettings = (ConversationSettings)this._messageReadDataService.getConversationsSettings((ImmutableSetMultimap<PersonId, ConversationId>)ImmutableSetMultimap.of((Object)participantId, (Object)conversationId)).get((Object)participantId, (Object)conversationId);
        DateTime now = this._clock.now();
        ConversationSettings newSettings = new ConversationSettings(conversationId, participantId, settings.isMuted(), settings.isHidden(), now);
        if (currentSettings != null) {
            this._messageWriteDataService.updateConversationSettings(newSettings, now);
            muteUpdated = currentSettings.isMuted() != newSettings.isMuted();
        } else {
            this._messageWriteDataService.insertConversationSettings(newSettings, now, now);
            boolean bl = muteUpdated = newSettings.isMuted();
        }
        if (muteUpdated) {
            this.pushChatUpdates(conversationId, (ImmutableSet<PersonId>)ImmutableSet.of((Object)participantId));
            ConversationControlMessage controlMessage = new ConversationControlMessage(ConversationControlMessageType.CONVERSATION_SETTINGS_CHANGED, new ConversationControlMessage.ConversationControlMessageParameters(conversationId, newSettings));
            this._xmppService.sendMessage(participantId, controlMessage);
        }
    }

    @Override
    public void deleteAllConversationsForTenantUnauthorized(TenantId tenantId) {
        this._messageReadDataService.getConversationIdsOfTenant(tenantId).forEach(conversationId -> {
            Conversation conversation = (Conversation)this._messageReadDataService.getConversationsByIds((Set<ConversationId>)ImmutableSet.of((Object)conversationId)).get(conversationId);
            ImmutableSet<UserGroupId> userGroups = conversation == null ? ImmutableSet.of() : conversation.getUserGroups();
            ImmutableSet<PersonId> groupMembers = MessageServiceImpl.getAll(this._userGroupService.getUserGroupMembersByIds(userGroups), userGroups);
            this._messageWriteDataService.updateConversationParticipantsAsDeletedWithConversation((ConversationId)conversationId);
            this._messageWriteDataService.updateConversationUserGroupsAsDeletedWithConversation((ConversationId)conversationId, groupMembers);
            this._xmppService.enqueueDeleteNodeTask((ConversationId)conversationId);
            this._conversationPermissionService.deletePermissionsForDeletedConversation((ConversationId)conversationId);
        });
    }

    @Override
    public void updateConversationForTenantChange(PersonId user, ImmutableSet<TenantId> tenantIds, KafkaConsumerContext context) {
        ImmutableSet conversationsToLeave = (ImmutableSet)this._messageReadDataService.getAllConversationsByDirectParticipant(user).stream().filter(conversation -> !tenantIds.contains((Object)conversation.getTenantId())).collect(ImmutableSet.toImmutableSet());
        if (conversationsToLeave.isEmpty()) {
            return;
        }
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        ImmutableSet removed = ImmutableSet.of((Object)user);
        conversationsToLeave.forEach(conversation -> {
            this._messageWriteDataService.updateConversationParticipants(conversation.getId(), (Set<PersonId>)removed, (Set<PersonId>)ImmutableSet.of(), null);
            Changes<PersonId> participantChanges = new Changes<PersonId>(conversation.getParticipants(), ImmutableSet.of(), removed);
            context.afterCommit(() -> {
                Changes<UserGroupId> userGroupChanges = Changes.noChanges(conversation.getUserGroups());
                Changes<PersonId> effectiveParticipantChanges = this.getEffectiveParticipantChanges(participantChanges, userGroupChanges);
                this.notifyAboutParticipantsChanged(conversation.getId(), participantChanges, userGroupChanges, effectiveParticipantChanges, eventCollector);
            });
        });
        context.afterCommit(() -> eventCollector.fireEvents(this._eventBus));
    }

    @Override
    public void deleteConversation(ConversationId conversationId, AuthorizationCheckContextWithUserId authContext) {
        Conversation originalConversation = InvalidIdServiceException.check((Conversation)this._messageReadDataService.getConversationsByIds((Set<ConversationId>)ImmutableSet.of((Object)conversationId)).get((Object)conversationId));
        authContext.check(originalConversation, (Action)StaticAction.CONVERSATION_DELETE);
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        PersonId deletingPerson = authContext.getUserId();
        ImmutableSet<UserGroupId> userGroups = originalConversation.getUserGroups();
        ImmutableSetMultimap<UserGroupId, PersonId> loadedGroupMembers = this._userGroupService.getUserGroupMembersByIds(userGroups);
        ImmutableSet<PersonId> allGroupMembers = MessageServiceImpl.getAll(loadedGroupMembers, userGroups);
        ImmutableSet effectiveParticipants = Sets.union(originalConversation.getParticipants(), MessageServiceImpl.getAll(loadedGroupMembers, userGroups)).immutableCopy();
        ImmutableSet deletedParticipants = (ImmutableSet)this._transactions.doInTransaction(status -> {
            this._messageWriteDataService.updateConversationParticipantsAsDeletedWithConversation(conversationId);
            this._messageWriteDataService.updateConversationUserGroupsAsDeletedWithConversation(conversationId, allGroupMembers);
            DBMessageCreationModel conversationDeletedMessage = this._messageFactory.createConversationDeletedChatMessageModel(conversationId, deletingPerson);
            this.pushChatUpdates(conversationId, (ImmutableSet<PersonId>)effectiveParticipants);
            this.insertMessageIntoDBAndDistributeViaPush(conversationDeletedMessage, eventCollector, true);
            ImmutableSet toBeNotified = (ImmutableSet)effectiveParticipants.stream().filter(p -> !p.equals(deletingPerson)).collect(ImmutableSet.toImmutableSet());
            eventCollector.add(new ConversationDeletedEvent((ImmutableSet<PersonId>)toBeNotified, deletingPerson, originalConversation));
            return effectiveParticipants;
        });
        this._conversationPermissionService.deletePermissionsForDeletedConversation(conversationId);
        eventCollector.add(ConversationUpdatedEvent.forParticipantUpdate(conversationId, (Set<PersonId>)ImmutableSet.of(), (Set<PersonId>)deletedParticipants));
        eventCollector.fireEvents(this._eventBus);
        this._xmppService.enqueueDeleteNodeTask(conversationId);
        ConversationControlMessage youWereDeletedControlMessage = new ConversationControlMessage(ConversationControlMessageType.YOU_WERE_REMOVED, conversationId);
        this._xmppService.sendMessage((ImmutableSet<PersonId>)deletedParticipants, youWereDeletedControlMessage);
    }

    @Override
    public ChatMessage deleteMessage(ChatMessageId messageId, AuthorizationCheckContextWithUserId authContext) {
        authContext.check((ItemId)messageId, (Action)StaticAction.CHAT_MESSAGE_DELETE);
        ChatMessage message = this.getMessageById(messageId);
        this.deleteAttachedDriveDocumentIfApplicable(message, authContext);
        return this.internalDeleteAndDistributeMessage(message);
    }

    private void deleteAttachedDriveDocumentIfApplicable(ChatMessage message, AuthorizationCheckContextWithUserId authContext) throws ServiceException {
        if (!(message instanceof AttachmentChatMessage)) {
            return;
        }
        AttachmentChatMessage attachmentMessage = (AttachmentChatMessage)message;
        boolean messageDeleted = this._chatAttachmentRepository.deleteByDocumentId(attachmentMessage.getAttachment().getDocumentId(), authContext);
        if (!messageDeleted) {
            throw new ServiceException("Could not delete Drive document for message with ID " + message.getId());
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onDocumentsDeleted(@Nonnull DriveDocumentsDeletedEvent event) {
        this._messageReadDataService.getMessagesByDocumentIds(event.getDocumentIds()).forEach(message -> {
            try {
                this.internalDeleteAndDistributeMessage((ChatMessage)message);
            }
            catch (RuntimeException e) {
                LOG.error("Error deleting chat message with ID " + message.getId() + " for deleted Drive document", (Throwable)e);
            }
        });
    }

    @Nonnull
    private ChatMessage internalDeleteAndDistributeMessage(ChatMessage message) {
        ChatMessageType messageType = message.getType();
        if (messageType == ChatMessageType.DELETED_CHAT_MESSAGE) {
            return message;
        }
        if (messageType != ChatMessageType.CHAT_MESSAGE && messageType != ChatMessageType.ATTACHMENT_CHAT_MESSAGE) {
            throw new IllegalStateException("Only text or attachment messages may be deleted.");
        }
        ChatMessage deletedMessage = InvalidIdServiceException.check(this._messageWriteDataService.updateMessageAsDeleted(message.getId(), ChatMessageType.DELETED_CHAT_MESSAGE));
        this._eventBus.post(new ChatMessageAddedOrDeletedEvent(deletedMessage));
        Conversation conversation = this.getConversationById(deletedMessage.getConversationId());
        this.pushChatUpdates(conversation.getId(), conversation.getParticipants());
        this.distributeViaXmpp(conversation, deletedMessage);
        return deletedMessage;
    }

    @Override
    public DateTime getChatTime() {
        return this._messageReadDataService.getChatTime();
    }

    @Override
    public void createAndSendSystemMessageForDeletedPersons(PersonId deletedPersonId, Collection<ConversationId> conversationIds) {
        ImmutableMap<ConversationId, Conversation> conversationsByIds = this._messageReadDataService.getConversationsByIds((Set<ConversationId>)ImmutableSet.copyOf(conversationIds));
        ImmediatelyFiringServerEventCollector eventCollector = new ImmediatelyFiringServerEventCollector(this._eventBus);
        ImmutableList messages = (ImmutableList)conversationsByIds.entrySet().stream().map(entry -> {
            ConversationId conversationId = (ConversationId)entry.getKey();
            Conversation conversation = (Conversation)entry.getValue();
            Set<PersonId> remainingParticipants = conversation.getParticipants().stream().filter(personId -> !deletedPersonId.equals(personId)).collect(Collectors.toSet());
            return new SystemMessage(this._messageFactory.createPersonsDeletedChatMessageModel(conversationId, deletedPersonId), (Iterable<PersonId>)remainingParticipants, (Iterable<UserGroupId>)conversation.getUserGroups());
        }).collect(ImmutableList.toImmutableList());
        this.insertMessageIntoDBAndDistributeViaPush((Iterable<SystemMessage>)messages, eventCollector);
        this.distributeViaXmpp((ImmutableList<SystemMessage>)messages);
    }

    private void distributeViaXmpp(ImmutableList<SystemMessage> messagesToDispatch) {
        this._transactions.doAfterTransaction(() -> messagesToDispatch.forEach(notificationModel -> {
            ChatMessage message = notificationModel.getMessage();
            if (message == null) {
                return;
            }
            ConversationId conversationId = message.getConversationId();
            Conversation conversation = (Conversation)this._messageReadDataService.getConversationsByIds((Set<ConversationId>)ImmutableSet.of((Object)conversationId)).get((Object)conversationId);
            this.distributeViaXmpp(conversation, (Set<PersonId>)notificationModel.getDirectXmppRecipients(), (Set<UserGroupId>)notificationModel.getUserGroupXmppRecipients(), message);
        }));
    }

    private void distributeViaXmpp(Conversation conversation, Set<PersonId> directRecipients, Set<UserGroupId> userGroupRecipients, ChatMessage message) {
        if (conversation.getType() == ConversationType.MULTI_USER_CHAT && this._settings.isChatViaPubSubEnabled()) {
            this._xmppService.enqueueSendMessageTask(conversation.getId(), message.getId());
            userGroupRecipients.forEach(groupId -> this._xmppService.enqueueSendMessageTask((UserGroupId)groupId, message.getId()));
        } else {
            this._distributeChatMessageExecutor.execute(() -> this._xmppService.sendMessage(directRecipients, message));
        }
    }

    private void distributeViaXmpp(Conversation conversation, ChatMessage message) {
        this.distributeViaXmpp(conversation, (Set<PersonId>)conversation.getParticipants(), (Set<UserGroupId>)conversation.getUserGroups(), message);
    }

    private void distributeWithPush(ChatMessage message) {
        this._distributeChatMessageExecutor.execute(() -> this._pushNotificationSendService.sendChatMessage(message));
    }

    private void pushChatUpdates(ConversationId conversationId, ImmutableSet<PersonId> recipients) {
        if (recipients.isEmpty()) {
            return;
        }
        this._distributeChatMessageExecutor.execute(() -> this._pushNotificationSendService.sendChatUpdate(conversationId, (Set<PersonId>)recipients));
    }

    @Nonnull
    private static ConversationSettings createDefaultConversationSettings(ConversationId conversationId, DBPerson person) {
        DateTime createDate = new DateTime(person.getCreateDate().getTime());
        return new ConversationSettings(conversationId, person.getId(), false, false, createDate);
    }

    @Override
    public void checkAuthorsOfConversation(ConversationId conversationId, ImmutableSet<PersonId> authorIds) throws InvalidIdServiceException {
        ImmutableSet<PersonId> filteredAuthorIds = this._messageReadDataService.filterConversationAuthors(conversationId, authorIds);
        Sets.SetView nonAuthorIds = Sets.difference(authorIds, filteredAuthorIds);
        if (!nonAuthorIds.isEmpty()) {
            throw new InvalidIdServiceException("Following ids [" + Joiner.on((String)",").join((Iterable)nonAuthorIds) + "] are not authors of the conversation " + conversationId);
        }
    }

    @Override
    public void handleCascadeDelete(UserGroupId deletedUserGroupId, ServerEventCollector eventCollector) throws ServiceException {
        ImmutableSet<DBConversationUserGroup> dbConversationUserGroups = this._messageReadDataService.deleteUserGroupsFromAllConversations((ImmutableSet<UserGroupId>)ImmutableSet.of((Object)deletedUserGroupId));
        Map<ConversationId, List<DBConversationUserGroup>> groupByConversationIds = dbConversationUserGroups.stream().collect(Collectors.groupingBy(DBConversationUserGroup::getConversationId));
        ImmutableMap<ConversationId, Conversation> conversationsByIds = this._messageReadDataService.getConversationsByIds(groupByConversationIds.keySet());
        ImmutableList.Builder systemMessageBuilder = new ImmutableList.Builder();
        PersonId deletedUserPersonId = new PersonId(-1L);
        groupByConversationIds.forEach((conversationId, deletedConversationUserGroups) -> {
            Conversation conversation = (Conversation)conversationsByIds.get(conversationId);
            ImmutableSet removedGroupIds = (ImmutableSet)deletedConversationUserGroups.stream().map(DBConversationUserGroup::getUserGroupId).collect(ImmutableSet.toImmutableSet());
            Changes<PersonId> participantChanges = new Changes<PersonId>((Set<PersonId>)conversation.getParticipants(), null);
            Changes<UserGroupId> userGroupChanges = new Changes<UserGroupId>((Set<UserGroupId>)Sets.union(conversation.getUserGroups(), (Set)removedGroupIds), (Set<UserGroupId>)conversation.getUserGroups());
            Changes<PersonId> effectiveParticipantChanges = this.getEffectiveParticipantChanges(participantChanges, userGroupChanges);
            this.notifyAboutParticipantsChanged(conversation.getId(), participantChanges, userGroupChanges, effectiveParticipantChanges, eventCollector);
            ImmutableSet remainingUserGroups = Sets.difference(conversation.getUserGroups(), (Set)ImmutableSet.of((Object)deletedUserGroupId)).immutableCopy();
            systemMessageBuilder.add((Object)new SystemMessage(this._messageFactory.createUserGroupDeletedChatMessageModel(conversation.getId(), deletedUserPersonId, deletedUserGroupId), (Iterable<PersonId>)conversation.getParticipants(), (Iterable<UserGroupId>)remainingUserGroups));
        });
        ImmutableList messages = systemMessageBuilder.build();
        this.insertMessageIntoDBAndDistributeViaPush((Iterable<SystemMessage>)messages, eventCollector);
        this.distributeViaXmpp((ImmutableList<SystemMessage>)messages);
    }

    @Subscribe
    public void onUserGroupMemberAddedEvent(UserGroupMemberAddedEvent event) {
        ImmutableSetMultimap<UserGroupId, PersonId> allAddedMembers = event.getAddedMembers();
        ImmutableSetMultimap<UserGroupId, ConversationId> conversationIdsByUserGroupIds = this._messageReadDataService.getConversationIdsByUserGroupIds((ImmutableSet<UserGroupId>)allAddedMembers.keySet());
        conversationIdsByUserGroupIds.inverse().asMap().forEach((conversationId, userGroupIds) -> {
            ImmutableSet addedMembers = (ImmutableSet)userGroupIds.stream().map(arg_0 -> ((ImmutableSetMultimap)allAddedMembers).get(arg_0)).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
            this.pushChatUpdates((ConversationId)conversationId, (ImmutableSet<PersonId>)addedMembers);
            this._xmppService.sendMessage((ImmutableSet<PersonId>)addedMembers, new ConversationControlMessage(ConversationControlMessageType.YOU_WERE_ADDED, (ConversationId)conversationId));
        });
    }

    @Subscribe
    public void onUserGroupMemberRemovedEvent(UserGroupMemberRemovedEvent event) {
        ImmutableSetMultimap<UserGroupId, PersonId> allRemovedMembers = event.getRemovedMembers();
        ImmutableSetMultimap<UserGroupId, ConversationId> conversationIdsByUserGroupIds = this._messageReadDataService.getConversationIdsByUserGroupIds((ImmutableSet<UserGroupId>)allRemovedMembers.keySet());
        ImmutableMap<ConversationId, Conversation> conversationsByIds = this._messageReadDataService.getConversationsByIds((Set<ConversationId>)ImmutableSet.copyOf((Collection)conversationIdsByUserGroupIds.values()));
        ImmutableSetMultimap<UserGroupId, PersonId> loadedUserGroupMemberships = this._userGroupService.getUserGroupMembersByIds((ImmutableSet<UserGroupId>)((ImmutableSet)conversationsByIds.values().stream().map(Conversation::getUserGroups).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet())));
        conversationIdsByUserGroupIds.inverse().asMap().forEach((conversationId, userGroupIds) -> {
            Conversation conversation = (Conversation)conversationsByIds.get(conversationId);
            if (conversation == null) {
                LOG.warn("No conversation with id {} found. Skip notify removed participants for this conversations.", conversationId);
                return;
            }
            Sets.SetView effectiveParticipants = Sets.union(conversation.getParticipants(), MessageServiceImpl.getAll(loadedUserGroupMemberships, conversation.getUserGroups()));
            ImmutableSet removedMembers = (ImmutableSet)userGroupIds.stream().map(arg_0 -> ((ImmutableSetMultimap)allRemovedMembers).get(arg_0)).flatMap(Collection::stream).filter(Predicate.not(((Set)effectiveParticipants)::contains)).collect(ImmutableSet.toImmutableSet());
            if (!removedMembers.isEmpty()) {
                this.pushChatUpdates((ConversationId)conversationId, (ImmutableSet<PersonId>)removedMembers);
                this._xmppService.sendMessage((ImmutableSet<PersonId>)removedMembers, new ConversationControlMessage(ConversationControlMessageType.YOU_WERE_REMOVED, (ConversationId)conversationId));
                this._messageWriteDataService.insertConversationChangeForPersonsLeavingConversation((ConversationId)conversationId, (Set<PersonId>)removedMembers);
            }
        });
    }

    @Nonnull
    private static <K, V> ImmutableSet<V> getAll(ImmutableSetMultimap<K, V> setMultimap, Collection<K> ids) {
        return (ImmutableSet)ids.stream().flatMap(id -> setMultimap.get(id).stream()).collect(ImmutableSet.toImmutableSet());
    }

    @ParametersAreNonnullByDefault
    private static class Changes<T> {
        private final ImmutableSet<T> _originalData;
        private final ImmutableSet<T> _newData;
        private ImmutableSet<T> _added;
        private ImmutableSet<T> _removed;
        private ImmutableSet<T> _changed;

        public Changes(Set<T> originalData, @Nullable Set<T> newData) {
            this._originalData = ImmutableSet.copyOf(originalData);
            this._newData = newData == null ? this._originalData : ImmutableSet.copyOf(newData);
        }

        public Changes(ImmutableSet<T> originalData, ImmutableSet<T> added, ImmutableSet<T> removed) {
            this._originalData = originalData;
            this._newData = ImmutableSet.copyOf((Collection)Sets.difference((Set)Sets.union(originalData, added), removed));
        }

        @Nonnull
        public ImmutableSet<T> getOriginalData() {
            return this._originalData;
        }

        @Nonnull
        public ImmutableSet<T> getNewData() {
            return this._newData;
        }

        @Nonnull
        public ImmutableSet<T> getAdded() {
            if (this._added == null) {
                this._added = ImmutableSet.copyOf((Collection)Sets.difference(this._newData, this._originalData));
            }
            return this._added;
        }

        @Nonnull
        public ImmutableSet<T> getRemoved() {
            if (this._removed == null) {
                this._removed = ImmutableSet.copyOf((Collection)Sets.difference(this._originalData, this._newData));
            }
            return this._removed;
        }

        @Nonnull
        public ImmutableSet<T> getChanged() {
            if (this._changed == null) {
                this._changed = ImmutableSet.copyOf((Collection)Sets.union(this.getAdded(), this.getRemoved()));
            }
            return this._changed;
        }

        public boolean hasChanges() {
            return !this.getAdded().isEmpty() || !this.getRemoved().isEmpty();
        }

        @Nonnull
        public static <T> Changes<T> noChanges(Set<T> originalData) {
            return new Changes<T>(originalData, null);
        }
    }

    private static final class SystemMessage {
        private DBMessageCreationModel _messageCreationModel;
        private ChatMessage _message;
        private final ImmutableSet<PersonId> _directXmppRecipients;
        private final ImmutableSet<UserGroupId> _userGroupXmppRecipients;

        @ParametersAreNonnullByDefault
        SystemMessage(DBMessageCreationModel messageCreationModel, Iterable<PersonId> directXmppRecipients, Iterable<UserGroupId> userGroupXmppRecipients) {
            this._messageCreationModel = messageCreationModel;
            this._message = null;
            this._directXmppRecipients = ImmutableSet.copyOf(directXmppRecipients);
            this._userGroupXmppRecipients = ImmutableSet.copyOf(userGroupXmppRecipients);
        }

        @ParametersAreNonnullByDefault
        SystemMessage(ChatMessage message, Iterable<PersonId> directXmppRecipients, Iterable<UserGroupId> userGroupXmppRecipients) {
            this._message = message;
            this._messageCreationModel = null;
            this._directXmppRecipients = ImmutableSet.copyOf(directXmppRecipients);
            this._userGroupXmppRecipients = ImmutableSet.copyOf(userGroupXmppRecipients);
        }

        @CheckForNull
        public DBMessageCreationModel getMessageCreationModel() {
            return this._messageCreationModel;
        }

        public void replaceMessageCreationModel(ChatMessage message) {
            this._message = message;
            this._messageCreationModel = null;
        }

        @CheckForNull
        public ChatMessage getMessage() {
            return this._message;
        }

        @Nonnull
        public ImmutableSet<PersonId> getDirectXmppRecipients() {
            return this._directXmppRecipients;
        }

        @Nonnull
        public ImmutableSet<UserGroupId> getUserGroupXmppRecipients() {
            return this._userGroupXmppRecipients;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("message", (Object)this._message).add("messageCreationModel", (Object)this._messageCreationModel).add("directRecipients", this._directXmppRecipients).add("userGroupRecipients", this._userGroupXmppRecipients).toString();
        }
    }
}

