/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.business.impl;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import de.justsoftware.onx.chat.model.AttachmentChatMessage;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.chat.model.ChatMessageType;
import de.justsoftware.onx.common.cache.AbstractBiDirectionalCacheAccessor;
import de.justsoftware.onx.common.cache.AbstractMapLoadingCacheAccessor;
import de.justsoftware.onx.common.cache.AbstractRelationalCacheAccessor;
import de.justsoftware.onx.common.server.model.HasMoreList;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.message.business.MessageModelFactory;
import de.justsoftware.onx.message.business.MessageReadWriteDataService;
import de.justsoftware.onx.message.integration.persistence.MessageDAO;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversation;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationChange;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationParticipant;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationSettings;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationUserGroup;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBMailMessageInfo;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBMessage;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBMessageCreationModel;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.model.ConversationReadData;
import de.justsoftware.onx.message.model.ConversationSettings;
import de.justsoftware.onx.message.model.MessageLoadDirection;
import de.justsoftware.onx.message.shared.model.ChatMessageId;
import de.justsoftware.onx.message.shared.model.ConversationChangeType;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.message.shared.model.ConversationType;
import de.justsoftware.onx.person.integration.persistence.PersonRelation;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class MessageReadWriteDataServiceImpl
implements MessageReadWriteDataService {
    private final MessageModelFactory _modelFactory;
    private final MessageDAO _messageDAO;
    private final ConversationCacheAccessor _conversationCacheAccessor;
    private final ConversationSettingsCacheAccessor _conversationSettingsCacheAccessor;
    private final Function<DBMessage, ChatMessage> _modelFactoryFunction;
    private final ParticipantsSharingAConversationCacheAccessor _participantsSharingAConversationCacheAccessor;
    private final MessageCacheAccessor _messageCacheAccessor;
    private final TransactionHelper _transactionHelper;

    @Autowired
    public MessageReadWriteDataServiceImpl(EhcacheClient ehcacheClient, MessageModelFactory modelFactory, MessageDAO messageDAO, TransactionHelper transactionHelper) {
        this._modelFactory = modelFactory;
        this._modelFactoryFunction = new NullPermeableFunction<DBMessage, ChatMessage>(){

            @Override
            protected ChatMessage applySafe(DBMessage message) {
                return MessageReadWriteDataServiceImpl.this._modelFactory.transform(message);
            }
        };
        this._messageDAO = messageDAO;
        this._conversationCacheAccessor = new ConversationCacheAccessor(ehcacheClient, messageDAO);
        this._conversationSettingsCacheAccessor = new ConversationSettingsCacheAccessor(ehcacheClient, this._messageDAO);
        this._participantsSharingAConversationCacheAccessor = new ParticipantsSharingAConversationCacheAccessor(ehcacheClient, messageDAO);
        this._messageCacheAccessor = new MessageCacheAccessor(ehcacheClient, messageDAO, this._modelFactoryFunction);
        this._transactionHelper = transactionHelper;
    }

    @Nonnull
    private static ImmutableMap<ConversationId, Conversation> getConversationMap(ImmutableList<DBConversation> dbConversations, MessageDAO messageDAO) {
        Set conversationIds = dbConversations.stream().map(DBConversation.TO_ID).collect(Collectors.toSet());
        ImmutableList<DBConversationParticipant> dbConversationsParticipants = messageDAO.getDBConversationParticipantsByConversationIds(conversationIds);
        ImmutableListMultimap participantsMap = Multimaps.index(dbConversationsParticipants, DBConversationParticipant.TO_CONVERSATION_ID);
        ImmutableList<DBConversationUserGroup> dbConversationsUserGroups = messageDAO.getDBConversationUserGroupsByConversationIds(conversationIds);
        ImmutableListMultimap userGroupMaps = Multimaps.index(dbConversationsUserGroups, DBConversationUserGroup.TO_CONVERSATION_ID);
        ImmutableList conversations = (ImmutableList)dbConversations.stream().map(new DBConversationToConversationFunction((Multimap<ConversationId, DBConversationParticipant>)participantsMap, (Multimap<ConversationId, DBConversationUserGroup>)userGroupMaps)).collect(ImmutableList.toImmutableList());
        return Maps.uniqueIndex((Iterable)conversations, Conversation.TO_ID);
    }

    @Nonnull
    private static ImmutableSetMultimap<Boolean, UserGroupId> groupUserGroupsByDeletionFlag(@Nullable Collection<DBConversationUserGroup> potentialUserGroups) {
        if (potentialUserGroups == null) {
            return ImmutableSetMultimap.of();
        }
        return (ImmutableSetMultimap)potentialUserGroups.stream().filter(Objects::nonNull).collect(ImmutableSetMultimap.toImmutableSetMultimap(DBConversationUserGroup::isDeleted, DBConversationUserGroup::getUserGroupId));
    }

    @Override
    public ImmutableSet<ConversationId> getOneOnOneConversationWithUser(PersonId currentUser, PersonId otherUser) {
        return this._messageDAO.getOneOnOneConversationWithUser(currentUser, otherUser);
    }

    @Override
    public ImmutableList<Conversation> getAllConversationsByDirectParticipant(PersonId user) {
        return ImmutableList.copyOf((Collection)MessageReadWriteDataServiceImpl.getConversationMap(this._messageDAO.getAllConversationsByDirectParticipant(user), this._messageDAO).values());
    }

    @Override
    public ConversationId createNewConversation(ConversationType type, Set<PersonId> participants, ImmutableSet<UserGroupId> userGroupIds, String title, DateTime createDate, UUID creationId, TenantId tenantId) {
        ConversationId newConversationId = this._messageDAO.createNewConversation(type, participants, userGroupIds, title, createDate, creationId, tenantId);
        if (participants.size() > 1) {
            this._participantsSharingAConversationCacheAccessor.invalidateKeysAndWait(participants);
        }
        return newConversationId;
    }

    @Override
    public ImmutableSet<PersonId> getOneOnOneConversationPartnersByPersonId(PersonId personId) {
        return this._messageDAO.getOneOnOneConversationPartnersByPersonId(personId);
    }

    @Override
    public ImmutableMap<ConversationId, Conversation> getConversationsByIds(Set<ConversationId> conversationIds) {
        return this._conversationCacheAccessor.getMap(conversationIds);
    }

    @Override
    public ImmutableSet<ConversationId> getConversationIdsOfTenant(TenantId tenantId) {
        return this._messageDAO.getConversationIdsOfTenant(tenantId);
    }

    @Override
    public ImmutableMap<ChatMessageId, ChatMessage> getMessagesByIds(ImmutableSet<ChatMessageId> messageIds) {
        return this._messageCacheAccessor.getMap(messageIds);
    }

    @Override
    public void updateConversationParticipants(ConversationId id, Set<PersonId> removed, Set<PersonId> added, @Nullable DateTime updateDate) {
        this._transactionHelper.doInTransactionWithoutResult(status -> {
            this._messageDAO.updateConversationParticipants(id, removed, added, updateDate);
            this.insertConversationChangeForPersonsLeavingConversation(id, removed);
        });
        this._conversationCacheAccessor.invalidateKey(id);
        Conversation conversation = (Conversation)this._conversationCacheAccessor.getSingle(id);
        if (conversation != null) {
            this._participantsSharingAConversationCacheAccessor.invalidateKeysAndWait(Sets.union(conversation.getParticipants(), conversation.getDeletedParticipants()));
        } else {
            this._participantsSharingAConversationCacheAccessor.invalidateAll();
        }
    }

    @Override
    public void updateConversationUserGroups(ConversationId id, ImmutableSet<UserGroupId> removed, ImmutableSet<UserGroupId> added, ImmutableSet<PersonId> removedMembers, @Nullable DateTime updateDate) {
        this._transactionHelper.doInTransactionWithoutResult(status -> {
            this._messageDAO.updateConversationUserGroups(id, removed, added, updateDate);
            this.insertConversationChangeForPersonsLeavingConversation(id, (Set<PersonId>)removedMembers);
        });
        this._conversationCacheAccessor.invalidateKey(id);
    }

    @Override
    public void insertConversationChangeForPersonsLeavingConversation(ConversationId conversationId, Set<PersonId> leavingPersons) {
        DateTime now = this._messageDAO.getChatTime();
        for (PersonId personId : leavingPersons) {
            this._messageDAO.upsertConversationChange(new DBConversationChange(conversationId, personId, now, ConversationChangeType.LEFT));
        }
    }

    @Override
    public HasMoreList<ChatMessage> getMessagesByConversation(ConversationId conversationId, DateTime offset, int intendedLimit, MessageLoadDirection direction) {
        int requestedLimit = intendedLimit + 1;
        HasMoreList<DBMessage> messages = HasMoreList.fromList(this._messageDAO.getMessagesByConversation(conversationId, offset, requestedLimit, direction), intendedLimit);
        return new HasMoreList<ChatMessage>((ImmutableList)messages.getSubList().stream().map(this._modelFactoryFunction).collect(ImmutableList.toImmutableList()), messages.isHasMore());
    }

    @Override
    public ImmutableMap<ConversationId, Conversation> getRecentConversationsForUser(PersonId person, TenantId tenantId, int offset, int limit) {
        return this.fromCache(this._messageDAO.getRecentConversationsForUser(person, tenantId, offset, limit));
    }

    @Override
    public ImmutableMap<ConversationId, Conversation> getUpdatedConversationsForUser(PersonId person, TenantId tenantId, DateTime startingFrom) {
        return this.fromCache(this._messageDAO.getUpdatedConversationsForUser(person, tenantId, startingFrom));
    }

    @Override
    public ImmutableList<DBConversationChange> getRecentConversationChangesForUser(PersonId person, TenantId tenantId, DateTime startingFrom) {
        return this._messageDAO.getEffectiveConversationChangesSince(person, tenantId, startingFrom);
    }

    @Override
    public ImmutableMap<ConversationId, Conversation> getConversationsForUser(ConversationType type, PersonId person, TenantId tenantId, int offset, int limit) {
        switch (type) {
            case MULTI_USER_CHAT: {
                return MessageReadWriteDataServiceImpl.getConversationMap(this._messageDAO.getMultiUserConversationsForUser(person, tenantId, offset, limit), this._messageDAO);
            }
            case ONE_ON_ONE: {
                return MessageReadWriteDataServiceImpl.getConversationMap(this._messageDAO.getOneOnOneConversationsForUser(person, tenantId, offset, limit), this._messageDAO);
            }
        }
        throw new IllegalArgumentException("ConversationType " + type + " is unknown");
    }

    @Override
    public ImmutableSet<ConversationId> getConversationIdsForAllUsers() {
        return this._messageDAO.getConversationIdsForAllUsers();
    }

    @Override
    public ImmutableMap<ConversationId, ChatMessage> getLatestChatMessage(Set<ConversationId> conversationIds) {
        return FluentIterable.from(this._messageDAO.getLatestChatMessage(conversationIds)).transform(this._modelFactoryFunction).uniqueIndex(ChatMessage.TO_CONVERSATION_ID);
    }

    @Override
    public ImmutableList<ChatMessage> getUpdatedMessages(Set<ConversationId> conversationIds, @Nullable DateTime updatedSince, int limit) {
        return (ImmutableList)this._messageDAO.getUpdatedMessages(conversationIds, updatedSince, limit).stream().map(this._modelFactory::transform).collect(ImmutableList.toImmutableList());
    }

    @Override
    public ImmutableList<DBConversationParticipant> getDBConversationParticipantsByConversationIds(Set<? extends ConversationId> conversationIds) {
        return this._messageDAO.getDBConversationParticipantsByConversationIds(conversationIds);
    }

    @Override
    public ImmutableSet<PersonId> getDirectParticipantIdsByConversationIds(Set<ConversationId> conversationIds) {
        return this._messageDAO.getDirectParticipantIdsByConversationIds(conversationIds);
    }

    @Override
    public ImmutableSet<ConversationId> getUnreadConversationsForPerson(PersonId personId, TenantId tenantId) {
        return this._messageDAO.getUnreadConversationsForPerson(personId, tenantId);
    }

    @Override
    public ImmutableMap<PersonId, Integer> getUnreadConversationsCountsForPersons(ImmutableSet<PersonId> personIds) {
        return this._messageDAO.getUnreadConversationsCountsForPersons(personIds);
    }

    @Override
    public ImmutableMap<PersonId, Integer> getUnreadMessagesCountsForPersons(ImmutableSet<PersonId> personIds) {
        return this._messageDAO.getUnreadMessagesCountsForPersons(personIds);
    }

    @Override
    public boolean isConversationUnreadForPerson(ConversationId conversationId, PersonId personId) {
        return this._messageDAO.isConversationUnreadForPerson(conversationId, personId);
    }

    @Override
    public ImmutableMap<ConversationId, ConversationReadData> getUnreadMessagesCountForConversations(PersonId person, ImmutableSet<ConversationId> conversations) {
        return this._messageDAO.getUnreadMessagesCountForUser(person, (Set<? extends ConversationId>)conversations);
    }

    @Override
    public boolean markConversationAsRead(PersonId person, ConversationId conversation) {
        return this._messageDAO.markConversationAsRead(person, conversation);
    }

    @Override
    public boolean markConversationAsRead(PersonId person, ConversationId conversation, DateTime readTime) {
        return this._messageDAO.markConversationAsRead(person, conversation, readTime);
    }

    @Override
    public ImmutableList<DBMailMessageInfo> getUnreadMessagesForMail() {
        return this._messageDAO.getUnreadMessagesForMail();
    }

    @Override
    public void markEmailsSent(SetMultimap<PersonId, ConversationId> participants, DateTime date) {
        this._messageDAO.markEmailsSent(participants, date);
    }

    @Override
    public ImmutableSet<PersonId> fetchParticipantsSharingAConversationWith(PersonId personId) {
        return (ImmutableSet)this._participantsSharingAConversationCacheAccessor.getSingle(personId);
    }

    @Override
    public boolean isParticipantOfACommonConversation(PersonId personId, PersonId otherPersonId) {
        return this._participantsSharingAConversationCacheAccessor.isInRelation(personId, otherPersonId);
    }

    @Override
    public void markConversationParticipantsAsDeleted(Set<PersonId> persons) {
        this._messageDAO.markConversationParticipantsAsDeleted(persons);
        this._participantsSharingAConversationCacheAccessor.invalidateAll();
        this._conversationCacheAccessor.invalidateAll();
    }

    @Override
    public void setConversationTitle(ConversationId id, String title) {
        Conversation conversation = InvalidIdServiceException.check((Conversation)this.getConversationsByIds((Set<ConversationId>)ImmutableSet.of((Object)id)).get((Object)id));
        if (conversation.getType() != ConversationType.MULTI_USER_CHAT) {
            throw new IllegalStateException("Only title of MULTI_USER_CHAT are allowed to be modified.");
        }
        if (!com.google.common.base.Objects.equal((Object)conversation.getCustomTitle(), (Object)title)) {
            this._messageDAO.setConversationTitle(id, title);
            this._conversationCacheAccessor.invalidateKey(id);
        }
    }

    @Override
    public ChatMessage insertNewMessage(DBMessageCreationModel message) {
        DBMessage persistedMessage = this._messageDAO.insertMessage(message);
        this._conversationCacheAccessor.invalidateKey(persistedMessage.getConversationId());
        return this._modelFactory.transform(persistedMessage);
    }

    @Override
    public ImmutableSetMultimap<PersonId, ConversationId> getConversationIdsByParticipants(Set<PersonId> personIds) {
        return this._messageDAO.getConversationIdsByParticipants(personIds);
    }

    @Override
    public HasMoreList<ChatMessage> getAttachmentMessagesByConversation(ConversationId conversationId, int intendedLimit, DateTime offset) {
        int requestedLimit = intendedLimit + 1;
        ImmutableList messages = (ImmutableList)this._messageDAO.getAttachmentMessagesByConversation(conversationId, requestedLimit, offset).stream().map(this._modelFactoryFunction).collect(ImmutableList.toImmutableList());
        return HasMoreList.fromList(messages, intendedLimit);
    }

    @Override
    public HasMoreList<ChatMessage> getAttachmentMessagesByConversationFiltered(ConversationId conversationId, int limit, @Nullable DateTime offset, ImmutableSet<String> contentTypes) {
        ImmutableList<DBMessage> dbMessages = this._messageDAO.getAttachmentMessagesByConversationFiltered(conversationId, limit + 1, offset, contentTypes);
        ImmutableList messages = (ImmutableList)dbMessages.stream().map(this._modelFactoryFunction).collect(ImmutableList.toImmutableList());
        return HasMoreList.fromList(messages, limit);
    }

    @Override
    public HasMoreList<ChatMessage> getAttachmentMessagesByConversationExcluded(ConversationId conversationId, int limit, @Nullable DateTime offset, ImmutableSet<String> contentTypes) {
        ImmutableList<DBMessage> dbMessages = this._messageDAO.getAttachmentMessagesByConversationExcluded(conversationId, limit + 1, offset, contentTypes);
        ImmutableList messages = (ImmutableList)dbMessages.stream().map(this._modelFactoryFunction).collect(ImmutableList.toImmutableList());
        return HasMoreList.fromList(messages, limit);
    }

    @Override
    public ImmutableTable<PersonId, ConversationId, ConversationSettings> getConversationsSettings(ImmutableSetMultimap<PersonId, ConversationId> participantConversations) {
        ImmutableTable dbSettings = this._conversationSettingsCacheAccessor.getTable(participantConversations);
        return ImmutableTable.copyOf((Table)Tables.transformValues(dbSettings, ConversationSettings.FROM_DB));
    }

    @Override
    public void insertConversationSettings(ConversationSettings settings, DateTime createDate, DateTime modifyDate) {
        DBConversationSettings dbSettings = new DBConversationSettings(settings.getConversationId(), settings.getParticipantId(), settings.isMuted(), settings.isHidden(), createDate, modifyDate);
        this._messageDAO.insertConversationSettings(dbSettings);
        this._conversationSettingsCacheAccessor.invalidateKey(settings.getParticipantId(), settings.getConversationId());
    }

    @Override
    public boolean updateConversationSettings(ConversationSettings settings, DateTime modifyDate) {
        DBConversationSettings dbSettings = new DBConversationSettings(settings.getConversationId(), settings.getParticipantId(), settings.isMuted(), settings.isHidden(), modifyDate, modifyDate);
        boolean result = this._messageDAO.updateConversationSettings(dbSettings);
        this._conversationSettingsCacheAccessor.invalidateKey(settings.getParticipantId(), settings.getConversationId());
        return result;
    }

    @Override
    public void deleteConversation(ConversationId conversationId) {
        this._messageDAO.deleteConversation(conversationId);
        this._conversationCacheAccessor.invalidateKey(conversationId);
    }

    @Override
    public void updateConversationParticipantsAsDeletedWithConversation(ConversationId conversationId) {
        Conversation originalConversation = (Conversation)this._conversationCacheAccessor.getSingle(conversationId);
        if (originalConversation == null) {
            return;
        }
        this._transactionHelper.doInTransactionWithoutResult(status -> {
            ImmutableSet<PersonId> deleted = this._messageDAO.updateConversationParticipantsAsDeletedWithConversation(conversationId);
            this.insertConversationChangeForPersonsLeavingConversation(conversationId, (Set<PersonId>)deleted);
        });
        this._conversationCacheAccessor.invalidateKey(conversationId);
        this._participantsSharingAConversationCacheAccessor.invalidateKeysAndWait(Sets.union(originalConversation.getParticipants(), originalConversation.getDeletedParticipants()));
    }

    @Override
    public void updateConversationUserGroupsAsDeletedWithConversation(ConversationId conversationId, ImmutableSet<PersonId> userGroupMembers) {
        Conversation originalConversation = (Conversation)this._conversationCacheAccessor.getSingle(conversationId);
        if (originalConversation == null) {
            return;
        }
        this._transactionHelper.doInTransactionWithoutResult(status -> {
            this._messageDAO.updateConversationUserGroupsAsDeletedWithConversation(conversationId);
            this.insertConversationChangeForPersonsLeavingConversation(conversationId, (Set<PersonId>)userGroupMembers);
        });
        this._conversationCacheAccessor.invalidateKey(conversationId);
    }

    @Override
    public void unhideConversation(ConversationId conversationId, Set<PersonId> participants, DateTime modifyDate) {
        this._messageDAO.unhideConversation(conversationId, participants, modifyDate);
        Map participantConversations = Maps.asMap(participants, p -> conversationId);
        this._conversationSettingsCacheAccessor.invalidateKeys(participantConversations.entrySet());
    }

    @Override
    public DateTime getChatTime() {
        return this._messageDAO.getChatTime();
    }

    @Override
    public ImmutableList<ConversationSettings> getUpdatedConversationSettings(PersonId personId, TenantId tenantId, DateTime since) {
        return (ImmutableList)this._messageDAO.getUpdatedConversationSettingsForUser(personId, tenantId, since).stream().map(ConversationSettings.FROM_DB).collect(ImmutableList.toImmutableList());
    }

    @Override
    @Nonnull
    public ImmutableSet<PersonId> getUpdatedPersonsForUser(PersonId personId, TenantId tenantId, DateTime since) {
        return this._messageDAO.getUpdatedPersonsForUser(personId, tenantId, since);
    }

    @Override
    @Nonnull
    public ImmutableMap<ConversationId, Conversation> getOneOnOneConversationsWithUpdatedUsers(PersonId personId, TenantId tenantId, DateTime since) {
        return this.fromCache(this._messageDAO.getOneOnOneConversationsWithUpdatedUsers(personId, tenantId, since));
    }

    @Nonnull
    private ImmutableMap<ConversationId, Conversation> fromCache(ImmutableList<DBConversation> dbConversations) {
        Set conversationIds = (Set)dbConversations.stream().map(DBConversation::getId).collect(ImmutableSet.toImmutableSet());
        return this._conversationCacheAccessor.getMap(conversationIds);
    }

    @Override
    public ImmutableMap<PersonId, DateTime> getConversationReadDates(ConversationId conversationId, ImmutableSet<PersonId> participantIds) {
        return this._messageDAO.getConversationReadDates(conversationId, participantIds);
    }

    @Override
    public ChatMessage updateMessageAsDeleted(ChatMessageId messageId, ChatMessageType messageType) {
        DBMessage dbMessage = this._messageDAO.updateMessageAsDeleted(messageId, messageType);
        this._messageCacheAccessor.invalidateKey(messageId);
        if (dbMessage == null) {
            return null;
        }
        this._conversationCacheAccessor.invalidateKey(dbMessage.getConversationId());
        return this._modelFactory.transform(dbMessage);
    }

    @Override
    public ImmutableList<AttachmentChatMessage> getMessagesByDocumentIds(ImmutableSet<DriveDocumentId> documentIds) {
        return (ImmutableList)this._messageDAO.getMessagesByDocumentIds(documentIds).stream().map(this._modelFactory::transform).filter(msg -> msg instanceof AttachmentChatMessage).map(msg -> (AttachmentChatMessage)msg).collect(ImmutableList.toImmutableList());
    }

    @Override
    public ImmutableMap<ConversationId, TenantId> getAllConversations(int offset, int limit) {
        return this._messageDAO.getAllConversations(offset, limit);
    }

    @Override
    public ImmutableList<ConversationId> getAllGroupConversations(int offset, int limit) {
        return this._messageDAO.getAllGroupConversations(offset, limit);
    }

    @Override
    public ImmutableSet<PersonId> filterConversationAuthors(ConversationId conversationId, ImmutableSet<PersonId> authorIdsToFilter) {
        return this._messageDAO.filterConversationAuthors(conversationId, authorIdsToFilter);
    }

    @Override
    public ImmutableSet<DBConversationUserGroup> deleteUserGroupsFromAllConversations(ImmutableSet<UserGroupId> userGroupIds) {
        ImmutableSet<DBConversationUserGroup> dbConversationUserGroups = this._messageDAO.deleteUserGroupsFromAllConversations(userGroupIds);
        this._conversationCacheAccessor.invalidateKeys(dbConversationUserGroups.stream().map(DBConversationUserGroup::getConversationId).collect(Collectors.toSet()));
        return (ImmutableSet)dbConversationUserGroups.stream().filter(Predicate.not(DBConversationUserGroup::isDeleted)).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ImmutableSetMultimap<UserGroupId, ConversationId> getConversationIdsByUserGroupIds(ImmutableSet<UserGroupId> userGroupIds) {
        return this._messageDAO.getConversationIdsByUserGroupIds(userGroupIds);
    }

    @Override
    @Nonnull
    public ImmutableSet<UserGroupId> getUpdatedUserGroupsForUser(PersonId personId, TenantId tenantId, DateTime since) {
        return this._messageDAO.getUpdatedUserGroupsForUser(personId, tenantId, since);
    }

    @Override
    @Nonnull
    public ImmutableSet<ConversationId> getRecentlyJoinedConversations(PersonId personId, TenantId tenantId, DateTime since) {
        return this._messageDAO.getRecentlyJoinedConversations(personId, tenantId, since);
    }

    @Override
    @Nonnull
    public ImmutableSet<UserGroupId> getUserGroupIdsByConversations(ImmutableSet<ConversationId> conversationIds) {
        return this._messageDAO.getUserGroupIdsByConversations(conversationIds);
    }

    @ParametersAreNonnullByDefault
    private static final class MessageCacheAccessor
    extends AbstractMapLoadingCacheAccessor<MessageServiceEhCacheName, ChatMessageId, ChatMessage> {
        private final MessageDAO _messageDAO;
        private final Function<DBMessage, ChatMessage> _messageTransformer;

        private MessageCacheAccessor(EhcacheClient cache, MessageDAO messageDAO, Function<DBMessage, ChatMessage> messageTransformer) {
            super(cache, MessageServiceEhCacheName.MESSAGES);
            this._messageDAO = messageDAO;
            this._messageTransformer = messageTransformer;
        }

        @Override
        protected Map<ChatMessageId, ChatMessage> getFromDatabaseMulti(Set<? extends ChatMessageId> inputs) {
            return Maps.transformValues(this._messageDAO.getMessagesByIds(inputs), this._messageTransformer);
        }

        @Override
        protected String keyToString(ChatMessageId key) {
            return key.asString();
        }
    }

    @ParametersAreNonnullByDefault
    private static class ParticipantsSharingAConversationCacheAccessor
    extends AbstractBiDirectionalCacheAccessor<MessageServiceEhCacheName, PersonId, PersonRelation> {
        private final MessageDAO _messageDao;

        ParticipantsSharingAConversationCacheAccessor(CacheClient<? super MessageServiceEhCacheName> cache, MessageDAO messageDao) {
            super(cache, MessageServiceEhCacheName.PARTICIPANTS_SHARING_A_CONVERSATION);
            this._messageDao = messageDao;
        }

        @Override
        protected PersonId objectToValue(PersonRelation dbResult) {
            return dbResult.getTo();
        }

        @Override
        protected PersonId objectToKey(PersonRelation dbResult) {
            return dbResult.getFrom();
        }

        @Override
        protected Iterable<? extends PersonRelation> getListFromDatabase(Set<? extends PersonId> personIds) {
            return this._messageDao.getParticipantsSharingAConversationOfPersons(personIds);
        }

        @Override
        protected String keyToString(PersonId key) {
            return key.toString();
        }
    }

    private static final class ConversationSettingsCacheAccessor
    extends AbstractRelationalCacheAccessor<MessageServiceEhCacheName, PersonId, ConversationId, DBConversationSettings> {
        private final MessageDAO _messageDAO;

        private ConversationSettingsCacheAccessor(@Nonnull EhcacheClient cache, @Nonnull MessageDAO messageDAO) {
            super(cache, MessageServiceEhCacheName.CONVERSATION_SETTINGS);
            this._messageDAO = messageDAO;
        }

        @Override
        protected String keyToString(PersonId left, ConversationId right) {
            return left + "_" + right;
        }

        @Override
        protected Table<? extends PersonId, ? extends ConversationId, ? extends DBConversationSettings> getFromDatabase(ImmutableSetMultimap<PersonId, ConversationId> param) {
            return this._messageDAO.getConversationsSettings(param);
        }
    }

    @ParametersAreNonnullByDefault
    private static final class DBConversationToConversationFunction
    extends NullPermeableFunction<DBConversation, Conversation> {
        private final Multimap<ConversationId, DBConversationParticipant> _participantsMap;
        private final Multimap<ConversationId, DBConversationUserGroup> _userGroupsMap;

        public DBConversationToConversationFunction(Multimap<ConversationId, DBConversationParticipant> participantsMap, Multimap<ConversationId, DBConversationUserGroup> userGroupsMap) {
            this._participantsMap = participantsMap;
            this._userGroupsMap = userGroupsMap;
        }

        @Override
        protected Conversation applySafe(DBConversation con) {
            ConversationId id = con.getId();
            ConversationType type = con.getType();
            String title = con.getTitle();
            DateTime lastMessageDate = con.getLastMessageDate();
            TenantId tenantId = con.getTenantId();
            Collection participantsFromDB = this._participantsMap.get((Object)id);
            ImmutableSet<PersonId> activeParticipants = DBConversationToConversationFunction.filterParticipants(participantsFromDB, false);
            ImmutableSet<PersonId> deletedParticipants = DBConversationToConversationFunction.filterParticipants(participantsFromDB, true);
            ImmutableSetMultimap<Boolean, UserGroupId> groupedUserGroupIds = MessageReadWriteDataServiceImpl.groupUserGroupsByDeletionFlag(this._userGroupsMap.get((Object)id));
            return new Conversation(id, type, activeParticipants, deletedParticipants, (ImmutableSet<UserGroupId>)groupedUserGroupIds.get((Object)false), (ImmutableSet<UserGroupId>)groupedUserGroupIds.get((Object)true), tenantId, title, lastMessageDate);
        }

        @Nonnull
        private static ImmutableSet<PersonId> filterParticipants(@Nullable Collection<DBConversationParticipant> potentialParticipants, boolean deleted) {
            if (potentialParticipants == null) {
                return ImmutableSet.of();
            }
            if (deleted) {
                return (ImmutableSet)potentialParticipants.stream().filter((Predicate<DBConversationParticipant>)DBConversationParticipant.IS_DELETED).map(DBConversationParticipant.TO_PARTICIPANT_ID).collect(ImmutableSet.toImmutableSet());
            }
            return (ImmutableSet)potentialParticipants.stream().filter((Predicate<DBConversationParticipant>)Predicates.not(DBConversationParticipant.IS_DELETED)).map(DBConversationParticipant.TO_PARTICIPANT_ID).collect(ImmutableSet.toImmutableSet());
        }
    }

    private static final class ConversationCacheAccessor
    extends AbstractMapLoadingCacheAccessor<MessageServiceEhCacheName, ConversationId, Conversation> {
        private final MessageDAO _messageDAO;

        private ConversationCacheAccessor(@Nonnull EhcacheClient cache, @Nonnull MessageDAO messageDAO) {
            super(cache, MessageServiceEhCacheName.CONVERSATION);
            this._messageDAO = messageDAO;
        }

        @Override
        protected Map<ConversationId, Conversation> getFromDatabaseMulti(Set<? extends ConversationId> ids) {
            ImmutableList<DBConversation> dbConversations = this._messageDAO.getDBConversationsByIds(ids);
            if (dbConversations.isEmpty()) {
                return ImmutableMap.of();
            }
            return MessageReadWriteDataServiceImpl.getConversationMap(dbConversations, this._messageDAO);
        }

        @Override
        protected String keyToString(ConversationId key) {
            return key.asString();
        }
    }

    public static enum MessageServiceEhCacheName implements EhCacheName
    {
        CONVERSATION("message.conversation", 2000),
        CONVERSATION_SETTINGS("message.conversationSettings", 2000),
        PARTICIPANTS_SHARING_A_CONVERSATION("message.participantsSharingAConversation", 200),
        MESSAGES("message.messages", 2000);

        private final String _prefix;
        private final int _maxElements;

        private MessageServiceEhCacheName(String prefix, int maxElements) {
            this._prefix = prefix;
            this._maxElements = maxElements;
        }

        @Override
        public String getCacheName() {
            return this._prefix;
        }

        @Override
        public int getMaxElements() {
            return this._maxElements;
        }
    }
}

