/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.business.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.chat.model.AffectedParticipantsChatMessage;
import de.justsoftware.onx.chat.model.AttachmentChatMessage;
import de.justsoftware.onx.chat.model.ChatAttachment;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.chat.model.ChatMessageType;
import de.justsoftware.onx.chat.model.ConversationCreatedChatMessage;
import de.justsoftware.onx.chat.model.ConversationTitleChangedChatMessage;
import de.justsoftware.onx.chat.model.SenderLeftChatMessage;
import de.justsoftware.onx.chat.model.TextChatMessage;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.message.business.MessageModelFactory;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBChatAttachment;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBChatAttachmentCreationModel;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBMessage;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBMessageCreationModel;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.stereotype.Service;

@Service
public class MessageModelFactoryImpl
implements ChatMessageType.Transformer<ChatMessage, DBMessage>,
MessageModelFactory {
    private static final String PLACEHOLDER_MESSAGE = "{}";

    @Override
    public ChatMessage transformChatMessage(DBMessage message) {
        return new TextChatMessage(message.getId(), message.getSentFrom().asProfileId(), Strings.nullToEmpty((String)message.getMessage()), message.getConversationId(), message.getCreateDate());
    }

    @Override
    public ChatMessage transformAddedToConversation(DBMessage message) {
        AffectedParticipantsTeaserModel affected = AffectedParticipantsTeaserModel.fromMessage(Strings.nullToEmpty((String)message.getMessage()));
        return new AffectedParticipantsChatMessage(message.getId(), message.getSentFrom().asProfileId(), ChatMessageType.ADDED_TO_CONVERSATION, (Set<UserGroupId>)affected.getAffectedUserGroupIds(), affected.getUserGroupTeaserIds(), affected.getAllDirectParticipantIds(), affected.getRemainingTeaserIds(), Collections.emptySet(), affected.getTotalCount(), message.getConversationId(), message.getCreateDate());
    }

    @Override
    public ChatMessage transformRemovedFromConversation(DBMessage message) {
        AffectedParticipantsTeaserModel affected = AffectedParticipantsTeaserModel.fromMessage(Strings.nullToEmpty((String)message.getMessage()));
        return new AffectedParticipantsChatMessage(message.getId(), message.getSentFrom().asProfileId(), ChatMessageType.REMOVED_FROM_CONVERSATION, (Set<UserGroupId>)affected.getAffectedUserGroupIds(), affected.getUserGroupTeaserIds(), affected.getAllDirectParticipantIds(), affected.getRemainingTeaserIds(), affected.getAllRemovedPersonIdsStayingInUserGroups(), affected.getTotalCount(), message.getConversationId(), message.getCreateDate());
    }

    @Override
    public ChatMessage transformLeftConversation(DBMessage message) {
        SenderLeftChatTeaserModel senderLeftModel = SenderLeftChatTeaserModel.fromMessage(Strings.nullToEmpty((String)message.getMessage()));
        return new SenderLeftChatMessage(message.getId(), message.getSentFrom().asProfileId(), ChatMessageType.LEFT_CONVERSATION, senderLeftModel.getSenderIsStayingInUserGroup(), message.getConversationId(), message.getCreateDate());
    }

    @Override
    public ChatMessage transformConversationTitleChanged(DBMessage message) {
        ConversationTitleChangedTeaserModel teaser = ConversationTitleChangedTeaserModel.fromMessage(Strings.nullToEmpty((String)message.getMessage()));
        return new ConversationTitleChangedChatMessage(message.getId(), message.getConversationId(), teaser.getOldTitle(), teaser.getNewTitle(), teaser.getTeaserIds(), message.getSentFrom().asProfileId(), message.getCreateDate());
    }

    @Override
    public DBMessageCreationModel createChatMessageModel(ConversationId conversationId, PersonId from, String message, UUID creationId) {
        return new DBMessageCreationModel(conversationId, from, message, ChatMessageType.CHAT_MESSAGE, creationId, null);
    }

    @Override
    public DBMessageCreationModel createRemovedParticipantsMessageModel(ConversationId conversationId, PersonId updatingPerson, ImmutableSet<PersonId> affectedPersonIds, ImmutableSet<UserGroupId> affectedUserGroupIds, ImmutableSet<PersonId> personIdsStayingInUserGroups, DateTime createDate) {
        return new DBMessageCreationModel(conversationId, updatingPerson, AffectedParticipantsTeaserModel.fromSet(affectedPersonIds, affectedUserGroupIds, personIdsStayingInUserGroups).toMessage(), ChatMessageType.REMOVED_FROM_CONVERSATION, createDate);
    }

    @Override
    public DBMessageCreationModel createAddedParticipantsMessageModel(ConversationId conversationId, PersonId updatingPerson, ImmutableSet<PersonId> affectedPersonIds, ImmutableSet<UserGroupId> affectedUserGroupIds, DateTime createDate) {
        return new DBMessageCreationModel(conversationId, updatingPerson, AffectedParticipantsTeaserModel.fromSet(affectedPersonIds, affectedUserGroupIds, (ImmutableSet<PersonId>)ImmutableSet.of()).toMessage(), ChatMessageType.ADDED_TO_CONVERSATION, createDate);
    }

    @Override
    public DBMessageCreationModel createSenderLeftChatMessageModel(ConversationId conversationId, PersonId personLeavingId, boolean personStayingInUserGroup, DateTime createDate) {
        return new DBMessageCreationModel(conversationId, personLeavingId, new SenderLeftChatTeaserModel(personStayingInUserGroup).toMessage(), ChatMessageType.LEFT_CONVERSATION, createDate);
    }

    @Override
    public DBMessageCreationModel createConversationTitleChangedNotificationModel(ConversationId conversationId, PersonId updatingPerson, String oldTitle, String newTitle, ImmutableSet<PersonId> currentParticipants, DateTime createDate) {
        return new DBMessageCreationModel(conversationId, updatingPerson, new ConversationTitleChangedTeaserModel(oldTitle, newTitle, currentParticipants.stream().map(AffectedParticipantId.FROM_PERSON_ID).collect(Collectors.toSet())).toMessage(), ChatMessageType.CONVERSATION_TITLE_CHANGED, null, null, createDate);
    }

    @Override
    public ChatMessage transform(DBMessage message) {
        return message.getType().transform(this, message);
    }

    @Override
    public DBMessageCreationModel createConversationCreatedNotificationModel(ConversationId conversationId, PersonId creator, String title, DateTime createDate) {
        return new DBMessageCreationModel(conversationId, creator, new ConversationCreatedTeaserModel(title).toMessage(), ChatMessageType.CONVERSATION_CREATED, createDate);
    }

    @Override
    public ChatMessage transformConversationCreated(DBMessage message) {
        ConversationCreatedTeaserModel teaser = ConversationCreatedTeaserModel.fromMessage(Strings.nullToEmpty((String)message.getMessage()));
        return new ConversationCreatedChatMessage(message.getId(), message.getConversationId(), teaser.getTitle(), message.getSentFrom().asProfileId(), message.getCreateDate());
    }

    @Override
    public ChatMessage transformConversationDeleted(DBMessage message) {
        return new ChatMessage(message.getId(), message.getConversationId(), ChatMessageType.CONVERSATION_DELETED, message.getSentFrom().asProfileId(), message.getCreateDate());
    }

    @Override
    public ChatMessage transformAttachmentChatMessage(DBMessage message) {
        DBChatAttachment att = message.getAttachment();
        if (att == null) {
            throw new IllegalArgumentException("DB message does not have an attachment.");
        }
        ChatAttachment chatAttachment = new ChatAttachment(att.getDocumentId(), att.getDocumentVersionId(), att.getFilename(), att.getSize(), att.getContentType(), att.getVersion(), att.getAttachmentType(), att.getImageWidth(), att.getImageHeight());
        return new AttachmentChatMessage(message.getId(), message.getConversationId(), message.getSentFrom().asProfileId(), message.getCreateDate(), chatAttachment);
    }

    @Override
    public ChatMessage transformPersonDeletedChatMessage(DBMessage message) {
        return new ChatMessage(message.getId(), message.getConversationId(), ChatMessageType.PERSON_DELETED, message.getSentFrom().asProfileId(), message.getCreateDate());
    }

    @Override
    public ChatMessage transformUserGroupDeletedChatMessage(DBMessage message) {
        return new ChatMessage(message.getId(), message.getConversationId(), ChatMessageType.USER_GROUP_DELETED, message.getSentFrom().asProfileId(), message.getCreateDate());
    }

    @Override
    @Nonnull
    public ChatMessage transformDeletedChatMessage(DBMessage message) {
        return new ChatMessage(message.getId(), message.getConversationId(), ChatMessageType.DELETED_CHAT_MESSAGE, message.getSentFrom().asProfileId(), message.getCreateDate());
    }

    @Override
    public DBMessageCreationModel createAttachmentChatMessageModel(ConversationId conversationId, PersonId updatingPerson, DBChatAttachmentCreationModel attachment, UUID creationId) {
        DBMessageCreationModel message = new DBMessageCreationModel(conversationId, updatingPerson, null, ChatMessageType.ATTACHMENT_CHAT_MESSAGE, creationId, attachment);
        return message;
    }

    @Override
    public DBMessageCreationModel createConversationDeletedChatMessageModel(ConversationId conversationId, PersonId deletingPerson) {
        return new DBMessageCreationModel(conversationId, deletingPerson, PLACEHOLDER_MESSAGE, ChatMessageType.CONVERSATION_DELETED);
    }

    @Override
    public DBMessageCreationModel createPersonsDeletedChatMessageModel(ConversationId conversationId, PersonId deletedPersonId) {
        return new DBMessageCreationModel(conversationId, deletedPersonId, PLACEHOLDER_MESSAGE, ChatMessageType.PERSON_DELETED);
    }

    @Override
    public DBMessageCreationModel createUserGroupDeletedChatMessageModel(ConversationId conversationId, PersonId deletingPerson, UserGroupId deletedUserGroup) {
        return new DBMessageCreationModel(conversationId, deletingPerson, PLACEHOLDER_MESSAGE, ChatMessageType.USER_GROUP_DELETED);
    }

    @ParametersAreNonnullByDefault
    private static class ConversationCreatedTeaserModel {
        private final String _title;

        @JsonCreator
        public ConversationCreatedTeaserModel(@JsonProperty(value="title", required=false) @Nullable String title) {
            this._title = title;
        }

        @CheckForNull
        @JsonProperty(value="title")
        public String getTitle() {
            return this._title;
        }

        @Nonnull
        public static ConversationCreatedTeaserModel fromMessage(String message) {
            try {
                return (ConversationCreatedTeaserModel)new ObjectMapper().readValue(message, ConversationCreatedTeaserModel.class);
            }
            catch (IOException e) {
                throw new TransformationError(e);
            }
        }

        @Nonnull
        public static String toMessage(ConversationCreatedTeaserModel model) {
            try {
                return new ObjectMapper().writeValueAsString((Object)model);
            }
            catch (IOException e) {
                throw new TransformationError(e);
            }
        }

        @Nonnull
        public String toMessage() {
            return ConversationCreatedTeaserModel.toMessage(this);
        }
    }

    @ParametersAreNonnullByDefault
    private static class ConversationTitleChangedTeaserModel {
        private final String _oldTitle;
        private final String _newTitle;
        private final Set<AffectedParticipantId> _participants;

        @JsonCreator
        public ConversationTitleChangedTeaserModel(@JsonProperty(value="old_title") String oldTitle, @JsonProperty(value="new_title") String newTitle, @JsonProperty(value="participants") Set<AffectedParticipantId> participants) {
            this._oldTitle = oldTitle;
            this._newTitle = newTitle;
            this._participants = participants;
        }

        @Nonnull
        @JsonProperty(value="old_title")
        public String getOldTitle() {
            return this._oldTitle;
        }

        @Nonnull
        @JsonProperty(value="new_title")
        public String getNewTitle() {
            return this._newTitle;
        }

        @Nonnull
        @JsonProperty(value="participants")
        public Set<AffectedParticipantId> getParticipants() {
            return this._participants;
        }

        @Nonnull
        public static ConversationTitleChangedTeaserModel fromMessage(String message) {
            try {
                return (ConversationTitleChangedTeaserModel)new ObjectMapper().readValue(message, ConversationTitleChangedTeaserModel.class);
            }
            catch (IOException e) {
                throw new TransformationError(e);
            }
        }

        @Nonnull
        public static String toMessage(ConversationTitleChangedTeaserModel model) {
            try {
                return new ObjectMapper().writeValueAsString((Object)model);
            }
            catch (IOException e) {
                throw new TransformationError(e);
            }
        }

        @Nonnull
        public String toMessage() {
            return ConversationTitleChangedTeaserModel.toMessage(this);
        }

        @Nonnull
        @JsonIgnore
        public Set<ProfileId> getTeaserIds() {
            return this.getParticipants().stream().map(AffectedParticipantId.TO_PERSON_ID).map(PersonId.AS_PROFILE_ID).collect(Collectors.toSet());
        }
    }

    @ParametersAreNonnullByDefault
    private static class SenderLeftChatTeaserModel {
        private final boolean _senderIsStayingInUserGroup;

        @JsonCreator
        public SenderLeftChatTeaserModel(@Nullable @JsonProperty(value="sender_is_staying_in_user_group") Boolean senderIsStayingInUserGroup) {
            this._senderIsStayingInUserGroup = senderIsStayingInUserGroup != null && senderIsStayingInUserGroup != false;
        }

        @JsonProperty(value="sender_is_staying_in_user_group")
        public boolean getSenderIsStayingInUserGroup() {
            return this._senderIsStayingInUserGroup;
        }

        @Nonnull
        public static SenderLeftChatTeaserModel fromMessage(String message) {
            try {
                return (SenderLeftChatTeaserModel)new ObjectMapper().readValue(message, SenderLeftChatTeaserModel.class);
            }
            catch (IOException e) {
                throw new TransformationError(e);
            }
        }

        @Nonnull
        public static String toMessage(SenderLeftChatTeaserModel model) {
            try {
                return new ObjectMapper().writeValueAsString((Object)model);
            }
            catch (IOException e) {
                throw new TransformationError(e);
            }
        }

        @Nonnull
        public String toMessage() {
            return SenderLeftChatTeaserModel.toMessage(this);
        }
    }

    @ParametersAreNonnullByDefault
    private static class AffectedParticipantsTeaserModel {
        private final ImmutableSet<AffectedParticipantId> _affectedIds;
        private final ImmutableSet<UserGroupId> _affectedUserGroupIds;
        private final ImmutableSet<AffectedParticipantId> _removedPersonIdsStayingInUserGroups;
        private final long _totalCount;

        @JsonCreator
        public AffectedParticipantsTeaserModel(@JsonProperty(value="affected_list") List<AffectedParticipantId> affectedIds, @Nullable @JsonProperty(value="affected_user_groups") List<UserGroupId> affectedUserGroupIds, @Nullable @JsonProperty(value="removed_person_ids_staying_in_user_groups") List<AffectedParticipantId> removedPersonIdsStayingInUserGroups, @JsonProperty(value="total_count") long totalCount) {
            this._affectedIds = ImmutableSet.copyOf(affectedIds);
            this._affectedUserGroupIds = affectedUserGroupIds != null ? ImmutableSet.copyOf(affectedUserGroupIds) : ImmutableSet.of();
            this._removedPersonIdsStayingInUserGroups = removedPersonIdsStayingInUserGroups != null ? ImmutableSet.copyOf(removedPersonIdsStayingInUserGroups) : ImmutableSet.of();
            this._totalCount = totalCount;
        }

        @Nonnull
        @JsonProperty(value="affected_list")
        public ImmutableSet<AffectedParticipantId> getAffectedParticipantIds() {
            return this._affectedIds;
        }

        @Nonnull
        @JsonProperty(value="affected_user_groups")
        public ImmutableSet<UserGroupId> getAffectedUserGroupIds() {
            return this._affectedUserGroupIds;
        }

        @Nonnull
        @JsonProperty(value="removed_person_ids_staying_in_user_groups")
        public ImmutableSet<AffectedParticipantId> getRemovedPersonIdsStayingInUserGroups() {
            return this._removedPersonIdsStayingInUserGroups;
        }

        @Nonnull
        @JsonIgnore
        public Set<UserGroupId> getUserGroupTeaserIds() {
            return this.getAffectedUserGroupIds().stream().limit(5L).collect(Collectors.toSet());
        }

        @Nonnull
        @JsonIgnore
        public Set<ProfileId> getAllDirectParticipantIds() {
            return this.getAffectedParticipantIds().stream().map(AffectedParticipantId.TO_PERSON_ID).map(PersonId.AS_PROFILE_ID).collect(Collectors.toSet());
        }

        @Nonnull
        @JsonIgnore
        public Set<ProfileId> getAllRemovedPersonIdsStayingInUserGroups() {
            return this.getRemovedPersonIdsStayingInUserGroups().stream().map(AffectedParticipantId.TO_PERSON_ID).map(PersonId.AS_PROFILE_ID).collect(Collectors.toSet());
        }

        @Nonnull
        @JsonIgnore
        public Set<ProfileId> getRemainingTeaserIds() {
            int remainingTeaserLimit = Math.max(5 - this.getUserGroupTeaserIds().size(), 0);
            return this.getAllDirectParticipantIds().stream().limit(remainingTeaserLimit).collect(Collectors.toSet());
        }

        @JsonProperty(value="total_count")
        public long getTotalCount() {
            return this._totalCount;
        }

        @Nonnull
        public static AffectedParticipantsTeaserModel fromSet(ImmutableSet<PersonId> personIds, ImmutableSet<UserGroupId> userGroupIds, ImmutableSet<PersonId> personIdsStayingInUserGroups) {
            int totalCount = personIds.size() + userGroupIds.size();
            return new AffectedParticipantsTeaserModel(personIds.stream().map(AffectedParticipantId.FROM_PERSON_ID).collect(Collectors.toList()), (List<UserGroupId>)userGroupIds.asList(), personIdsStayingInUserGroups.stream().map(AffectedParticipantId.FROM_PERSON_ID).collect(Collectors.toList()), totalCount);
        }

        @Nonnull
        public static AffectedParticipantsTeaserModel fromMessage(String message) {
            try {
                return (AffectedParticipantsTeaserModel)new ObjectMapper().readValue(message, AffectedParticipantsTeaserModel.class);
            }
            catch (IOException e) {
                throw new TransformationError(e);
            }
        }

        @Nonnull
        public static String toMessage(AffectedParticipantsTeaserModel model) {
            try {
                return new ObjectMapper().writeValueAsString((Object)model);
            }
            catch (IOException e) {
                throw new TransformationError(e);
            }
        }

        @Nonnull
        public String toMessage() {
            return AffectedParticipantsTeaserModel.toMessage(this);
        }
    }

    private static class AffectedParticipantId {
        public static final Function<PersonId, AffectedParticipantId> FROM_PERSON_ID = new NullPermeableFunction<PersonId, AffectedParticipantId>(){

            @Override
            protected AffectedParticipantId applySafe(PersonId personId) {
                return new AffectedParticipantId(personId.getId());
            }
        };
        public static final Function<AffectedParticipantId, PersonId> TO_PERSON_ID = new NullPermeableFunction<AffectedParticipantId, PersonId>(){

            @Override
            protected PersonId applySafe(AffectedParticipantId input) {
                return (PersonId)PersonId.FROM_LONG.apply((Object)input.getId());
            }
        };
        private final long _id;

        @JsonCreator
        public AffectedParticipantId(@JsonProperty(value="id") long id) {
            this._id = id;
        }

        @JsonProperty(value="id")
        public long getId() {
            return this._id;
        }
    }

    @ParametersAreNonnullByDefault
    private static class TransformationError
    extends ServiceException {
        private static final long serialVersionUID = 1L;

        public TransformationError(Throwable cause) {
            super(cause);
        }
    }
}

