/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.message.business.MessageReadDataService;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import de.justsoftware.permission.client.kafka.MultiRoleAssignmentProducer;
import de.justsoftware.permission.client.kafka.PermissionItemProducer;
import de.justsoftware.permission.client.kafka.WaitForOffsetException;
import de.justsoftware.permission.client.kafka.WaitForOffsets;
import de.justsoftware.permission.client.model.Role;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="conversationPermissionService")
@ParametersAreNonnullByDefault
public class ConversationPermissionService {
    private static final Logger LOG = LoggerFactory.getLogger(ConversationPermissionService.class);
    private static final int CONVERSATION_FETCH_SIZE = 100;
    @Autowired
    private MultiRoleAssignmentProducer _multiRoleAssignmentProducer;
    @Autowired
    private PermissionItemProducer _itemProducer;
    @Autowired
    private MessageReadDataService _messageReadDataService;

    public void addPermissionItemForNewConversation(ConversationId conversationId, TenantId tenantId) {
        this.executePermissionInstruction(() -> this._itemProducer.publishItem(conversationId.asString(), Optional.of(tenantId.asString()), new String[0]));
    }

    public void publishPermissionsForConversation(ConversationId conversationId, ImmutableSet<PersonId> currentParticipants, ImmutableSet<UserGroupId> currentUserGroups) {
        Role conversationManagerRole = Role.manager((String)conversationId.asString());
        ImmutableList<Role> allRoles = this.getAllRoles(currentParticipants, currentUserGroups);
        Map<Role, ImmutableList<Role>> roleReplacements = Map.of(conversationManagerRole, allRoles);
        this.executePermissionInstruction(() -> this._multiRoleAssignmentProducer.publishRoleReplacements(roleReplacements));
    }

    @Nonnull
    private ImmutableList<Role> getAllRoles(ImmutableSet<PersonId> currentParticipants, ImmutableSet<UserGroupId> currentUserGroups) {
        return (ImmutableList)Streams.concat((Stream[])new Stream[]{currentParticipants.stream().map(participant -> Role.profileRole((long)participant.idAsLongValue())), currentUserGroups.stream().map(userGroup -> Role.userGroupRole((UUID)userGroup.getId()))}).collect(ImmutableList.toImmutableList());
    }

    public void deletePermissionsForDeletedConversation(ConversationId conversationId) {
        this.publishPermissionsForConversation(conversationId, (ImmutableSet<PersonId>)ImmutableSet.of(), (ImmutableSet<UserGroupId>)ImmutableSet.of());
    }

    public void deletePermissionItemForDeletedConversation(ConversationId conversationId) {
        this.executePermissionInstruction(() -> this._itemProducer.publishDeletedItem(conversationId.asString()));
    }

    public void republishPermissionsForConversations() {
        LOG.debug("Republishing permission items for conversations");
        this.republishItems();
        LOG.debug("Republishing role replacements for conversations");
        this.republishRoles();
    }

    private void republishRoles() {
        this._multiRoleAssignmentProducer.republishForItemRoles(ItemType.CONVERSATION.name(), (Set)ImmutableSet.of((Object)"MANAGER"), () -> {
            ImmutableMap<ConversationId, TenantId> fetchResults;
            int offset = 0;
            do {
                fetchResults = this._messageReadDataService.getAllConversations(offset, 100);
                offset += 100;
                for (ConversationId conversationId : fetchResults.keySet()) {
                    ImmutableMap<ConversationId, Conversation> conversations = this._messageReadDataService.getConversationsByIds((Set<ConversationId>)ImmutableSet.of((Object)conversationId));
                    conversations.values().forEach(conversation -> {
                        Role conversationManagerRole = Role.manager((String)conversationId.asString());
                        ImmutableList<Role> allRoles = this.getAllRoles(conversation.getParticipants(), conversation.getUserGroups());
                        Map<Role, ImmutableList<Role>> roleReplacements = Map.of(conversationManagerRole, allRoles);
                        this._multiRoleAssignmentProducer.publishRoleReplacements(roleReplacements);
                    });
                }
            } while (!fetchResults.isEmpty());
        });
    }

    private void republishItems() {
        this._itemProducer.republish(ItemType.CONVERSATION.name(), () -> {
            ImmutableMap<ConversationId, TenantId> fetchResults;
            int offset = 0;
            do {
                fetchResults = this._messageReadDataService.getAllConversations(offset, 100);
                offset += 100;
                fetchResults.forEach((key, value) -> this._itemProducer.publishItem(key.asString(), Optional.of(value.asString()), new String[0]));
            } while (!fetchResults.isEmpty());
        });
    }

    private void executePermissionInstruction(Supplier<WaitForOffsets> instruction) {
        try {
            new WaitForOffsets(Stream.of(instruction.get())).waitForOffsets();
        }
        catch (WaitForOffsetException ex) {
            LOG.error("An error occurred while waiting for response from permission service", (Throwable)ex);
        }
    }
}

