/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.business.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.message.business.ConversationParticipantDeletionHandler;
import de.justsoftware.onx.message.business.MessageReadDataService;
import de.justsoftware.onx.message.business.MessageService;
import de.justsoftware.onx.message.business.MessageWriteDataService;
import de.justsoftware.onx.message.business.events.ConversationUpdatedEvent;
import de.justsoftware.onx.message.shared.model.ConversationId;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConversationParticipantDeletionHandlerImpl
implements ConversationParticipantDeletionHandler {
    @Autowired
    private MessageReadDataService _messageReadDataService;
    @Autowired
    private MessageWriteDataService _messageWriteDataService;
    @Autowired
    private MessageService _messageService;

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        ImmutableSet deletedPersons = FluentIterable.from(parentIds).filter(ProfileId.class).transform(ProfileId.TO_PERSON_ID).toSet();
        if (!deletedPersons.isEmpty()) {
            ImmutableSetMultimap<PersonId, ConversationId> conversationsOfDeletedPersons = this._messageReadDataService.getConversationIdsByParticipants((Set<PersonId>)deletedPersons);
            this._messageWriteDataService.markConversationParticipantsAsDeleted((Set<PersonId>)deletedPersons);
            deletionContext.attach(() -> conversationsOfDeletedPersons.asMap().forEach(this._messageService::createAndSendSystemMessageForDeletedPersons));
            ImmutableSetMultimap deletedPersonsInConversations = conversationsOfDeletedPersons.inverse();
            for (Map.Entry entry : deletedPersonsInConversations.asMap().entrySet()) {
                ImmutableSet removed = ImmutableSet.copyOf((Collection)((Collection)entry.getValue()));
                deletionContext.addServerEvent(ConversationUpdatedEvent.forParticipantUpdate((ConversationId)entry.getKey(), (Set<PersonId>)ImmutableSet.of(), (Set<PersonId>)removed));
            }
        }
    }
}

