/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import de.justsoftware.onx.chat.model.ChatMessageType;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.util.CollectingServerEventCollector;
import de.justsoftware.onx.common.deletion.DeletionService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.message.business.ConversationCleanupService;
import de.justsoftware.onx.message.business.MessageWriteDataService;
import de.justsoftware.onx.message.business.events.ConversationDeletedEvent;
import de.justsoftware.onx.message.business.impl.ConversationPermissionService;
import de.justsoftware.onx.message.integration.persistence.MessageDAO;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBMessage;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.server.business.ClusterConfiguration;
import de.justsoftware.toolbox.clock.Clock;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="conversationCleanupService")
@ParametersAreNonnullByDefault
public class ConversationCleanupServiceImpl
implements ConversationCleanupService {
    private static final Logger LOG = LoggerFactory.getLogger(ConversationCleanupServiceImpl.class);
    private static final PersonId DELETED_USER = new PersonId(-1L);
    private final ClusterConfiguration _clusterPosition;
    private final Clock _clock;
    private final Settings _settings;
    private final MessageDAO _messageDao;
    private final MessageWriteDataService _messageWriteDataService;
    private final ConversationPermissionService _conversationPermissionService;
    private final DeletionService _deletionService;
    private final JCEventBus _eventBus;

    @Autowired
    public ConversationCleanupServiceImpl(ClusterConfiguration clusterPosition, Clock clock, Settings settings, MessageDAO dao, DeletionService deletionService, MessageWriteDataService messageWriteDataService, ConversationPermissionService conversationPermissionService, JCEventBus eventBus) {
        this._clusterPosition = clusterPosition;
        this._clock = clock;
        this._settings = settings;
        this._messageDao = dao;
        this._deletionService = deletionService;
        this._messageWriteDataService = messageWriteDataService;
        this._conversationPermissionService = conversationPermissionService;
        this._eventBus = eventBus;
    }

    @Override
    public void deleteAbandonedConversations() {
        if (!this._clusterPosition.isMaster()) {
            return;
        }
        int ttl = this._settings.getDeletedChatsTTLSeconds();
        if (ttl < 0) {
            return;
        }
        LOG.info("CleanUp of abandoned conversations was triggered. Looking up matching conversations...");
        DateTime deleteBefore = this._clock.now().minusSeconds(ttl);
        ImmutableSet<ConversationId> conversationIds = this._messageDao.getAbandonedConversationsOlderThan(deleteBefore, 20);
        if (conversationIds.isEmpty()) {
            LOG.info("No abandoned conversations found.");
            return;
        }
        ImmutableMap<ConversationId, DBMessage> lastWords = this._messageDao.getLastMessageOfConversations((Set<ConversationId>)conversationIds);
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        LOG.info("Found {} abandoned conversations. Starting removal process...", (Object)lastWords.size());
        DateTime startAll = this._clock.now();
        ImmutableList.Builder allStats = ImmutableList.builder();
        for (ConversationId conversationId : conversationIds) {
            DateTime startOne = this._clock.now();
            DBMessage lastMessage = (DBMessage)lastWords.get((Object)conversationId);
            PersonId personDeleting = lastMessage != null ? lastMessage.getSentFrom() : DELETED_USER;
            ChatMessageType sourceMessageType = lastMessage != null ? lastMessage.getType() : ChatMessageType.REMOVED_FROM_CONVERSATION;
            StatisticsModel stats = this._deletionService.deleteInTransactionWithDeleteAction(conversationId, personDeleting, (status, deleteAction) -> {
                int messages = this._messageDao.deleteMessages(conversationId);
                int settings = this._messageDao.deleteConversationSettings(conversationId);
                int directParticipants = this._messageDao.deleteParticipants(conversationId);
                int userGroups = this._messageDao.deleteUserGroups(conversationId);
                int allParticipants = directParticipants + userGroups;
                this._messageWriteDataService.deleteConversation(conversationId);
                return new StatisticsModel(conversationId, sourceMessageType, allParticipants, settings, messages);
            });
            this._conversationPermissionService.deletePermissionItemForDeletedConversation(conversationId);
            eventCollector.add(new ConversationDeletedEvent(conversationId));
            allStats.add((Object)stats);
            this.logStats(stats, new Duration((ReadableInstant)startOne, (ReadableInstant)this._clock.now()));
        }
        eventCollector.fireEvents(this._eventBus);
        this.logStats((Iterable<StatisticsModel>)allStats.build(), new Duration((ReadableInstant)startAll, (ReadableInstant)this._clock.now()));
        LOG.info("CleanUp of abandoned conversations finished.");
    }

    private void logStats(StatisticsModel stats, Duration duration) {
        LOG.info("Deleted conversation {} with {} participants {} settings and {} messages in {}ms.", new Object[]{stats.getConversationId(), stats.getDeletedParticipantsCount(), stats.getDeletedConversationSettingsCount(), stats.getDeletedMessagesCount(), duration.getMillis()});
    }

    private void logStats(Iterable<StatisticsModel> allStats, Duration duration) {
        long deletedConversations = 0L;
        long deletedParticipants = 0L;
        long deletedConversationSettings = 0L;
        long deletedMessages = 0L;
        HashMap typeCounter = Maps.newHashMap();
        for (StatisticsModel stats : allStats) {
            ++deletedConversations;
            deletedParticipants += stats.getDeletedParticipantsCount();
            deletedConversationSettings += stats.getDeletedConversationSettingsCount();
            deletedMessages += stats.getDeletedMessagesCount();
            long tcValue = typeCounter.getOrDefault((Object)stats.getSourceType(), 0L);
            typeCounter.put(stats.getSourceType(), tcValue + 1L);
        }
        StringBuilder msg = new StringBuilder("Deleted {} conversations with {} participants, {} settings and {} messages in {}ms. Last actions:");
        ImmutableList.Builder argBuilder = ImmutableList.builder().add((Object)deletedConversations).add((Object)deletedParticipants).add((Object)deletedConversationSettings).add((Object)deletedMessages).add((Object)duration.getMillis());
        for (ChatMessageType cmt : ChatMessageType.values()) {
            long count = typeCounter.getOrDefault((Object)cmt, 0L);
            if (count <= 0L) continue;
            msg.append("\n - {}: {}");
            argBuilder.add((Object)cmt.name());
            argBuilder.add((Object)count);
        }
        LOG.info(msg.toString(), argBuilder.build().toArray());
    }

    @ParametersAreNonnullByDefault
    private static final class StatisticsModel {
        private final ConversationId _conversationId;
        private final ChatMessageType _sourceType;
        private final long _deletedParticipants;
        private final long _deletedConversationSettings;
        private final long _deletedMessages;

        StatisticsModel(ConversationId conversationId, ChatMessageType sourceType, long deletedParticipants, long deletedConversationSettings, long deletedMessages) {
            this._conversationId = conversationId;
            this._sourceType = sourceType;
            this._deletedParticipants = deletedParticipants;
            this._deletedConversationSettings = deletedConversationSettings;
            this._deletedMessages = deletedMessages;
        }

        @Nonnull
        public ConversationId getConversationId() {
            return this._conversationId;
        }

        @Nonnull
        public ChatMessageType getSourceType() {
            return this._sourceType;
        }

        public long getDeletedParticipantsCount() {
            return this._deletedParticipants;
        }

        public long getDeletedConversationSettingsCount() {
            return this._deletedConversationSettings;
        }

        public long getDeletedMessagesCount() {
            return this._deletedMessages;
        }
    }
}

