/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import de.justsoftware.onx.message.business.ConversationChangeCleanupService;
import de.justsoftware.onx.message.integration.persistence.MessageDAO;
import de.justsoftware.onx.server.business.ClusterConfiguration;
import de.justsoftware.toolbox.clock.Clock;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="conversationChangeCleanupService")
@ParametersAreNonnullByDefault
public class ConversationChangeCleanupServiceImpl
implements ConversationChangeCleanupService {
    private static final Logger LOG = LoggerFactory.getLogger(ConversationChangeCleanupServiceImpl.class);
    private final ClusterConfiguration _clusterPosition;
    private final Clock _clock;
    private final Settings _settings;
    private final MessageDAO _messageDao;

    @Autowired
    public ConversationChangeCleanupServiceImpl(ClusterConfiguration clusterPosition, Clock clock, Settings settings, MessageDAO messageDao) {
        this._clusterPosition = clusterPosition;
        this._clock = clock;
        this._settings = settings;
        this._messageDao = messageDao;
    }

    @Override
    public void deleteOldConversationChanges() {
        if (!this._clusterPosition.isMaster()) {
            return;
        }
        int ttl = this._settings.getConversationChangesTTLSeconds();
        if (ttl < 0) {
            return;
        }
        LOG.info("Start clean-up of conversation changes older than {} seconds...", (Object)ttl);
        DateTime deleteBefore = this._clock.now().minusSeconds(ttl);
        int deleted = this._messageDao.deleteAllConversationChangesBefore(deleteBefore);
        LOG.info("Finished clean-up of conversation changes with {} deleted conversation changes.", (Object)deleted);
    }
}

