/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimaps;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.message.business.ChatUpdatePushFactory;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.push.business.PushNotificationService;
import de.justsoftware.onx.push.model.PushNotificationField;
import de.justsoftware.onx.push.model.PushNotificationType;
import de.justsoftware.onx.push.model.PushNotifications;
import de.justsoftware.onx.push.shared.model.PushAppName;
import de.justsoftware.onx.push.shared.model.PushTargetApp;
import de.justsoftware.onx.push.util.ApnsPushNotifications;
import de.justsoftware.onx.push.util.FcmPushNotifications;
import de.justsoftware.onx.push.util.PushTargetApps;
import de.justsoftware.pushnotification.client.model.ApnsPushNotification;
import de.justsoftware.pushnotification.client.model.FcmPushNotification;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ChatUpdatePushFactoryImpl
implements ChatUpdatePushFactory {
    private static final PushNotificationType NOTIFICATION_TYPE = PushNotificationType.CHAT_UPDATES;
    private static final Logger LOG = LoggerFactory.getLogger(ChatUpdatePushFactoryImpl.class);
    private final PushNotificationService _pushNotificationService;

    @Autowired
    public ChatUpdatePushFactoryImpl(PushNotificationService pushNotificationService) {
        this._pushNotificationService = pushNotificationService;
    }

    @Override
    public PushNotifications createPushNotifications(ConversationId conversationId, Set<PersonId> recipients) {
        try {
            return this.internalCreatePushNotifications(conversationId, recipients);
        }
        catch (RuntimeException e) {
            LOG.error("Error while sending a push notification", (Throwable)e);
            return PushNotifications.EMPTY;
        }
    }

    @Nonnull
    private PushNotifications internalCreatePushNotifications(ConversationId conversationId, Set<PersonId> potentialRecipients) {
        ImmutableSetMultimap<PersonId, PushTargetApp> appsByPersonId = this.appsByPersonIds(potentialRecipients);
        ImmutableSet actualPushTargets = ImmutableSet.copyOf((Collection)Multimaps.filterValues(appsByPersonId, this::isChatApp).values());
        return new PushNotifications(this.apnsPushNotificationsForChatUpdate(conversationId, (Set<PushTargetApp>)actualPushTargets), this.fcmPushNotificationsForChatUpdate(conversationId, (Set<PushTargetApp>)actualPushTargets));
    }

    @Nonnull
    private List<ApnsPushNotification> apnsPushNotificationsForChatUpdate(ConversationId conversationId, Set<PushTargetApp> pushTargets) {
        if (pushTargets.isEmpty()) {
            return Collections.emptyList();
        }
        return pushTargets.stream().filter(PushTargetApps::isApns).map(pushTarget -> ApnsPushNotifications.silentSync(pushTarget.getToken(), pushTarget.getPushNotificationApp(), NOTIFICATION_TYPE, Map.of(PushNotificationField.CONVERSATION_ID.getFieldName(), conversationId.toString()))).collect(Collectors.toList());
    }

    @Nonnull
    private List<FcmPushNotification> fcmPushNotificationsForChatUpdate(ConversationId conversationId, Set<PushTargetApp> pushTargets) {
        if (pushTargets.isEmpty()) {
            return Collections.emptyList();
        }
        return pushTargets.stream().filter(PushTargetApps::isFcm).map(pushTarget -> FcmPushNotifications.chatUpdate(pushTarget.getToken(), pushTarget.getPushNotificationApp(), conversationId)).collect(Collectors.toList());
    }

    private boolean isChatApp(@Nullable PushTargetApp app) {
        return app != null && app.getAppName() == PushAppName.CHAT;
    }

    @Nonnull
    private ImmutableSetMultimap<PersonId, PushTargetApp> appsByPersonIds(Set<PersonId> personIds) {
        return this._pushNotificationService.getPushTargetAppsByPersonIds(personIds);
    }
}

