/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.message.business.ChatMessagePushFactory;
import de.justsoftware.onx.message.business.MessageReadDataService;
import de.justsoftware.onx.message.business.impl.ChatMessagePushFactoryContext;
import de.justsoftware.onx.message.business.impl.ChatMessagePushFactoryContextService;
import de.justsoftware.onx.message.business.model.ChatMessagePushNotifications;
import de.justsoftware.onx.message.util.ChatMessages;
import de.justsoftware.onx.push.model.PushNotificationField;
import de.justsoftware.onx.push.model.PushNotificationType;
import de.justsoftware.onx.push.shared.model.PushNotificationProtocol;
import de.justsoftware.onx.push.shared.model.PushTargetApp;
import de.justsoftware.onx.push.util.ApnsPushNotifications;
import de.justsoftware.onx.push.util.FcmPushNotifications;
import de.justsoftware.pushnotification.client.model.ApnsPushNotification;
import de.justsoftware.pushnotification.client.model.FcmPushNotification;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ChatMessagePushFactoryImpl
implements ChatMessagePushFactory {
    private static final String NEW_CHAT_MESSAGE_CATEGORY = "NEW_CHAT_MESSAGE_INTERACTIVE";
    private static final Logger LOG = LoggerFactory.getLogger(ChatMessagePushFactoryImpl.class);
    private final MessageReadDataService _messageReadDataService;
    private final I18nService _i18nService;
    private final ChatMessagePushFactoryContextService _chatMessagePushFactoryContextService;
    private final Settings _settings;

    @Autowired
    public ChatMessagePushFactoryImpl(MessageReadDataService messageReadDataService, I18nService i18nService, ChatMessagePushFactoryContextService chatMessagePushFactoryContextService, Settings settings) {
        this._messageReadDataService = messageReadDataService;
        this._i18nService = i18nService;
        this._chatMessagePushFactoryContextService = chatMessagePushFactoryContextService;
        this._settings = settings;
    }

    @Override
    public ChatMessagePushNotifications createPushNotifications(ChatMessage chatMessage) {
        try {
            return this.internalCreatePushNotifications(chatMessage);
        }
        catch (RuntimeException e) {
            LOG.error("Error while sending a push notification", (Throwable)e);
            return ChatMessagePushNotifications.EMPTY;
        }
    }

    @Nonnull
    private ChatMessagePushNotifications internalCreatePushNotifications(ChatMessage message) {
        Optional<ChatMessagePushFactoryContext> optionalContext = this._chatMessagePushFactoryContextService.createContext(message);
        if (optionalContext.isEmpty()) {
            return ChatMessagePushNotifications.EMPTY;
        }
        ChatMessagePushFactoryContext context = optionalContext.get();
        List<FcmPushNotification> fcmPushNotifications = this.fcmPushNotifications(context);
        List<PossiblyDelayedApnsPushNotification> apnsPushNotifications = this.apnsPushNotifications(context);
        List<ApnsPushNotification> immediateApnsPushNotifications = this.filterImmediateApnsPushNotifications(apnsPushNotifications);
        ImmutableListMultimap<PersonId, ApnsPushNotification> delayedApnsPushNotifications = this.filterDelayedApnsPushNotifications(apnsPushNotifications);
        return new ChatMessagePushNotifications(immediateApnsPushNotifications, delayedApnsPushNotifications, fcmPushNotifications);
    }

    @Nonnull
    private List<ApnsPushNotification> filterImmediateApnsPushNotifications(List<PossiblyDelayedApnsPushNotification> apnsPushNotifications) {
        return apnsPushNotifications.stream().filter(Predicate.not(PossiblyDelayedApnsPushNotification::isDelayed)).map(PossiblyDelayedApnsPushNotification::getApnsPushNotification).collect(Collectors.toList());
    }

    @Nonnull
    private ImmutableListMultimap<PersonId, ApnsPushNotification> filterDelayedApnsPushNotifications(List<PossiblyDelayedApnsPushNotification> apnsPushNotifications) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        apnsPushNotifications.stream().filter(PossiblyDelayedApnsPushNotification::isDelayed).forEach(delayedApnsPushNotification -> {
            PersonId delayedReceiverPersonId = delayedApnsPushNotification.getDelayedReceiverPersonId();
            if (delayedReceiverPersonId != null) {
                builder.put((Object)delayedReceiverPersonId, (Object)delayedApnsPushNotification.getApnsPushNotification());
            }
        });
        return builder.build();
    }

    @Nonnull
    private List<FcmPushNotification> fcmPushNotifications(ChatMessagePushFactoryContext context) {
        return context.pushTargetStream(PushNotificationProtocol.FCM).map(entry -> this.fcmPushNotification((PersonId)entry.getKey(), (PushTargetApp)entry.getValue(), context)).collect(Collectors.toList());
    }

    @Nonnull
    private FcmPushNotification fcmPushNotification(PersonId receiverPersonId, PushTargetApp pushTarget, ChatMessagePushFactoryContext context) {
        if (!this.shouldCreateLoudFcmPushNotificationAboutNewMessages(receiverPersonId, context)) {
            return FcmPushNotifications.chatUpdate(pushTarget.getToken(), pushTarget.getPushNotificationApp(), context.getConversationId());
        }
        String title = context.getSender().getFullName();
        String messageText = context.messageText(receiverPersonId, this._i18nService);
        String conversationId = context.getConversationId().asString();
        String unreadConversationsCount = String.valueOf(context.getFcmReceiverUnreadConversationsCount(receiverPersonId));
        String unreadMessagesCount = String.valueOf(context.getUnreadMessagesCount(receiverPersonId));
        Map<String, String> customPayload = Map.of(PushNotificationField.CONVERSATION_ID.getFieldName(), conversationId, PushNotificationField.UNREAD_CONVERSATIONS.getFieldName(), unreadConversationsCount, PushNotificationField.UNREAD_MESSAGES.getFieldName(), unreadMessagesCount);
        return FcmPushNotifications.pushNotification(pushTarget.getToken(), pushTarget.getPushNotificationApp(), PushNotificationType.NEW_CHAT_MESSAGE, title, messageText, context.getUnreadMessagesCount(receiverPersonId), customPayload);
    }

    private boolean shouldCreateLoudFcmPushNotificationAboutNewMessages(PersonId receiverPersonId, ChatMessagePushFactoryContext context) {
        return context.isReceiverDifferentFromSender(receiverPersonId) && !context.isChatMutedFor(receiverPersonId) && !context.isAboutDeletedParticipant(receiverPersonId);
    }

    @Nonnull
    private List<PossiblyDelayedApnsPushNotification> apnsPushNotifications(ChatMessagePushFactoryContext context) {
        return context.pushTargetStream(PushNotificationProtocol.APNS).map(entry -> this.apnsPushNotification((PersonId)entry.getKey(), (PushTargetApp)entry.getValue(), context)).collect(Collectors.toList());
    }

    @Nonnull
    private PossiblyDelayedApnsPushNotification apnsPushNotification(PersonId receiverPersonId, PushTargetApp pushTarget, ChatMessagePushFactoryContext context) {
        if (!this.shouldCreateLoudApnsPushNotificationAboutNewMessages(receiverPersonId, context)) {
            ApnsPushNotification apnsPushNotification = ApnsPushNotifications.silentSync(pushTarget.getToken(), pushTarget.getPushNotificationApp(), PushNotificationType.NEW_CHAT_MESSAGE);
            return new PossiblyDelayedApnsPushNotification(apnsPushNotification);
        }
        String title = context.getSender().getFullName();
        String subtitle = context.chatTitle();
        String body = context.messageText(receiverPersonId, this._i18nService);
        String conversationId = context.getConversationId().asString();
        String messageId = context.getMessage().getId().asString();
        Map<String, String> customProperties = Map.of(PushNotificationField.CONVERSATION_ID.getFieldName(), conversationId, PushNotificationField.CHAT_MESSAGE_ID.getFieldName(), messageId);
        ApnsPushNotification apnsPushNotification = ApnsPushNotifications.pushNotification(pushTarget.getToken(), pushTarget.getPushNotificationApp(), PushNotificationType.NEW_CHAT_MESSAGE, title, subtitle, body, context.getUnreadMessagesCount(receiverPersonId), conversationId, NEW_CHAT_MESSAGE_CATEGORY, true, customProperties);
        PersonId delayedReceiverPersonId = context.isApnsReceiverOnline(receiverPersonId) ? receiverPersonId : null;
        return new PossiblyDelayedApnsPushNotification(apnsPushNotification, delayedReceiverPersonId);
    }

    private boolean shouldCreateLoudApnsPushNotificationAboutNewMessages(PersonId receiverPersonId, ChatMessagePushFactoryContext context) {
        return ChatMessages.isTextOrAttachmentMessage(context.getMessage()) && context.isReceiverDifferentFromSender(receiverPersonId) && !context.isChatMutedFor(receiverPersonId) && (this._settings.isChatIosPushDelayEnabled() || !context.isApnsReceiverOnline(receiverPersonId));
    }

    @Override
    public List<ApnsPushNotification> silenceDelayedApnsPushNotificationsIfMessageRead(ImmutableListMultimap<PersonId, ApnsPushNotification> delayedApnsPushNotifications, ChatMessage chatMessage) {
        ImmutableSet receiverPersonIds = delayedApnsPushNotifications.keySet();
        ImmutableMap<PersonId, DateTime> readDates = this._messageReadDataService.getConversationReadDates(chatMessage.getConversationId(), (ImmutableSet<PersonId>)receiverPersonIds);
        return delayedApnsPushNotifications.entries().stream().map(entry -> this.silenceDelayedApnsPushNotificationIfMessageRead((PersonId)entry.getKey(), (ApnsPushNotification)entry.getValue(), chatMessage, readDates)).collect(Collectors.toList());
    }

    @Nonnull
    private ApnsPushNotification silenceDelayedApnsPushNotificationIfMessageRead(PersonId receiverPersonId, ApnsPushNotification pushNotification, ChatMessage chatMessage, ImmutableMap<PersonId, DateTime> readDates) {
        DateTime readDate = (DateTime)readDates.get((Object)receiverPersonId);
        return readDate != null && readDate.isAfter((ReadableInstant)chatMessage.getCreateDate()) ? ApnsPushNotifications.toSilentSync(pushNotification) : pushNotification;
    }

    @ParametersAreNonnullByDefault
    private static final class PossiblyDelayedApnsPushNotification {
        private final ApnsPushNotification _apnsPushNotification;
        private final PersonId _delayedReceiverPersonId;

        PossiblyDelayedApnsPushNotification(ApnsPushNotification apnsPushNotification) {
            this(apnsPushNotification, null);
        }

        PossiblyDelayedApnsPushNotification(ApnsPushNotification apnsPushNotification, @Nullable PersonId delayedReceiverPersonId) {
            this._apnsPushNotification = apnsPushNotification;
            this._delayedReceiverPersonId = delayedReceiverPersonId;
        }

        @Nonnull
        ApnsPushNotification getApnsPushNotification() {
            return this._apnsPushNotification;
        }

        @CheckForNull
        PersonId getDelayedReceiverPersonId() {
            return this._delayedReceiverPersonId;
        }

        boolean isDelayed() {
            return this._delayedReceiverPersonId != null;
        }
    }
}

