/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import de.justsoftware.onx.authorization.business.EverythingAllowedAuthorizationCheckContext;
import de.justsoftware.onx.chat.integration.admin.XmppService;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.chat.model.JCXmppResourcePrefix;
import de.justsoftware.onx.chat.shared.model.JabberPresence;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.message.business.MessageReadDataService;
import de.justsoftware.onx.message.business.impl.ChatMessagePushFactoryContext;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.model.ConversationSettings;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.person.business.PersonReadDataService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.push.business.PushNotificationService;
import de.justsoftware.onx.push.shared.model.PushAppName;
import de.justsoftware.onx.push.shared.model.PushTargetApp;
import de.justsoftware.onx.push.util.PushTargetApps;
import de.justsoftware.onx.usergroup.business.impl.UserGroupService;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
class ChatMessagePushFactoryContextService {
    private final MessageReadDataService _messageReadDataService;
    private final PersonReadDataService _personReadDataService;
    private final XmppService _xmppService;
    private final PushNotificationService _pushNotificationService;
    private final UserGroupService _userGroupService;

    @Autowired
    public ChatMessagePushFactoryContextService(MessageReadDataService messageReadDataService, PersonReadDataService personReadDataService, XmppService xmppService, PushNotificationService pushNotificationService, UserGroupService userGroupService) {
        this._messageReadDataService = messageReadDataService;
        this._personReadDataService = personReadDataService;
        this._xmppService = xmppService;
        this._pushNotificationService = pushNotificationService;
        this._userGroupService = userGroupService;
    }

    @Nonnull
    Optional<ChatMessagePushFactoryContext> createContext(ChatMessage message) {
        Conversation conversation = this.conversation(message);
        DBPerson sender = this.sender(message);
        if (sender == null || conversation == null) {
            return Optional.empty();
        }
        ImmutableSetMultimap<PersonId, PushTargetApp> chatPushTargets = this.chatPushTargets(conversation, message);
        if (chatPushTargets.isEmpty()) {
            return Optional.empty();
        }
        ImmutableMap<PersonId, JabberPresence> apnsJabberPresences = this.apnsJabberPresences(chatPushTargets);
        ImmutableMap<PersonId, Integer> fcmUnreadConversationCounts = this.fcmUnreadConversationCounts(chatPushTargets);
        ImmutableSet receiverPersonIds = chatPushTargets.keySet();
        ImmutableMap<PersonId, Integer> unreadMessagesCounts = this._messageReadDataService.getUnreadMessagesCountsForPersons((ImmutableSet<PersonId>)ImmutableSet.copyOf((Collection)receiverPersonIds));
        ImmutableMap<PersonId, ConversationSettings> conversationSettings = this.conversationsSettings((Set<PersonId>)receiverPersonIds, conversation.getId());
        Map<PersonId, String> locales = this.locales((Set<PersonId>)receiverPersonIds);
        ChatMessagePushFactoryContext context = new ChatMessagePushFactoryContext(conversation, message, sender, chatPushTargets, (Map<PersonId, JabberPresence>)apnsJabberPresences, (Map<PersonId, Integer>)unreadMessagesCounts, (Map<PersonId, Integer>)fcmUnreadConversationCounts, (Map<PersonId, ConversationSettings>)conversationSettings, locales);
        return Optional.of(context);
    }

    @CheckForNull
    private Conversation conversation(ChatMessage message) {
        return (Conversation)this._messageReadDataService.getConversationsByIds((Set<ConversationId>)ImmutableSet.of((Object)message.getConversationId())).get((Object)message.getConversationId());
    }

    @CheckForNull
    private DBPerson sender(ChatMessage message) {
        PersonId senderPersonId = message.getSentFrom().asPersonId();
        return this._personReadDataService.getPersonById(senderPersonId);
    }

    @Nonnull
    private ImmutableSetMultimap<PersonId, PushTargetApp> chatPushTargets(Conversation conversation, ChatMessage message) {
        ImmutableList groupParticipants = this._userGroupService.getUserGroupMembersByIds(conversation.getUserGroups()).values().asList();
        ImmutableSet allParticipants = ImmutableSet.builder().addAll(conversation.getParticipants()).addAll((Iterable)groupParticipants).build();
        ImmutableSetMultimap participantsWithChatPushTarget = (ImmutableSetMultimap)this._pushNotificationService.getPushTargetAppsByPersonIds((Set<PersonId>)allParticipants).entries().stream().filter(entry -> ((PushTargetApp)entry.getValue()).getAppName() == PushAppName.CHAT).collect(ImmutableSetMultimap.toImmutableSetMultimap(Map.Entry::getKey, Map.Entry::getValue));
        ImmutableMap<PersonId, DateTime> participantReadDates = this._messageReadDataService.getConversationReadDates(conversation.getId(), (ImmutableSet<PersonId>)participantsWithChatPushTarget.keySet());
        return (ImmutableSetMultimap)participantsWithChatPushTarget.entries().stream().filter(entry -> {
            ProfileId participant = ((PersonId)entry.getKey()).asProfileId();
            DateTime readDate = (DateTime)participantReadDates.get((Object)participant.asPersonId());
            return this.isValidReceiver(participant, readDate, message);
        }).collect(ImmutableSetMultimap.toImmutableSetMultimap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private boolean isValidReceiver(@Nullable ProfileId participant, @Nullable DateTime readDate, ChatMessage message) {
        if (participant == null) {
            return false;
        }
        boolean isSender = Objects.equals(message.getSentFrom(), participant);
        boolean messageAlreadyRead = readDate != null && !message.getCreateDate().isAfter((ReadableInstant)readDate);
        return isSender || !messageAlreadyRead;
    }

    @Nonnull
    private ImmutableMap<PersonId, JabberPresence> apnsJabberPresences(ImmutableSetMultimap<PersonId, PushTargetApp> chatPushTargets) {
        Set<PersonId> apnsReceivers = chatPushTargets.entries().stream().filter(entry -> PushTargetApps.isApns((PushTargetApp)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
        return this._xmppService.getPresenceByUserIdsAndResourcePrefix(apnsReceivers, JCXmppResourcePrefix.DESKTOP, EverythingAllowedAuthorizationCheckContext.INSTANCE);
    }

    @Nonnull
    private ImmutableMap<PersonId, Integer> fcmUnreadConversationCounts(ImmutableSetMultimap<PersonId, PushTargetApp> chatPushTargets) {
        ImmutableSet fcmReceivers = (ImmutableSet)chatPushTargets.entries().stream().filter(entry -> PushTargetApps.isFcm((PushTargetApp)entry.getValue())).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
        return this._messageReadDataService.getUnreadConversationsCountsForPersons((ImmutableSet<PersonId>)fcmReceivers);
    }

    @Nonnull
    private ImmutableMap<PersonId, ConversationSettings> conversationsSettings(Set<PersonId> personIds, ConversationId conversationId) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        personIds.forEach(personId -> builder.put(personId, (Object)conversationId));
        ImmutableTable<PersonId, ConversationId, ConversationSettings> settingsTable = this._messageReadDataService.getConversationsSettings((ImmutableSetMultimap<PersonId, ConversationId>)builder.build());
        return settingsTable.column((Object)conversationId);
    }

    @Nonnull
    private Map<PersonId, String> locales(Set<PersonId> personIds) {
        return this._personReadDataService.getPersonsByIds(personIds).entrySet().stream().filter(entry -> ((DBPerson)entry.getValue()).getLanguageId() != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((DBPerson)entry.getValue()).getLanguageId()));
    }
}

