/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.business.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.chat.model.AttachmentChatMessage;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.chat.model.TextChatMessage;
import de.justsoftware.onx.chat.shared.model.JabberPresence;
import de.justsoftware.onx.chat.util.ChatMessages;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.model.ConversationSettings;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.message.shared.model.ConversationType;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.push.i18n.PushMessages;
import de.justsoftware.onx.push.shared.model.PushNotificationProtocol;
import de.justsoftware.onx.push.shared.model.PushTargetApp;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class ChatMessagePushFactoryContext {
    private final Conversation _conversation;
    private final ChatMessage _message;
    private final DBPerson _sender;
    private final ImmutableSetMultimap<PersonId, PushTargetApp> _pushTargets;
    private final Map<PersonId, JabberPresence> _apnsJabberPresences;
    private final Map<PersonId, Integer> _unreadMessagesCounts;
    private final Map<PersonId, Integer> _fcmUnreadConversationsCounts;
    private final Map<PersonId, ConversationSettings> _conversationsSettings;
    private final Map<PersonId, String> _locales;

    ChatMessagePushFactoryContext(Conversation conversation, ChatMessage message, DBPerson sender, ImmutableSetMultimap<PersonId, PushTargetApp> pushTargets, Map<PersonId, JabberPresence> apnsJabberPresences, Map<PersonId, Integer> unreadMessagesCounts, Map<PersonId, Integer> fcmUnreadConversationsCounts, Map<PersonId, ConversationSettings> conversationsSettings, Map<PersonId, String> locales) {
        this._conversation = conversation;
        this._message = message;
        this._sender = sender;
        this._pushTargets = pushTargets;
        this._apnsJabberPresences = apnsJabberPresences;
        this._unreadMessagesCounts = unreadMessagesCounts;
        this._fcmUnreadConversationsCounts = fcmUnreadConversationsCounts;
        this._conversationsSettings = conversationsSettings;
        this._locales = locales;
    }

    @Nonnull
    Stream<Map.Entry<PersonId, PushTargetApp>> pushTargetStream(PushNotificationProtocol protocol) {
        return this._pushTargets.entries().stream().filter(entry -> ((PushTargetApp)entry.getValue()).getProtocol() == protocol);
    }

    @Nonnull
    public Conversation getConversation() {
        return this._conversation;
    }

    @Nonnull
    ChatMessage getMessage() {
        return this._message;
    }

    @Nonnull
    ConversationId getConversationId() {
        return this._conversation.getId();
    }

    @Nonnull
    DBPerson getSender() {
        return this._sender;
    }

    int getUnreadMessagesCount(PersonId personId) {
        return Numbers.intValue(this._unreadMessagesCounts.get(personId));
    }

    boolean isChatMutedFor(PersonId personId) {
        ConversationSettings settings = this._conversationsSettings.get(personId);
        return settings != null ? settings.isMuted() : false;
    }

    int getFcmReceiverUnreadConversationsCount(PersonId personId) {
        return Numbers.intValue(this._fcmUnreadConversationsCounts.get(personId));
    }

    boolean isApnsReceiverOnline(PersonId personId) {
        JabberPresence jabberPresence = this._apnsJabberPresences.get(personId);
        return jabberPresence != null && jabberPresence.isAvailable();
    }

    boolean isReceiverDifferentFromSender(PersonId receiverPersonId) {
        return !Objects.equals(receiverPersonId, this._sender.getId());
    }

    boolean isAboutDeletedParticipant(PersonId receiverPersonId) {
        return ChatMessages.isAboutDeletedParticipant(this._message, receiverPersonId.asProfileId());
    }

    @Nonnull
    String chatTitle() {
        if (this._conversation.getType() == ConversationType.ONE_ON_ONE) {
            return "";
        }
        return (String)MoreObjects.firstNonNull((Object)this._conversation.getCustomTitle(), (Object)"");
    }

    @Nonnull
    String messageText(PersonId receiverPersonId, I18nService i18nService) {
        String locale = this._locales.get(receiverPersonId);
        if (this._message instanceof TextChatMessage) {
            return ((TextChatMessage)this._message).getMessage();
        }
        if (this._message instanceof AttachmentChatMessage) {
            AttachmentChatMessage attachment = (AttachmentChatMessage)this._message;
            PushMessages i18n = i18nService.createProxy(PushMessages.class, locale);
            return attachment.getAttachment().isImageContentType() ? i18n.newImage(attachment.getAttachment().getFilename()) : i18n.newDocument(attachment.getAttachment().getFilename());
        }
        return "";
    }
}

