/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.chat.model.ChatMessageType;
import de.justsoftware.onx.chat.util.ChatMessages;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.message.business.ChatBotService;
import de.justsoftware.onx.message.model.ChatBotTalkPayload;
import de.justsoftware.onx.message.model.ChatBotTextResponse;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.shared.model.ConversationType;
import de.justsoftware.onx.message.util.Conversations;
import de.justsoftware.onx.util.server.RequestBuilder;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

@Service
@ParametersAreNonnullByDefault
public class ChatBotServiceImpl
implements ChatBotService {
    private static final Logger LOG = LoggerFactory.getLogger(ChatBotServiceImpl.class);
    @VisibleForTesting
    final String _talkEndpointUrl;
    private final String _welcomeEndpointUrl;
    private final Settings _settings;
    private final RestOperations _restOperations;

    @Autowired
    public ChatBotServiceImpl(@Value(value="${justchatbot.api.url}") String apiUrl, Settings settings, @Qualifier(value="defaultRestTemplate") RestOperations restOperations) {
        this._settings = settings;
        this._restOperations = restOperations;
        this._talkEndpointUrl = apiUrl + "/talk";
        this._welcomeEndpointUrl = apiUrl + "/welcome?user={user}&locale={locale}";
    }

    @Override
    public Optional<String> getResponse(Conversation conversation, ChatMessage message, @Nullable String locale) {
        if (!this.isChatBotConfigured() || !this.isMessageForChatBot(conversation, message)) {
            return Optional.empty();
        }
        Optional<String> text = ChatMessages.getText(message);
        if (!text.isPresent()) {
            return Optional.empty();
        }
        ChatBotTalkPayload payload = new ChatBotTalkPayload(text.get(), locale);
        ChatBotTextResponse response = this.getResponseInternal(payload);
        return response != null ? Optional.of(response.getText()) : Optional.empty();
    }

    @Override
    public Optional<String> getWelcomeMessage(String userFirstName, @Nullable String locale) {
        if (!this.isChatBotConfigured()) {
            return Optional.empty();
        }
        ChatBotTextResponse response = this.getWelcomeMessageInternal(userFirstName, locale);
        return response != null ? Optional.of(response.getText()) : Optional.empty();
    }

    @Override
    public Optional<PersonId> getChatBotPersonId() {
        return this.isChatBotConfigured() ? Optional.ofNullable(PersonId.valueOf(this._settings.getChatBotPersonId())) : Optional.empty();
    }

    @VisibleForTesting
    boolean isChatBotConfigured() {
        return this._settings.isChatBotEnabled() && !Long.valueOf(-1L).equals(this._settings.getChatBotPersonId());
    }

    @CheckForNull
    private ChatBotTextResponse getResponseInternal(ChatBotTalkPayload payload) {
        try {
            ResponseEntity<ChatBotTextResponse> responseEntity = new RequestBuilder<ChatBotTextResponse>(ChatBotTextResponse.class).url(this._talkEndpointUrl).headers((Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json;charset=UTF-8")).post(payload).execute(this._restOperations);
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                this.logHttpStatusError(responseEntity.getStatusCode(), "response");
                return null;
            }
            return (ChatBotTextResponse)responseEntity.getBody();
        }
        catch (RestClientException e) {
            LOG.error("Error getting response from chatbot at " + this._talkEndpointUrl, (Throwable)e);
            return null;
        }
    }

    @CheckForNull
    private ChatBotTextResponse getWelcomeMessageInternal(String user, @Nullable String locale) {
        try {
            ResponseEntity<ChatBotTextResponse> responseEntity = new RequestBuilder<ChatBotTextResponse>(ChatBotTextResponse.class).url(this._welcomeEndpointUrl).addParameter("user", user).addParameter("locale", locale).execute(this._restOperations);
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                this.logHttpStatusError(responseEntity.getStatusCode(), "welcome message");
                return null;
            }
            return (ChatBotTextResponse)responseEntity.getBody();
        }
        catch (RestClientException e) {
            LOG.error("Error getting welcome message from chatbot at " + this._talkEndpointUrl, (Throwable)e);
            return null;
        }
    }

    private void logHttpStatusError(HttpStatus status, String requestedName) {
        LOG.error("Error getting {} from chatbot at {}, http status {} ({})", new Object[]{requestedName, this._talkEndpointUrl, status.toString(), status.getReasonPhrase()});
    }

    @VisibleForTesting
    boolean isMessageForChatBot(Conversation conversation, ChatMessage message) {
        boolean isOneOnOneTextMessage;
        boolean bl = isOneOnOneTextMessage = conversation.getType() == ConversationType.ONE_ON_ONE && message.getType() == ChatMessageType.CHAT_MESSAGE;
        if (!isOneOnOneTextMessage) {
            return false;
        }
        PersonId recipientId = Conversations.firstRecipientId(conversation, message.getSentFrom().asPersonId());
        return this.isChatBot(recipientId);
    }

    private boolean isChatBot(@Nullable PersonId personId) {
        return personId != null && Long.valueOf(personId.getId()).equals(this._settings.getChatBotPersonId());
    }
}

