/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.business.events;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.shared.model.ConversationId;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class ConversationUpdatedEvent
implements ServerEvent {
    private static final ImmutableSet<PersonId> EMPTY_SET = ImmutableSet.of();
    private final ConversationId _conversationId;
    private final ImmutableSet<PersonId> _addedParticipants;
    private final ImmutableSet<PersonId> _removedParticipants;
    private final Optional<String> _newTitle;
    private final boolean _updated;

    public ConversationUpdatedEvent(ConversationId conversationId, @Nullable Set<PersonId> addedParticipants, @Nullable Set<PersonId> removedParticipants, @Nullable String newTitle, boolean updated) {
        this._conversationId = conversationId;
        this._addedParticipants = addedParticipants != null ? ImmutableSet.copyOf(addedParticipants) : EMPTY_SET;
        this._removedParticipants = removedParticipants != null ? ImmutableSet.copyOf(removedParticipants) : EMPTY_SET;
        this._newTitle = Optional.fromNullable((Object)newTitle);
        this._updated = updated;
    }

    @Nonnull
    public static ConversationUpdatedEvent forNewConversation(Conversation conversation) {
        return new ConversationUpdatedEvent(conversation.getId(), (Set<PersonId>)conversation.getParticipants(), (Set<PersonId>)conversation.getDeletedParticipants(), conversation.getCustomTitle(), false);
    }

    @Nonnull
    public static ConversationUpdatedEvent forParticipantUpdate(ConversationId conversationId, Set<PersonId> addedParticipants, Set<PersonId> removedParticipants) {
        return new ConversationUpdatedEvent(conversationId, addedParticipants, removedParticipants, null, true);
    }

    @Nonnull
    public static ConversationUpdatedEvent forTitleUpdate(ConversationId conversationId, @Nullable String newTitle) {
        return new ConversationUpdatedEvent(conversationId, null, null, newTitle, true);
    }

    @Nonnull
    public static ConversationUpdatedEvent forUnspecificUpdate(ConversationId conversationId) {
        return new ConversationUpdatedEvent(conversationId, null, null, null, true);
    }

    @Nonnull
    public ConversationId getConversationId() {
        return this._conversationId;
    }

    @Nonnull
    public ImmutableSet<PersonId> getAddedParticipants() {
        return this._addedParticipants;
    }

    @Nonnull
    public ImmutableSet<PersonId> getRemovedParticipants() {
        return this._removedParticipants;
    }

    @Nonnull
    public Optional<String> getNewTitle() {
        return this._newTitle;
    }

    public boolean isNewConversation() {
        return !this._updated;
    }
}

