/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.business;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.chat.model.ChatMessageType;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBMessageCreationModel;
import de.justsoftware.onx.message.model.ConversationSettings;
import de.justsoftware.onx.message.shared.model.ChatMessageId;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.message.shared.model.ConversationType;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import java.util.Set;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public interface MessageWriteDataService {
    @Nonnull
    public ChatMessage insertNewMessage(DBMessageCreationModel var1);

    @Nonnull
    public ConversationId createNewConversation(ConversationType var1, Set<PersonId> var2, ImmutableSet<UserGroupId> var3, @Nullable String var4, DateTime var5, @Nullable UUID var6, TenantId var7);

    public void updateConversationParticipants(ConversationId var1, Set<PersonId> var2, Set<PersonId> var3, @Nullable DateTime var4);

    public void updateConversationUserGroups(ConversationId var1, ImmutableSet<UserGroupId> var2, ImmutableSet<UserGroupId> var3, ImmutableSet<PersonId> var4, @Nullable DateTime var5);

    public void insertConversationChangeForPersonsLeavingConversation(ConversationId var1, Set<PersonId> var2);

    public boolean markConversationAsRead(PersonId var1, ConversationId var2);

    public boolean markConversationAsRead(PersonId var1, ConversationId var2, DateTime var3);

    public void markConversationParticipantsAsDeleted(Set<PersonId> var1);

    public void markEmailsSent(SetMultimap<PersonId, ConversationId> var1, DateTime var2);

    public void setConversationTitle(ConversationId var1, String var2);

    public void insertConversationSettings(ConversationSettings var1, DateTime var2, DateTime var3);

    public boolean updateConversationSettings(ConversationSettings var1, DateTime var2);

    public void deleteConversation(ConversationId var1);

    public void updateConversationParticipantsAsDeletedWithConversation(ConversationId var1);

    public void updateConversationUserGroupsAsDeletedWithConversation(ConversationId var1, ImmutableSet<PersonId> var2);

    public void unhideConversation(ConversationId var1, Set<PersonId> var2, DateTime var3);

    @CheckForNull
    public ChatMessage updateMessageAsDeleted(ChatMessageId var1, ChatMessageType var2);
}

