/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.business;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContextWithUserId;
import de.justsoftware.onx.chat.model.AttachmentChatMessage;
import de.justsoftware.onx.chat.model.AttachmentFilter;
import de.justsoftware.onx.chat.model.ChatAttachment;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.common.server.model.HasMoreList;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationChange;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.model.ConversationReadData;
import de.justsoftware.onx.message.model.ConversationSettings;
import de.justsoftware.onx.message.model.MessageLoadDirection;
import de.justsoftware.onx.message.model.MessagesSection;
import de.justsoftware.onx.message.shared.model.ChatMessageId;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.message.shared.model.ConversationType;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public interface MessageService {
    @Nonnull
    public Conversation getOrCreateConversation(ConversationType var1, ImmutableSet<PersonId> var2, ImmutableSet<UserGroupId> var3, @Nullable String var4, @Nullable UUID var5, AuthorizationCheckContextWithUserId var6);

    public void updateConversationParticipants(ConversationId var1, @Nullable ImmutableSet<PersonId> var2, @Nullable ImmutableSet<UserGroupId> var3, @Nullable DateTime var4, AuthorizationCheckContextWithUserId var5) throws IllegalStateException, InvalidIdServiceException;

    @Nonnull
    public Conversation getConversationById(ConversationId var1, AuthorizationCheckContext var2) throws InvalidIdServiceException, PermissionDeniedException;

    @Nonnull
    public HasMoreList<ChatMessage> getMessagesByConversation(ConversationId var1, @Nullable DateTime var2, int var3, MessageLoadDirection var4, AuthorizationCheckContext var5);

    @Nonnull
    public ImmutableList<ChatMessage> getUpdatedMessagesForLoggedInUser(AuthorizationCheckContextWithUserId var1, Set<ConversationId> var2, @Nullable DateTime var3, int var4);

    @Nonnull
    public ImmutableMap<ConversationId, Conversation> getRecentConversationsForLoggedInUser(AuthorizationCheckContextWithUserId var1, int var2, int var3);

    @Nonnull
    public ImmutableMap<ConversationId, Conversation> getUpdatedConversationsForLoggedInUser(AuthorizationCheckContextWithUserId var1, DateTime var2);

    public void updateConversationForTenantChange(PersonId var1, ImmutableSet<TenantId> var2, KafkaConsumerContext var3);

    @Nonnull
    public ImmutableList<DBConversationChange> getRecentConversationChangesForLoggedInUser(AuthorizationCheckContextWithUserId var1, DateTime var2);

    @Nonnull
    public ImmutableMap<ConversationId, Conversation> getConversationsForLoggedInUser(ConversationType var1, AuthorizationCheckContextWithUserId var2, int var3, int var4);

    @Nonnull
    public ImmutableMap<ConversationId, ConversationReadData> getUnreadMessagesCountForConversations(AuthorizationCheckContextWithUserId var1, ImmutableSet<ConversationId> var2);

    @Nonnull
    public DateTime markConversationAsRead(AuthorizationCheckContextWithUserId var1, ConversationId var2);

    public void markConversationAsRead(AuthorizationCheckContextWithUserId var1, ConversationId var2, DateTime var3);

    public void updateMultiUserConversationTitle(AuthorizationCheckContextWithUserId var1, ConversationId var2, @Nullable String var3, @Nullable DateTime var4) throws IllegalStateException, InvalidIdServiceException;

    @Nonnull
    public ImmutableMap<ConversationId, Conversation> getConversationsByIdsWithoutAuthorizationCheck(ImmutableCollection<ConversationId> var1);

    @Nonnull
    public ImmutableMap<ConversationId, Conversation> getConversationsByIds(ImmutableCollection<ConversationId> var1, AuthorizationCheckContextWithUserId var2);

    public int getUnreadConversationsCountForPerson(PersonId var1, TenantId var2);

    @Nonnull
    public String getConversationTitleForUser(Conversation var1, PersonId var2, String var3, @Nullable Map<PersonId, DBPerson> var4);

    @Nonnull
    public ImmutableMap<ConversationId, ChatMessage> getLatestChatMessage(ImmutableCollection<ConversationId> var1, AuthorizationCheckContext var2);

    @Nonnull
    public ChatMessage addTextChatMessage(ConversationId var1, String var2, @Nullable UUID var3, boolean var4, AuthorizationCheckContextWithUserId var5);

    @Nonnull
    public ChatMessage addAttachmentChatMessage(ConversationId var1, ChatAttachment var2, @Nullable UUID var3, boolean var4, AuthorizationCheckContextWithUserId var5);

    @Nonnull
    public MessagesSection getMessagesAroundId(ChatMessageId var1, int var2, AuthorizationCheckContextWithUserId var3);

    @Nonnull
    public HasMoreList<AttachmentChatMessage> getConversationAttachments(ConversationId var1, int var2, @Nullable DateTime var3, @Nullable AttachmentFilter var4, AuthorizationCheckContextWithUserId var5);

    @Nonnull
    public ChatMessage getMessageById(ChatMessageId var1, AuthorizationCheckContextWithUserId var2);

    @Nonnull
    public ImmutableMap<ConversationId, ConversationSettings> getConversationsSettingsOrDefaults(ImmutableSet<ConversationId> var1, AuthorizationCheckContextWithUserId var2);

    @Nonnull
    public ImmutableTable<PersonId, ConversationId, ConversationSettings> getConversationsSettingsOrDefaults(ImmutableSetMultimap<PersonId, ConversationId> var1);

    public void setConversationSettings(ConversationSettings var1, AuthorizationCheckContextWithUserId var2);

    public void deleteConversation(ConversationId var1, AuthorizationCheckContextWithUserId var2);

    @Nonnull
    public ChatMessage deleteMessage(ChatMessageId var1, AuthorizationCheckContextWithUserId var2);

    @Nonnull
    public ImmutableList<ConversationSettings> getUpdatedConversationSettingsForLoggedInUser(AuthorizationContextWithUserId var1, DateTime var2);

    @Nonnull
    public ImmutableSet<PersonId> getUpdatedPersonsForLoggedInUser(AuthorizationContextWithUserId var1, ImmutableSet<ConversationId> var2, DateTime var3);

    @Nonnull
    public ImmutableSet<UserGroupId> getUpdatedUserGroupsForLoggedInUser(AuthorizationContextWithUserId var1, ImmutableSet<ConversationId> var2, DateTime var3);

    @Nonnull
    public ImmutableSet<ConversationId> getRecentlyJoinedConversations(AuthorizationContextWithUserId var1, DateTime var2);

    @Nonnull
    public ImmutableMap<ConversationId, Conversation> getOneOnOneConversationsWithUpdatedUsersForLoggedInUser(AuthorizationContextWithUserId var1, DateTime var2);

    @Nonnull
    public DateTime getChatTime();

    public void createAndSendSystemMessageForDeletedPersons(PersonId var1, Collection<ConversationId> var2);

    public void deleteAllConversationsForTenantUnauthorized(TenantId var1);

    public void checkAuthorsOfConversation(ConversationId var1, ImmutableSet<PersonId> var2) throws InvalidIdServiceException;
}

