/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.message.business;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import de.justsoftware.onx.chat.model.AttachmentChatMessage;
import de.justsoftware.onx.chat.model.ChatMessage;
import de.justsoftware.onx.common.server.model.HasMoreList;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationChange;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationParticipant;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBConversationUserGroup;
import de.justsoftware.onx.message.integration.persistence.ibatis.DBMailMessageInfo;
import de.justsoftware.onx.message.model.Conversation;
import de.justsoftware.onx.message.model.ConversationReadData;
import de.justsoftware.onx.message.model.ConversationSettings;
import de.justsoftware.onx.message.model.MessageLoadDirection;
import de.justsoftware.onx.message.shared.model.ChatMessageId;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.message.shared.model.ConversationType;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public interface MessageReadDataService {
    @Nonnull
    public ImmutableSet<ConversationId> getOneOnOneConversationWithUser(PersonId var1, PersonId var2);

    @Nonnull
    public ImmutableList<Conversation> getAllConversationsByDirectParticipant(PersonId var1);

    @Nonnull
    public ImmutableSet<PersonId> getOneOnOneConversationPartnersByPersonId(PersonId var1);

    @Nonnull
    public ImmutableMap<ConversationId, Conversation> getConversationsByIds(Set<ConversationId> var1);

    @Nonnull
    public ImmutableSet<ConversationId> getConversationIdsOfTenant(TenantId var1);

    @Nonnull
    public ImmutableMap<ChatMessageId, ChatMessage> getMessagesByIds(ImmutableSet<ChatMessageId> var1);

    @Nonnull
    public ImmutableMap<ConversationId, ChatMessage> getLatestChatMessage(Set<ConversationId> var1);

    @Nonnull
    public ImmutableList<ChatMessage> getUpdatedMessages(Set<ConversationId> var1, @Nullable DateTime var2, int var3);

    @Nonnull
    public HasMoreList<ChatMessage> getMessagesByConversation(ConversationId var1, @Nullable DateTime var2, int var3, MessageLoadDirection var4);

    @Nonnull
    public ImmutableMap<ConversationId, Conversation> getRecentConversationsForUser(PersonId var1, TenantId var2, int var3, int var4);

    @Nonnull
    public ImmutableMap<ConversationId, Conversation> getUpdatedConversationsForUser(PersonId var1, TenantId var2, DateTime var3);

    @Nonnull
    public ImmutableList<DBConversationChange> getRecentConversationChangesForUser(PersonId var1, TenantId var2, DateTime var3);

    @Nonnull
    public ImmutableMap<ConversationId, Conversation> getConversationsForUser(ConversationType var1, PersonId var2, TenantId var3, int var4, int var5);

    @Nonnull
    public ImmutableSet<ConversationId> getConversationIdsForAllUsers();

    @Nonnull
    public ImmutableList<DBMailMessageInfo> getUnreadMessagesForMail();

    @Nonnull
    public ImmutableList<DBConversationParticipant> getDBConversationParticipantsByConversationIds(Set<? extends ConversationId> var1);

    @Nonnull
    public ImmutableSet<PersonId> getDirectParticipantIdsByConversationIds(Set<ConversationId> var1);

    @Nonnull
    public ImmutableSet<ConversationId> getUnreadConversationsForPerson(PersonId var1, TenantId var2);

    @Nonnull
    public ImmutableMap<PersonId, Integer> getUnreadConversationsCountsForPersons(ImmutableSet<PersonId> var1);

    @Nonnull
    public ImmutableMap<PersonId, Integer> getUnreadMessagesCountsForPersons(ImmutableSet<PersonId> var1);

    public boolean isConversationUnreadForPerson(ConversationId var1, PersonId var2);

    @Nonnull
    public ImmutableMap<ConversationId, ConversationReadData> getUnreadMessagesCountForConversations(PersonId var1, ImmutableSet<ConversationId> var2);

    @Nonnull
    public ImmutableSet<PersonId> fetchParticipantsSharingAConversationWith(PersonId var1);

    public boolean isParticipantOfACommonConversation(PersonId var1, PersonId var2);

    @Nonnull
    public ImmutableSetMultimap<PersonId, ConversationId> getConversationIdsByParticipants(Set<PersonId> var1);

    @Nonnull
    public HasMoreList<ChatMessage> getAttachmentMessagesByConversation(ConversationId var1, int var2, @Nullable DateTime var3);

    @Nonnull
    public HasMoreList<ChatMessage> getAttachmentMessagesByConversationFiltered(ConversationId var1, int var2, @Nullable DateTime var3, ImmutableSet<String> var4);

    @Nonnull
    public HasMoreList<ChatMessage> getAttachmentMessagesByConversationExcluded(ConversationId var1, int var2, @Nullable DateTime var3, ImmutableSet<String> var4);

    @Nonnull
    public ImmutableTable<PersonId, ConversationId, ConversationSettings> getConversationsSettings(ImmutableSetMultimap<PersonId, ConversationId> var1);

    @Nonnull
    public DateTime getChatTime();

    @Nonnull
    public ImmutableList<ConversationSettings> getUpdatedConversationSettings(PersonId var1, TenantId var2, DateTime var3);

    @Nonnull
    public ImmutableSet<PersonId> getUpdatedPersonsForUser(PersonId var1, TenantId var2, DateTime var3);

    @Nonnull
    public ImmutableMap<ConversationId, Conversation> getOneOnOneConversationsWithUpdatedUsers(PersonId var1, TenantId var2, DateTime var3);

    @Nonnull
    public ImmutableMap<PersonId, DateTime> getConversationReadDates(ConversationId var1, ImmutableSet<PersonId> var2);

    @Nonnull
    public ImmutableList<AttachmentChatMessage> getMessagesByDocumentIds(ImmutableSet<DriveDocumentId> var1);

    @Nonnull
    public ImmutableMap<ConversationId, TenantId> getAllConversations(int var1, int var2);

    @Nonnull
    public ImmutableList<ConversationId> getAllGroupConversations(int var1, int var2);

    @Nonnull
    public ImmutableSet<PersonId> filterConversationAuthors(ConversationId var1, ImmutableSet<PersonId> var2);

    @Nonnull
    public ImmutableSet<DBConversationUserGroup> deleteUserGroupsFromAllConversations(ImmutableSet<UserGroupId> var1);

    @Nonnull
    public ImmutableSetMultimap<UserGroupId, ConversationId> getConversationIdsByUserGroupIds(ImmutableSet<UserGroupId> var1);

    @Nonnull
    public ImmutableSet<UserGroupId> getUpdatedUserGroupsForUser(PersonId var1, TenantId var2, DateTime var3);

    @Nonnull
    public ImmutableSet<ConversationId> getRecentlyJoinedConversations(PersonId var1, TenantId var2, DateTime var3);

    @Nonnull
    public ImmutableSet<UserGroupId> getUserGroupIdsByConversations(ImmutableSet<ConversationId> var1);
}

