/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.menu.server.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.StaticPredefinedRole;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.menu.server.model.AllEntitiesMenuLinkDefinition;
import de.justsoftware.onx.menu.server.model.CustomMenuLinkDefinition;
import de.justsoftware.onx.menu.server.model.MyContentsMenuLinkDefinition;
import de.justsoftware.onx.menu.server.model.MySubscribedPagesMenuLinkDefinition;
import de.justsoftware.onx.menu.server.model.StaticMenuLinkDefinition;
import de.justsoftware.onx.menu.shared.model.MenuLinkLevel;
import de.justsoftware.onx.menu.shared.model.MenuLinkVisitor;
import de.justsoftware.onx.menu.shared.model.StaticDefaultMenuLinkVisitor;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class MenuLinkDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ImmutableSet<String> ALL_SET = ImmutableSet.of((Object)StaticPredefinedRole.ALL.name());
    private static final ImmutableSet<String> LOGGED_IN_SET = ImmutableSet.of((Object)StaticPredefinedRole.LOGGED_IN.name());
    private final MenuLinkLevel _linkLevel;
    private final ImmutableSet<String> _roles;

    public MenuLinkDefinition(@Nullable MenuLinkLevel linkLevel, @Nonnull ImmutableSet<String> roles) {
        this._linkLevel = linkLevel;
        this._roles = MenuLinkDefinition.normalizeRoles(roles);
    }

    @Nonnull
    private static ImmutableSet<String> normalizeRoles(@Nonnull ImmutableSet<String> roles) {
        if (roles.isEmpty()) {
            return LOGGED_IN_SET;
        }
        if (roles.contains((Object)StaticPredefinedRole.ALL.name())) {
            return ALL_SET;
        }
        if (roles.contains((Object)StaticPredefinedRole.LOGGED_IN.name())) {
            return LOGGED_IN_SET;
        }
        return roles;
    }

    @CheckForNull
    public MenuLinkLevel getLinkLevel() {
        return this._linkLevel;
    }

    @Nonnull
    public ImmutableSet<String> getRoles() {
        return this._roles;
    }

    @Nonnull
    public abstract <R> R accept(@Nonnull Visitor<R> var1);

    protected MoreObjects.ToStringHelper getToStringHelper() {
        return MoreObjects.toStringHelper(this.getClass()).add("linkLevel", (Object)this._linkLevel).add("roles", this._roles);
    }

    public String toString() {
        return this.getToStringHelper().toString();
    }

    @Nonnull
    public final ImmutableList<?> getHashObjects() {
        return this._linkLevel != null ? ImmutableList.of((Object)this._linkLevel.getLevel(), (Object)((Object)this._linkLevel.getExpandStatus()), this._roles) : ImmutableList.of(this._roles);
    }

    public static abstract class StaticDefaultVisitor<R>
    extends StaticDefaultMenuLinkVisitor<R, StaticMenuLinkDefinition, CustomMenuLinkDefinition, MyContentsMenuLinkDefinition, MySubscribedPagesMenuLinkDefinition, AllEntitiesMenuLinkDefinition>
    implements Visitor<R> {
        @Override
        public final R visitDeprecatedEntityTypeLink(EntityType entityType, StaticMenuLinkDefinition s) {
            return this.visitMyContentsLink(new MyContentsMenuLinkDefinition(s.getLinkLevel(), s.getRoles(), entityType));
        }
    }

    public static interface Visitor<R>
    extends MenuLinkVisitor<R, StaticMenuLinkDefinition, CustomMenuLinkDefinition, MyContentsMenuLinkDefinition, MySubscribedPagesMenuLinkDefinition, AllEntitiesMenuLinkDefinition> {
    }
}

