/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.mail.business.MailType;
import de.justsoftware.onx.mail.business.impl.VelocityResourceManager;
import de.justsoftware.onx.mail.i18n.CommonMails;
import de.justsoftware.onx.mail.i18n.EntityMails;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResource;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VelocityResourceManagerImpl
implements VelocityResourceManager {
    private static final String NAME_SEPERATOR = "_";
    private final I18nService _i18nService;

    @Autowired
    @ParametersAreNonnullByDefault
    public VelocityResourceManagerImpl(I18nService i18nService) {
        this._i18nService = i18nService;
    }

    @Nonnull
    private String getResourceNameFor(@Nonnull MailType type, @Nullable EntityType entityType, @Nullable String languageId) {
        StringBuilder result = new StringBuilder(type.name());
        if (entityType != null) {
            result.append(NAME_SEPERATOR).append(entityType.getName());
        }
        if (languageId != null) {
            result.append(NAME_SEPERATOR).append(languageId);
        }
        return result.toString();
    }

    @Override
    public String getResourceName(String subject) {
        return this.addResource(subject, subject);
    }

    @Override
    public String getResourceName(MailType type, EntityType entityType, String languageId) {
        String resourceName = this.getResourceNameFor(type, entityType, languageId);
        StringResource cachedResource = this.getRepository().getStringResource(resourceName);
        if (cachedResource != null) {
            return resourceName;
        }
        CommonMails commonMails = this._i18nService.createProxy(CommonMails.class, languageId);
        EntityMails entityMails = this._i18nService.getEntityMailsByEntityType(entityType, languageId);
        String templateString = type.getTemplateString(commonMails, entityMails);
        return this.addResource(resourceName, templateString);
    }

    @Override
    public void updateResourceProperties(VelocityEngine velocityEngine) {
        velocityEngine.setProperty("resource.loader", (Object)"string");
        velocityEngine.setProperty("string.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.StringResourceLoader");
    }

    @Override
    public String addResource(String resourceName, String resource) {
        this.getRepository().putStringResource(resourceName, resource);
        return resourceName;
    }

    @Nonnull
    private StringResourceRepository getRepository() {
        StringResourceRepository repository = StringResourceLoader.getRepository();
        if (repository == null) {
            throw new IllegalStateException("velocity-string-resource-loader is unconfigured! can't fetch repository...");
        }
        return repository;
    }

    @Override
    public void removeResource(String resourceName) {
        this.getRepository().removeStringResource(resourceName);
    }
}

