/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.mail.business.MailModelService;
import de.justsoftware.onx.mail.business.MailService;
import de.justsoftware.onx.mail.business.RegistrationMailService;
import de.justsoftware.onx.mail.business.model.FooterMailModel;
import de.justsoftware.onx.mail.business.model.HeaderMailModel;
import de.justsoftware.onx.mail.business.model.MailReceiver;
import de.justsoftware.onx.mail.business.model.MailReceivers;
import de.justsoftware.onx.mail.business.model.RegistrationSuccessMailModel;
import de.justsoftware.onx.mail.business.model.ThemeMailModel;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class RegistrationMailServiceImpl
implements RegistrationMailService {
    private final MailService _mailService;
    private final MailModelService _mailModelService;
    private final I18nService _i18nService;
    private final Settings _settings;

    @Autowired
    public RegistrationMailServiceImpl(MailService mailService, MailModelService mailModelService, I18nService i18nService, Settings settings) {
        this._mailService = mailService;
        this._mailModelService = mailModelService;
        this._i18nService = i18nService;
        this._settings = settings;
    }

    @Override
    public boolean sendSuccessfulRegistrationEmail(DBPerson receiver, String pathToResetPassword) {
        return this._mailService.sendEmailImmediately(new RegistrationSuccessMailModelImpl(receiver, pathToResetPassword));
    }

    @ParametersAreNonnullByDefault
    private final class RegistrationSuccessMailModelImpl
    implements RegistrationSuccessMailModel {
        private final String _subject;
        private final MailReceiver _receiver;
        private final String _resetPasswordPath;
        private final String _fullName;
        private final HeaderMailModel _header;
        private final FooterMailModel _footer;
        private final ThemeMailModel _theme;

        private RegistrationSuccessMailModelImpl(DBPerson receiver, String resetPasswordPath) {
            this._header = RegistrationMailServiceImpl.this._mailModelService.getHeaderMailModel();
            this._footer = RegistrationMailServiceImpl.this._mailModelService.getFooterMailModel();
            this._theme = RegistrationMailServiceImpl.this._mailModelService.getThemeMailModel();
            this._receiver = MailReceivers.forPerson(receiver, RegistrationMailServiceImpl.this._settings);
            this._subject = RegistrationMailServiceImpl.this._i18nService.createProxy(ProfileConstants.class, this._receiver.getLocale().getLanguage()).welcome();
            this._resetPasswordPath = resetPasswordPath;
            this._fullName = receiver.getFullName();
        }

        @Override
        public String getSubject() {
            return this._subject;
        }

        @Override
        public MailReceiver getReceiver() {
            return this._receiver;
        }

        @Override
        public HeaderMailModel getHeader() {
            return this._header;
        }

        @Override
        public FooterMailModel getFooter() {
            return this._footer;
        }

        @Override
        public ThemeMailModel getTheme() {
            return this._theme;
        }

        @Override
        public String getResetPasswordPath() {
            return this._resetPasswordPath;
        }

        @Override
        public String getPlatformName() {
            return this.getHeader().getPlatformName();
        }

        @Override
        public String getName() {
            return this._fullName;
        }
    }
}

