/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.i18n.BasicConstants;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.mail.business.MailModelService;
import de.justsoftware.onx.mail.business.MailService;
import de.justsoftware.onx.mail.business.PersonActivateNewEmailMailService;
import de.justsoftware.onx.mail.business.model.FooterMailModel;
import de.justsoftware.onx.mail.business.model.HeaderMailModel;
import de.justsoftware.onx.mail.business.model.MailReceiver;
import de.justsoftware.onx.mail.business.model.MailReceivers;
import de.justsoftware.onx.mail.business.model.PersonActivateNewEmailMailModel;
import de.justsoftware.onx.mail.business.model.ThemeMailModel;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import java.time.Clock;
import java.time.LocalDateTime;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersonActivateNewEmailMailServiceImpl
implements PersonActivateNewEmailMailService {
    private final PersonService _personService;
    private final MailService _mailService;
    private final Settings _settings;
    private final I18nService _i18nService;
    private final MailModelService _mailModelService;
    private final Clock _clock;

    @ParametersAreNonnullByDefault
    @Autowired
    public PersonActivateNewEmailMailServiceImpl(PersonService personService, MailService mailService, Settings settings, I18nService i18nService, MailModelService mailModelService, Clock clock) {
        this._personService = personService;
        this._mailService = mailService;
        this._settings = settings;
        this._i18nService = i18nService;
        this._mailModelService = mailModelService;
        this._clock = clock;
    }

    @Override
    public void sendNewmailActivationEmail(String newmail, DBPerson person, AuthorizationCheckContextWithUserId authCtx) {
        if (person.canLogin()) {
            String code = this._personService.signedNewMailActivationCode(person.getId(), newmail, LocalDateTime.now(this._clock));
            MailReceiver receiver = MailReceivers.forEmail(newmail, (String)MoreObjects.firstNonNull((Object)person.getLanguageId(), (Object)authCtx.getLocale()), this._settings);
            BasicConstants basic = this._i18nService.createProxy(BasicConstants.class, receiver.getLocale().getLanguage());
            String link = "/newMail/" + code;
            this._mailService.sendEmail(new PersonActivateNewEmailMailModelImplementation(link, basic.kaiooNewMailSubject(), receiver, newmail));
        }
    }

    public final class PersonActivateNewEmailMailModelImplementation
    implements PersonActivateNewEmailMailModel {
        private final String _link;
        private final MailReceiver _receiver;
        private final String _newmail;
        private final String _subject;
        private final HeaderMailModel _headerMailModel;
        private final FooterMailModel _footerMailModel;
        private final ThemeMailModel _themeMailModel;

        @ParametersAreNonnullByDefault
        private PersonActivateNewEmailMailModelImplementation(String link, String subject, MailReceiver receiver, String newmail) {
            this._headerMailModel = PersonActivateNewEmailMailServiceImpl.this._mailModelService.getHeaderMailModel();
            this._footerMailModel = PersonActivateNewEmailMailServiceImpl.this._mailModelService.getFooterMailModel();
            this._themeMailModel = PersonActivateNewEmailMailServiceImpl.this._mailModelService.getThemeMailModel();
            this._link = link;
            this._subject = subject;
            this._receiver = receiver;
            this._newmail = newmail;
        }

        @Override
        public String getSubject() {
            return this._subject;
        }

        @Override
        public MailReceiver getReceiver() {
            return this._receiver;
        }

        @Override
        public String getActivationUrl() {
            return this._link;
        }

        @Override
        public String getNewEmailAddress() {
            return this._newmail;
        }

        @Override
        public HeaderMailModel getHeader() {
            return this._headerMailModel;
        }

        @Override
        public FooterMailModel getFooter() {
            return this._footerMailModel;
        }

        @Override
        public ThemeMailModel getTheme() {
            return this._themeMailModel;
        }
    }
}

