/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.mail.business.MailModelService;
import de.justsoftware.onx.mail.business.MailService;
import de.justsoftware.onx.mail.business.PasswordForgottenMailService;
import de.justsoftware.onx.mail.business.model.FooterMailModel;
import de.justsoftware.onx.mail.business.model.HeaderMailModel;
import de.justsoftware.onx.mail.business.model.MailReceiver;
import de.justsoftware.onx.mail.business.model.MailReceivers;
import de.justsoftware.onx.mail.business.model.PasswordForgottenMailModel;
import de.justsoftware.onx.mail.business.model.ThemeMailModel;
import de.justsoftware.onx.mail.i18n.EmailConstants;
import de.justsoftware.onx.person.model.DBPerson;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PasswordForgottenMailServiceImpl
implements PasswordForgottenMailService {
    private final MailService _mailService;
    private final Settings _settings;
    private final I18nService _i18nService;
    private final MailModelService _mailModelService;

    @Autowired
    @ParametersAreNonnullByDefault
    public PasswordForgottenMailServiceImpl(MailService mailService, Settings settings, I18nService i18nService, MailModelService mailModelService) {
        this._mailService = mailService;
        this._settings = settings;
        this._i18nService = i18nService;
        this._mailModelService = mailModelService;
    }

    @Override
    public boolean sendPasswordForgottenEmail(DBPerson person, String resetPasswordPath) {
        if (person.isDeleted() || person.isBlocked()) {
            return false;
        }
        MailReceiver receiver = MailReceivers.forPerson(person, this._settings);
        return this._mailService.sendEmailImmediately(new PasswordForgottenMailModelImplementation(receiver, !person.isActive(), resetPasswordPath));
    }

    final class PasswordForgottenMailModelImplementation
    implements PasswordForgottenMailModel {
        private final MailReceiver _receiver;
        private final String _resetPasswordPath;
        private final String _subject;
        private final ThemeMailModel _themeMailModel;
        private final FooterMailModel _footerMailModel;
        private final HeaderMailModel _headerMailModel;
        private final boolean _showInActiveText;

        private PasswordForgottenMailModelImplementation(MailReceiver receiver, @Nonnull boolean showInActiveText, String resetPasswordPath) {
            this._themeMailModel = PasswordForgottenMailServiceImpl.this._mailModelService.getThemeMailModel();
            this._footerMailModel = PasswordForgottenMailServiceImpl.this._mailModelService.getFooterMailModel();
            this._headerMailModel = PasswordForgottenMailServiceImpl.this._mailModelService.getHeaderMailModel();
            this._receiver = receiver;
            this._showInActiveText = showInActiveText;
            this._resetPasswordPath = resetPasswordPath;
            EmailConstants mailConstants = PasswordForgottenMailServiceImpl.this._i18nService.createProxy(EmailConstants.class, receiver.getLocale().getLanguage());
            this._subject = mailConstants.resetPasswordSubject();
        }

        @Override
        public ThemeMailModel getTheme() {
            return this._themeMailModel;
        }

        @Override
        public FooterMailModel getFooter() {
            return this._footerMailModel;
        }

        @Override
        public HeaderMailModel getHeader() {
            return this._headerMailModel;
        }

        @Override
        public String getSubject() {
            return this._subject;
        }

        @Override
        public MailReceiver getReceiver() {
            return this._receiver;
        }

        @Override
        public String getResetPasswordPath() {
            return this._resetPasswordPath;
        }

        @Override
        public String getPlatformName() {
            return this.getHeader().getPlatformName();
        }

        @Override
        public boolean isShowInActiveText() {
            return this._showInActiveText;
        }
    }
}

