/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InternalLinkService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.mail.business.EMailTemplate;
import de.justsoftware.onx.mail.business.GlobalMailTemplateKeys;
import de.justsoftware.onx.mail.business.MailManager;
import de.justsoftware.onx.mail.business.MailServiceOld;
import de.justsoftware.onx.mail.business.MailTemplateContext;
import de.justsoftware.onx.mail.business.MailType;
import de.justsoftware.onx.mail.business.SendMailException;
import de.justsoftware.onx.mail.i18n.EmailMessages;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MailServiceOldImpl
implements MailServiceOld {
    private static final Logger LOG = LoggerFactory.getLogger(MailServiceOldImpl.class);
    @Autowired
    private Settings _settings;
    @Resource(name="mailManager")
    private MailManager _mailManager;
    @Autowired
    private PersonService _personService;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private InternalLinkService _internalLinkService;

    @Override
    public void sendReportBlockedUserMail(PersonId blockedPersonId) {
        List<PersonId> personIdList;
        List<String> roleNames = this._settings.getMailReceivingRolesWhenProfileBlockedList();
        if (!CollectionUtil.isEmpty(roleNames) && !CollectionUtil.isEmpty(personIdList = this._personService.getPersonIdsByRole(roleNames))) {
            ImmutableMap<PersonId, DBPerson> recipientMap = this._personService.getPersonsByIds((Set<PersonId>)ImmutableSet.copyOf(personIdList));
            DBPerson blockedPerson = this._personService.getPersonById(blockedPersonId);
            if (blockedPerson == null) {
                LOG.error("Failed to report the blocking of person wid PersonId " + blockedPersonId);
                return;
            }
            MailTemplateContext context = new MailTemplateContext();
            context.put(GlobalMailTemplateKeys.PERSON, (Object)blockedPerson);
            context.put(GlobalMailTemplateKeys.PROFILE_URI, (Object)this._internalLinkService.getProfileUrl(blockedPersonId, InternalLinkService.LinkType.URL));
            ArrayListMultimap receiversGroupedByLocale = ArrayListMultimap.create();
            for (DBPerson dBPerson : recipientMap.values()) {
                if (!dBPerson.canLogin()) continue;
                receiversGroupedByLocale.put((Object)dBPerson.getLanguageId(), (Object)dBPerson);
            }
            for (Map.Entry entry : receiversGroupedByLocale.asMap().entrySet()) {
                EmailMessages msgs = this._i18nService.createProxy(EmailMessages.class, (String)entry.getKey());
                EMailTemplate email = new EMailTemplate(MailType.REPORT_BLOCKED_PERSON, null, context, msgs.personHasBeenBlocked(blockedPerson.getFullName()), (Collection<DBPerson>)((Collection)entry.getValue()));
                try {
                    this._mailManager.sendMail(email);
                }
                catch (SendMailException e1) {
                    LOG.error("Could not send " + MailType.REPORT_BLOCKED_PERSON + " notifcation email to " + entry.getValue() + " after person " + blockedPerson.getFullName() + " has been blocked." + e1.getMessage(), (Throwable)e1);
                }
            }
        }
    }
}

