/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.mail.EmailAttachment;
import de.justsoftware.mail.RenderedEmail;
import de.justsoftware.onx.mail.business.MailHtmlMessageBean;
import de.justsoftware.onx.mail.business.MailMessageBean;
import de.justsoftware.onx.mail.business.MailSender;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="mailSender")
public class MailSenderImpl
implements MailSender {
    private static final Logger LOG = LoggerFactory.getLogger(MailSenderImpl.class);
    private static final String TIMEOUT = "60000";
    @Autowired
    private Settings _settings;
    @Value(value="${smtp.override.recipient}")
    private String _overrideRecipient;

    @Override
    public boolean sendMail(MailMessageBean message) {
        String recipientsAddress = message.getRecipient();
        String text = message.getText();
        try {
            MimeMessage msg = this.createMessage(recipientsAddress, message.getSubject());
            msg.setText(text, Charsets.UTF_8.name());
            this.addHeadersAndSend((Message)msg);
            return true;
        }
        catch (RuntimeException | MessagingException e) {
            LOG.error("Fehler beim Senden der Mail an [" + recipientsAddress + "]\nNachricht:\n[" + text + "]", e);
            return false;
        }
    }

    @Override
    public boolean sendMixedMail(MailHtmlMessageBean msg) {
        String recipientsAddress = msg.getRecipient();
        String text = msg.getText();
        String html = msg.getHtml();
        try {
            MimeMessage message = this.createMessage(recipientsAddress, msg.getSubject());
            MimeMultipart content = new MimeMultipart("alternative");
            MimeBodyPart textPart = new MimeBodyPart();
            MimeBodyPart htmlPart = new MimeBodyPart();
            textPart.setText(text, Charsets.UTF_8.name());
            htmlPart.setContent((Object)html, "text/html; charset=\"UTF-8\"");
            content.addBodyPart((BodyPart)textPart);
            content.addBodyPart((BodyPart)htmlPart);
            message.setContent((Multipart)content);
            this.addHeadersAndSend((Message)message);
            return true;
        }
        catch (RuntimeException | MessagingException e) {
            LOG.error("Error sending mail to [" + recipientsAddress + "]", e);
            LOG.debug(text);
            LOG.debug(html);
            return false;
        }
    }

    @Nonnull
    private MimeMessage createMessage(String recipientsAddress, String subject) throws MessagingException {
        Session session = this.createSession();
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(this._settings.getSmtpSender()));
        message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)(StringUtils.isBlank((String)this._overrideRecipient) ? recipientsAddress : this._overrideRecipient), (boolean)false));
        message.setSubject(MailSenderImpl.escapeSubject((String)(StringUtils.isBlank((String)this._overrideRecipient) ? subject : recipientsAddress + "#" + subject)));
        message.setSentDate(new Date());
        ImmutableSet<String> listUnsubscribeUrls = this._settings.getListUnsubscribeUrls();
        if (!listUnsubscribeUrls.isEmpty()) {
            String joined = FluentIterable.from(listUnsubscribeUrls).transform(url -> "<" + url + ">").join(Joiner.on((String)", "));
            message.setHeader("List-Unsubscribe", joined);
        }
        return message;
    }

    @Nonnull
    private Session createSession() {
        Properties properties = new Properties();
        properties.put("mail.smtp.starttls.enable", String.valueOf(this._settings.isEnableTls()));
        properties.put("mail.smtp.host", this._settings.getSmtpServer());
        properties.put("mail.smtp.port", String.valueOf(this._settings.getSmtpPort()));
        properties.put("mail.smtp.auth", String.valueOf(StringUtils.isNotBlank((String)this._settings.getSmtpUsername())));
        properties.put("mail.smtp.timeout", TIMEOUT);
        properties.put("mail.smtp.connectiontimeout", TIMEOUT);
        properties.put("mail.smtp.writetimeout", TIMEOUT);
        return Session.getInstance((Properties)properties, (Authenticator)new MailAuthenticator());
    }

    @Nonnull
    @VisibleForTesting
    static String escapeSubject(@Nullable String subject) {
        if (subject == null) {
            return "";
        }
        return subject.replaceAll("\\s+", " ").trim();
    }

    @Override
    public boolean sendMail(String recipientsAddress, String subject, RenderedEmail renderedEmail) {
        try {
            MimeMessage message = this.createMessage(recipientsAddress, subject);
            MimeMultipart alternative = new MimeMultipart("alternative");
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setText(renderedEmail.getTextPart(), renderedEmail.getCharset().name());
            alternative.addBodyPart((BodyPart)textPart);
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setContent((Object)renderedEmail.getHtmlPart(), "text/html; charset=\"UTF-8\"");
            alternative.addBodyPart((BodyPart)htmlPart);
            MimeBodyPart alternativeBodyPart = new MimeBodyPart();
            alternativeBodyPart.setContent((Multipart)alternative);
            MimeMultipart related = new MimeMultipart("related");
            related.addBodyPart((BodyPart)alternativeBodyPart);
            for (EmailAttachment attachment : renderedEmail.getAttachments()) {
                MimeBodyPart attachmentPart = new MimeBodyPart();
                attachmentPart.setContentID("<" + attachment.getContentId() + ">");
                attachmentPart.setFileName(attachment.getFileName());
                attachmentPart.setDataHandler(new DataHandler((DataSource)new EmailAttachmentDataSource(attachment)));
                related.addBodyPart((BodyPart)attachmentPart);
            }
            message.setContent((Multipart)related);
            this.addHeadersAndSend((Message)message);
            return true;
        }
        catch (RuntimeException | MessagingException e) {
            LOG.error("Error sending mail to [" + recipientsAddress + "]", e);
            LOG.debug(renderedEmail.getTextPart());
            LOG.debug(renderedEmail.getHtmlPart());
            return false;
        }
    }

    private void addHeadersAndSend(@Nonnull Message message) throws MessagingException, AddressException {
        LOG.info("sending via {}:{} to [ " + Arrays.toString(message.getAllRecipients()) + " ]", (Object)this._settings.getSmtpServer(), (Object)this._settings.getSmtpPort());
        Transport.send((Message)message);
    }

    private static final class EmailAttachmentDataSource
    implements DataSource {
        private final EmailAttachment _attachment;

        public EmailAttachmentDataSource(@Nonnull EmailAttachment attachment) {
            this._attachment = attachment;
        }

        public InputStream getInputStream() throws IOException {
            return this._attachment.getAttachmentData().openBufferedStream();
        }

        public OutputStream getOutputStream() {
            return null;
        }

        public String getContentType() {
            return this._attachment.getContentType();
        }

        public String getName() {
            return this._attachment.getFileName();
        }
    }

    private final class MailAuthenticator
    extends Authenticator {
        private final PasswordAuthentication _passwordAuthentication;

        private MailAuthenticator() {
            this._passwordAuthentication = new PasswordAuthentication(MailSenderImpl.this._settings.getSmtpUsername(), MailSenderImpl.this._settings.getSmtpPassword());
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this._passwordAuthentication;
        }
    }
}

