/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageType;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.design.business.ThemeService;
import de.justsoftware.onx.design.shared.DefaultThemeAttributeValueFactory;
import de.justsoftware.onx.design.shared.model.Theme;
import de.justsoftware.onx.design.shared.model.ThemeAttribute;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import de.justsoftware.onx.mail.business.MailModelService;
import de.justsoftware.onx.mail.business.model.FooterMailModel;
import de.justsoftware.onx.mail.business.model.HeaderMailModel;
import de.justsoftware.onx.mail.business.model.ThemeMailModel;
import de.justsoftware.onx.mail.business.model.UnsubscribeLinkModel;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class MailModelServiceImpl
implements MailModelService {
    private final ThemeService _themeService;
    private final Settings _settings;

    @Autowired
    @ParametersAreNonnullByDefault
    public MailModelServiceImpl(ThemeService themeService, Settings settings) {
        this._themeService = themeService;
        this._settings = settings;
    }

    @Override
    public HeaderMailModel getHeaderMailModel() {
        String logo = MailModelServiceImpl.getLogoImagePath(this._themeService.getDefaultTheme());
        String defaultSiteTitle = this._settings.getDefaultSiteTitle();
        return MailModelServiceImpl.headerMailModel(defaultSiteTitle, logo);
    }

    @CheckForNull
    private static String getLogoImagePath(Theme theme) {
        ThemeAttribute logo = theme.getAttribute(ThemeAttributeType.EMAIL_HEADER_LOGO);
        if (logo == null) {
            return null;
        }
        String image = logo.getValue();
        if (StringUtils.isBlank((String)image)) {
            return null;
        }
        return ImageUrlUtil.getImagePath(ImageSize.EMAIL_HEADER_LOGO, ImageType.EMAIL_HEADER_LOGO, image);
    }

    @Nonnull
    @VisibleForTesting
    public static HeaderMailModel headerMailModel(String platformName, @Nullable String logo) {
        return new HeaderMailModelImplementation(platformName, logo);
    }

    @Override
    public FooterMailModel getFooterMailModel(ImmutableList<UnsubscribeLinkModel> unsubscriptionLinks) {
        return MailModelServiceImpl.footerMailModel(this._settings.getDefaultSiteTitle(), unsubscriptionLinks);
    }

    @Nonnull
    @VisibleForTesting
    public static FooterMailModelImplementation footerMailModel(String platformName, ImmutableList<UnsubscribeLinkModel> unsubscriptionLinks) {
        return new FooterMailModelImplementation(platformName, unsubscriptionLinks);
    }

    @Nonnull
    @VisibleForTesting
    public static FooterMailModelImplementation footerMailModel(String platformName) {
        return MailModelServiceImpl.footerMailModel(platformName, (ImmutableList<UnsubscribeLinkModel>)ImmutableList.of());
    }

    @Override
    public FooterMailModel getFooterMailModel() {
        return this.getFooterMailModel((ImmutableList<UnsubscribeLinkModel>)ImmutableList.of());
    }

    @Override
    public ThemeMailModel getThemeMailModel() {
        return new ThemeMailModelImplementation(this._themeService.getDefaultTheme());
    }

    @Nonnull
    @VisibleForTesting
    public static ThemeMailModel themeMailModelForTest() {
        return new ThemeMailModelImplementation(null);
    }

    public static final class HeaderMailModelImplementation
    implements HeaderMailModel {
        private final String _platformName;
        private final String _logo;

        public HeaderMailModelImplementation(@Nonnull String platformName, @Nullable String logo) {
            this._platformName = platformName;
            this._logo = logo;
        }

        @Override
        public String getPlatformName() {
            return this._platformName;
        }

        @Override
        public String getLogoPath() {
            return this._logo;
        }
    }

    @ParametersAreNonnullByDefault
    public static final class FooterMailModelImplementation
    implements FooterMailModel {
        private final String _platformName;
        private final ImmutableList<UnsubscribeLinkModel> _unsubscriptionLinks;

        public FooterMailModelImplementation(String platformName, ImmutableList<UnsubscribeLinkModel> unsubscriptionLinks) {
            this._platformName = platformName;
            this._unsubscriptionLinks = unsubscriptionLinks;
        }

        @Override
        public String getPlatformName() {
            return this._platformName;
        }

        @Override
        public ImmutableList<UnsubscribeLinkModel> getUnsubscriptionLinks() {
            return this._unsubscriptionLinks;
        }
    }

    public static final class ThemeMailModelImplementation
    implements ThemeMailModel {
        private final Theme _theme;

        public ThemeMailModelImplementation(@Nullable Theme theme) {
            this._theme = theme;
        }

        @Override
        public String getButtonColor() {
            return this.getAttributeValue(ThemeAttributeType.EMAIL_BUTTON_COLOR);
        }

        @Override
        public String getButtonTextColor() {
            return this.getAttributeValue(ThemeAttributeType.EMAIL_BUTTON_TEXT_COLOR);
        }

        @Override
        public String getTextColor() {
            return this.getAttributeValue(ThemeAttributeType.EMAIL_TEXT_COLOR);
        }

        @Override
        public String getLinkColor() {
            return this.getAttributeValue(ThemeAttributeType.EMAIL_LINK_COLOR);
        }

        @Override
        public String getLightLinkTextColor() {
            return this.getAttributeValue(ThemeAttributeType.EMAIL_LIGHT_LINK_TEXT_COLOR);
        }

        @Nonnull
        private String getAttributeValue(@Nonnull ThemeAttributeType attributeType) {
            if (this._theme == null) {
                return ThemeMailModelImplementation.defaultValue(attributeType);
            }
            ThemeAttribute attribute = this._theme.getAttribute(attributeType);
            if (attribute == null) {
                return ThemeMailModelImplementation.defaultValue(attributeType);
            }
            String value = attribute.getValue();
            if (StringUtils.isBlank((String)value)) {
                return ThemeMailModelImplementation.defaultValue(attributeType);
            }
            return value;
        }

        @Nonnull
        private static String defaultValue(@Nonnull ThemeAttributeType attributeType) {
            return (String)attributeType.accept(DefaultThemeAttributeValueFactory.INSTANCE).get();
        }
    }
}

