/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import de.justsoftware.onx.mail.business.EMailTemplate;
import de.justsoftware.onx.mail.business.GlobalMailTemplateKeys;
import de.justsoftware.onx.mail.business.MailManager;
import de.justsoftware.onx.mail.business.MailMessageBean;
import de.justsoftware.onx.mail.business.MailSender;
import de.justsoftware.onx.mail.business.MailTemplateManager;
import de.justsoftware.onx.mail.business.MailType;
import de.justsoftware.onx.mail.business.MultipartEMailTemplate;
import de.justsoftware.onx.mail.business.SendMailException;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="applicationMailManager")
public class MailManagerImpl
implements MailManager {
    private static final Logger LOG = LoggerFactory.getLogger(MailManagerImpl.class);
    private final MailTemplateManager _mailTemplateManager;
    private final MailSender _mailSender;
    private final PersonService _personService;

    @Autowired
    @ParametersAreNonnullByDefault
    public MailManagerImpl(MailTemplateManager mailTemplateManager, @Qualifier(value="mailSender") MailSender mailSender, PersonService personService) {
        this._mailTemplateManager = mailTemplateManager;
        this._mailSender = mailSender;
        this._personService = personService;
    }

    private boolean shouldSendMail(@Nullable DBPerson recipient, @Nonnull MailType type) {
        if (recipient == null) {
            return true;
        }
        if (recipient.isBlocked() || recipient.isDeleted()) {
            return false;
        }
        switch (type) {
            case STATIC: 
            case REPORT_BLOCKED_PERSON: {
                return recipient.isActive();
            }
            case IMPORTED_USER_GREETING: {
                return true;
            }
            case ENTITY_NEW_MEMBERSHIP_BY_IMPORT: {
                return this._personService.isEmailNotificationEnabled(recipient.getId());
            }
        }
        return recipient.isActive() && this._personService.isEmailNotificationEnabled(recipient.getId());
    }

    @Override
    public void sendMail(EMailTemplate template) throws SendMailException {
        boolean replaceRecipient = !template.getContext().containsKey(GlobalMailTemplateKeys.RECIPIENT);
        LinkedList<String> failedRecipients = new LinkedList<String>();
        for (DBPerson recipientPerson : template.getRecipients()) {
            String email = recipientPerson.getEmail();
            if (!StringUtils.isNotBlank((String)email)) continue;
            this.sendOneMail(template, recipientPerson, email, replaceRecipient, failedRecipients);
        }
        if (!failedRecipients.isEmpty()) {
            throw new SendMailException(failedRecipients);
        }
    }

    @CheckForNull
    private DBPerson lookupRecipient(@Nonnull String recipientAddress) {
        try {
            return this._personService.getPersonByEmail(recipientAddress);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private void sendOneMail(@Nonnull EMailTemplate template, @Nullable DBPerson recipientPerson, @Nonnull String recipientAddress, boolean replaceRecipientInContext, @Nonnull Collection<String> failedRecipients) throws SendMailException {
        if (!this.shouldSendMail(recipientPerson, template.getType())) {
            LOG.info("Not sending mail [subject=" + template.getSubject() + "]  to blocked user [id=" + recipientPerson.getId() + "]");
            return;
        }
        this.updateMailContext(template, recipientPerson, recipientAddress, replaceRecipientInContext);
        String locale = this.getLocale(template, recipientPerson);
        boolean mailSentSuccessfully = template instanceof MultipartEMailTemplate ? this._mailSender.sendMixedMail(this._mailTemplateManager.getHtmlMail((MultipartEMailTemplate)template, recipientAddress, locale)) : this._mailSender.sendMail(this._mailTemplateManager.getMail(template, recipientAddress, locale));
        if (!mailSentSuccessfully) {
            LOG.error("Failed to send mail [subject=" + template.getSubject() + "] to " + recipientAddress);
            failedRecipients.add(recipientAddress);
        }
    }

    @CheckForNull
    private String getLocale(@Nonnull EMailTemplate template, @Nullable DBPerson recipientPerson) {
        return recipientPerson != null ? recipientPerson.getLanguageId() : template.getLocale();
    }

    private void updateMailContext(@Nonnull EMailTemplate template, @Nullable DBPerson recipientPerson, @Nonnull String recipientAddress, boolean replaceRecipientInContext) {
        if (replaceRecipientInContext) {
            if (recipientPerson == null) {
                template.getContext().put(GlobalMailTemplateKeys.RECIPIENT, (Object)recipientAddress);
            } else {
                template.getContext().put(GlobalMailTemplateKeys.RECIPIENT, (Object)recipientPerson);
            }
        }
    }

    @Override
    public void sendMail(DBPerson recipient, String subject, String text, MailType type) {
        if (!this.shouldSendMail(recipient, type)) {
            LOG.info("Not sending mail [subject=" + subject + "]  to blocked user [id=" + recipient.getId() + "]");
            return;
        }
        String recipientEmail = recipient.getEmail();
        if (!this._mailSender.sendMail(new MailMessageBean(subject, text, recipientEmail, type))) {
            LOG.error("Failed to send mail [subject=" + subject + "] to " + recipientEmail);
        }
    }
}

