/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.EditorComponentOrder;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.UserGeneratedHtmlContentId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityComponent;
import de.justsoftware.onx.mail.business.HtmlContentMailService;
import de.justsoftware.onx.mail.business.impl.EditorComponentTypeVisitor;
import de.justsoftware.onx.mail.business.model.ContentBlock;
import de.justsoftware.onx.multiwiki.business.MultiWikiService;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionSectionId;
import de.justsoftware.onx.multiwiki.shared.server.model.MultiWikiVersionSection;
import de.justsoftware.onx.raweditor.business.RawEditorService;
import de.justsoftware.onx.raweditor.shared.model.RawEditorId;
import de.justsoftware.onx.raweditor.shared.model.db.DBRawEditorVersion;
import de.justsoftware.onx.wikieditor.business.WikiEditorService;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionId;
import de.justsoftware.onx.wikieditor.shared.server.model.DBWikiVersion;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HtmlContentMailServiceImpl
implements HtmlContentMailService {
    private static final Logger LOG = LoggerFactory.getLogger(HtmlContentMailServiceImpl.class);
    private final EntityService _entityService;
    private final RawEditorService _rawEditorService;
    private final WikiEditorService _wikiEditorService;
    private final MultiWikiService _multiWikiService;

    @Autowired
    @ParametersAreNonnullByDefault
    public HtmlContentMailServiceImpl(EntityService entityService, RawEditorService rawEditorService, WikiEditorService wikiEditorService, MultiWikiService multiWikiService) {
        this._entityService = entityService;
        this._rawEditorService = rawEditorService;
        this._wikiEditorService = wikiEditorService;
        this._multiWikiService = multiWikiService;
    }

    @Nonnull
    private ImmutableSet<UserGeneratedHtmlContentId> getIdsOfComponents(@Nonnull AuthorizationCheckContextWithUserId authCtx, @Nonnull DBEntity entity, @Nonnull Set<? extends ComponentType> componentTypes) {
        ImmutableMap dbComponents = ImmutableMap.copyOf(this._entityService.getComponentsByEntity(entity));
        Map filteredComponentTypes = Maps.filterKeys((Map)dbComponents, (Predicate)Predicates.in(componentTypes));
        ImmutableSet.Builder contentIds = ImmutableSet.builder();
        EditorComponentTypeVisitor typeVisitor = new EditorComponentTypeVisitor(entity.getId(), this._wikiEditorService, this._multiWikiService, this._rawEditorService, authCtx);
        for (EditorComponentOrder orderedType : EditorComponentOrder.values()) {
            StaticComponentType type = orderedType.getComponentType();
            DBEntityComponent component = (DBEntityComponent)filteredComponentTypes.get(type);
            if (component == null || !component.isVisible()) continue;
            contentIds.addAll((Iterable)type.accept(typeVisitor).asSet());
        }
        return contentIds.build();
    }

    @Nonnull
    private ImmutableList<ContentBlock> loadContents(@Nonnull Iterable<? extends UserGeneratedHtmlContentId> selectedContent, @Nonnull AuthorizationCheckContext authCtx) {
        UserGeneratedHtmlContentIdCollector collector = new UserGeneratedHtmlContentIdCollector();
        for (UserGeneratedHtmlContentId userGeneratedHtmlContentId : selectedContent) {
            userGeneratedHtmlContentId.accept(collector);
        }
        ImmutableMap.Builder mapped = ImmutableMap.builder();
        for (DBEntity entity : this._entityService.getByIds((Set<EntityId>)collector._entityIds.build()).values()) {
            mapped.put((Object)entity.getId(), (Object)HtmlContentMailServiceImpl.contentBlock(entity.getDescription(), ""));
        }
        ImmutableMap<RawEditorId, DBRawEditorVersion> immutableMap = this._rawEditorService.getCurrentVersionsByIds((Set<RawEditorId>)collector._rawEditorIds.build());
        for (DBRawEditorVersion version : immutableMap.values()) {
            mapped.put((Object)version.getRawEditorId(), (Object)HtmlContentMailServiceImpl.contentBlock(version.getText(), ""));
        }
        Map<WikiVersionId, DBWikiVersion> wikiVersions = this._wikiEditorService.getDBWikiVersionsById((Set<WikiVersionId>)collector._wikiVersionIds.build());
        for (DBWikiVersion wikiVersion : wikiVersions.values()) {
            mapped.put((Object)wikiVersion.getId(), (Object)HtmlContentMailServiceImpl.contentBlock(wikiVersion.getText(), ""));
        }
        for (MultiWikiVersionSectionId multiWikiVersionSectionId : collector._wikiSectionIds.build()) {
            try {
                MultiWikiVersionSection wvs = this._multiWikiService.getWikiSectionById(multiWikiVersionSectionId, authCtx);
                mapped.put((Object)multiWikiVersionSectionId, (Object)HtmlContentMailServiceImpl.contentBlock(wvs.getText(), wvs.getHeadline()));
            }
            catch (InvalidIDException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(selectedContent, (Function)Functions.forMap((Map)mapped.build(), null)), (Predicate)Predicates.notNull()));
    }

    @Nonnull
    @VisibleForTesting
    public static ContentBlock contentBlock(@Nonnull String content, @Nonnull String headline) {
        return new ContentBlockImpl(content, headline);
    }

    @Override
    public ImmutableList<ContentBlock> loadContents(AuthorizationCheckContextWithUserId authCtx, DBEntity entity, Set<? extends ComponentType> selectedComponentTypes) {
        return this.loadContents((Iterable<? extends UserGeneratedHtmlContentId>)this.getIdsOfComponents(authCtx, entity, selectedComponentTypes), authCtx);
    }

    private static final class UserGeneratedHtmlContentIdCollector
    implements UserGeneratedHtmlContentId.UserGeneratedHtmlContentIdVisitor<ImmutableSet.Builder<?>> {
        final ImmutableSet.Builder<EntityId> _entityIds = ImmutableSet.builder();
        final ImmutableSet.Builder<MultiWikiVersionSectionId> _wikiSectionIds = ImmutableSet.builder();
        final ImmutableSet.Builder<WikiVersionId> _wikiVersionIds = ImmutableSet.builder();
        final ImmutableSet.Builder<RawEditorId> _rawEditorIds = ImmutableSet.builder();

        private UserGeneratedHtmlContentIdCollector() {
        }

        @Override
        public ImmutableSet.Builder<?> visit(MultiWikiVersionSectionId wikiSectionId) {
            return this._wikiSectionIds.add((Object)wikiSectionId);
        }

        @Override
        public ImmutableSet.Builder<?> visit(WikiVersionId wikiId) {
            return this._wikiVersionIds.add((Object)wikiId);
        }

        @Override
        public ImmutableSet.Builder<?> visit(EntityId entityId) {
            return this._entityIds.add((Object)entityId);
        }

        @Override
        public ImmutableSet.Builder<?> visit(RawEditorId rawEditorId) {
            return this._rawEditorIds.add((Object)rawEditorId);
        }
    }

    private static final class ContentBlockImpl
    implements ContentBlock {
        private final String _htmlContent;
        private final String _headline;

        ContentBlockImpl(@Nonnull String htmlContent, @Nonnull String headline) {
            this._htmlContent = htmlContent;
            this._headline = headline;
        }

        @Override
        public String getHtmlContent() {
            return this._htmlContent;
        }

        @Override
        public String getHeadline() {
            return this._headline;
        }
    }
}

