/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.mail.business.EntityRecommendationMailService;
import de.justsoftware.onx.mail.business.HtmlContentMailService;
import de.justsoftware.onx.mail.business.MailModelService;
import de.justsoftware.onx.mail.business.MailService;
import de.justsoftware.onx.mail.business.model.ContentBlock;
import de.justsoftware.onx.mail.business.model.EntityMailModel;
import de.justsoftware.onx.mail.business.model.EntityMailModels;
import de.justsoftware.onx.mail.business.model.EntityRecommendationMailModel;
import de.justsoftware.onx.mail.business.model.FooterMailModel;
import de.justsoftware.onx.mail.business.model.HeaderMailModel;
import de.justsoftware.onx.mail.business.model.MailReceiver;
import de.justsoftware.onx.mail.business.model.MailReceivers;
import de.justsoftware.onx.mail.business.model.ThemeMailModel;
import de.justsoftware.onx.mail.i18n.EntityMails;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityRecommendationMailServiceImpl
implements EntityRecommendationMailService {
    private final PersonService _personService;
    private final MailService _mailService;
    private final Settings _settings;
    private final I18nService _i18nService;
    private final EntityService _entityService;
    private final HtmlContentMailService _htmlContentMailService;
    private final MailModelService _mailModelService;

    @Autowired
    @ParametersAreNonnullByDefault
    public EntityRecommendationMailServiceImpl(PersonService personService, MailService mailService, Settings settings, I18nService i18nService, EntityService entityService, HtmlContentMailService htmlContentMailService, MailModelService mailModelService) {
        this._personService = personService;
        this._mailService = mailService;
        this._settings = settings;
        this._i18nService = i18nService;
        this._entityService = entityService;
        this._htmlContentMailService = htmlContentMailService;
        this._mailModelService = mailModelService;
    }

    @Override
    public void sendEntityRecommendationEmail(EntityId entityId, Set<PersonId> receiverIds, AuthorizationCheckContextWithUserId recommenderAuthCtx, String recommendationMessage, Set<ComponentType> selectedComponentTypes) {
        PersonId recommenderId = recommenderAuthCtx.getUserId();
        ImmutableSet<PersonId> filteredReceivers = this._personService.getEmailNotificationEnabledPersons(receiverIds);
        ImmutableSet personIds = ImmutableSet.builder().addAll(filteredReceivers).add((Object)recommenderId).build();
        ImmutableMap<PersonId, DBPerson> persons = this._personService.getPersonsByIds((Set<PersonId>)personIds);
        DBPerson recommender = InvalidIdServiceException.check((DBPerson)persons.get(recommenderId));
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        ImmutableList<ContentBlock> contents = this._htmlContentMailService.loadContents(recommenderAuthCtx, entity, selectedComponentTypes);
        for (DBPerson receiver : persons.values()) {
            if (recommenderId.equals(receiver.getId()) || !receiver.canLogin()) continue;
            this._mailService.sendEmail(new EntityRecommendationMailModelImplementation(recommender, receiver, entity, recommendationMessage, contents));
        }
    }

    private final class EntityRecommendationMailModelImplementation
    implements EntityRecommendationMailModel {
        private final String _subject;
        private final DBPerson _recommender;
        private final MailReceiver _mailReceiver;
        private final String _recommendationMessage;
        private final ImmutableList<ContentBlock> _contents;
        private final EntityMailModel _entity;
        private final HeaderMailModel _header;
        private final FooterMailModel _footer;
        private final ThemeMailModel _theme;

        @ParametersAreNonnullByDefault
        private EntityRecommendationMailModelImplementation(DBPerson recommender, DBPerson receiver, DBEntity entity, String recommendationMessage, ImmutableList<ContentBlock> contents) {
            this._header = EntityRecommendationMailServiceImpl.this._mailModelService.getHeaderMailModel();
            this._footer = EntityRecommendationMailServiceImpl.this._mailModelService.getFooterMailModel();
            this._theme = EntityRecommendationMailServiceImpl.this._mailModelService.getThemeMailModel();
            this._mailReceiver = MailReceivers.forPerson(receiver, EntityRecommendationMailServiceImpl.this._settings);
            EntityType entityType = entity.getType();
            this._subject = EntityRecommendationMailServiceImpl.this._i18nService.createProxy(EntityMails.class, entityType, this._mailReceiver.getLocale().getLanguage()).entityRecomendationSubject(recommender.getFullName(), entityType, entity.getName());
            this._recommender = recommender;
            this._recommendationMessage = recommendationMessage;
            this._contents = contents;
            this._entity = EntityMailModels.createForDBEntity(entity);
        }

        @Override
        public String getSubject() {
            return this._subject;
        }

        @Override
        public MailReceiver getReceiver() {
            return this._mailReceiver;
        }

        @Override
        public List<ContentBlock> getContents() {
            return this._contents;
        }

        @Override
        public EntityMailModel getEntity() {
            return this._entity;
        }

        @Override
        public String getRecommendationMessage() {
            return this._recommendationMessage;
        }

        @Override
        public String getRecommender() {
            return this._recommender.getFullName();
        }

        @Override
        public HeaderMailModel getHeader() {
            return this._header;
        }

        @Override
        public FooterMailModel getFooter() {
            return this._footer;
        }

        @Override
        public ThemeMailModel getTheme() {
            return this._theme;
        }

        @Override
        public PersonId getRecommenderId() {
            return this._recommender.getId();
        }
    }
}

