/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.impl;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.shared.model.component.DefaultComponentTypeVisitor;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.UserGeneratedHtmlContentId;
import de.justsoftware.onx.multiwiki.business.MultiWikiService;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionSectionId;
import de.justsoftware.onx.raweditor.business.RawEditorService;
import de.justsoftware.onx.raweditor.shared.model.RawEditorId;
import de.justsoftware.onx.raweditor.shared.model.RawEditorVersion;
import de.justsoftware.onx.wikieditor.business.WikiEditorService;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionId;
import de.justsoftware.onx.wikieditor.shared.server.model.DBWikiVersion;
import java.util.Set;
import javax.annotation.Nonnull;

class EditorComponentTypeVisitor
extends DefaultComponentTypeVisitor<Optional<? extends UserGeneratedHtmlContentId>> {
    private final EntityId _entityId;
    private final AuthorizationCheckContextWithUserId _authorizationCtx;
    private final WikiEditorService _wikiEditorService;
    private final MultiWikiService _multiWikiService;
    private final RawEditorService _rawEditorService;

    EditorComponentTypeVisitor(@Nonnull EntityId entityId, @Nonnull WikiEditorService wikiEditorService, @Nonnull MultiWikiService multiWikiService, @Nonnull RawEditorService rawEditorService, @Nonnull AuthorizationCheckContextWithUserId authorizationCtx) {
        this._entityId = entityId;
        this._wikiEditorService = wikiEditorService;
        this._multiWikiService = multiWikiService;
        this._rawEditorService = rawEditorService;
        this._authorizationCtx = authorizationCtx;
    }

    @Override
    public Optional<EntityId> visitInfoWidget() {
        return Optional.of((Object)this._entityId);
    }

    @Override
    public Optional<WikiVersionId> visitWikiEditor() {
        DBWikiVersion currentDBWikiVersion = (DBWikiVersion)this._wikiEditorService.getCurrentDBWikiVersionByParentId((Set<? extends GlobalId>)ImmutableSet.of((Object)this._entityId)).get((Object)this._entityId);
        if (currentDBWikiVersion == null) {
            return Optional.absent();
        }
        return Optional.of((Object)currentDBWikiVersion.getId());
    }

    @Override
    public Optional<MultiWikiVersionSectionId> visitMultiWiki() {
        ImmutableList sections = this._multiWikiService.getCurrentPublishedSections((Set<EntityId>)ImmutableSet.of((Object)this._entityId)).get((Object)this._entityId);
        return FluentIterable.from((Iterable)sections).first().transform(Identifiables.toId());
    }

    @Nonnull
    private Optional<RawEditorId> visitRawEditor(@Nonnull StaticComponentType rawEditorType) {
        RawEditorVersion currentVersionByParentId = this._rawEditorService.getCurrentVersionByParentId(this._entityId, rawEditorType, this._authorizationCtx);
        if (currentVersionByParentId == null) {
            return Optional.absent();
        }
        return Optional.of((Object)currentVersionByParentId.getRawEditorId());
    }

    @Override
    public Optional<RawEditorId> visitRawEditor1() {
        return this.visitRawEditor(StaticComponentType.RAW_EDITOR1);
    }

    @Override
    public Optional<RawEditorId> visitRawEditor2() {
        return this.visitRawEditor(StaticComponentType.RAW_EDITOR2);
    }

    @Override
    public Optional<RawEditorId> visitRawEditor3() {
        return this.visitRawEditor(StaticComponentType.RAW_EDITOR3);
    }

    @Override
    public Optional<RawEditorId> visitRawEditor4() {
        return this.visitRawEditor(StaticComponentType.RAW_EDITOR4);
    }

    @Override
    protected Optional<UserGeneratedHtmlContentId> visitDefault() {
        return Optional.absent();
    }
}

