/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.freemarker;

import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageType;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.google.common.base.MoreObjects;
import de.justsoftware.mail.freemarker.EmbeddedImageBuilder;
import de.justsoftware.mail.freemarker.FreemarkerDirectiveUtils;
import de.justsoftware.mail.freemarker.SimpleFreemarkerDirective;
import de.justsoftware.onx.storage.business.StorageServerService;
import freemarker.core.Environment;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;

public class ProfileImageDirective
extends SimpleFreemarkerDirective {
    private final StorageServerService _storageServerService;

    public ProfileImageDirective(@Nonnull StorageServerService storageServerService) {
        this._storageServerService = storageServerService;
    }

    @Override
    protected String loadString(Map<String, ?> params, Environment env) throws TemplateException, IOException {
        ImageSize size = (ImageSize)((Object)MoreObjects.firstNonNull((Object)((Object)FreemarkerDirectiveUtils.getEnumValue(ImageSize.class, "size", params, env)), (Object)((Object)ImageSize.X_SMALL)));
        String image = FreemarkerDirectiveUtils.getNullableValue(String.class, "image", params, env);
        String path = ImageUrlUtil.getImagePath(size, ImageType.USER_IMAGE, image);
        EmbeddedImageBuilder builder = EmbeddedImageBuilder.create(env, path);
        builder.setAttachmentData(this._storageServerService.loadFileFromStorageServer(path));
        builder.setExternalUrl(ImageUrlUtil.appendServer(path));
        return builder.buildAndReturnNewUrl();
    }
}

