/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business.freemarker;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import de.justsoftware.mail.EmailRenderService;
import de.justsoftware.mail.RenderedEmail;
import de.justsoftware.onx.common.shared.util.ValueOfMap;
import de.justsoftware.onx.mail.business.MailSender;
import de.justsoftware.onx.mail.business.MailService;
import de.justsoftware.onx.mail.business.model.DefaultMailModel;
import de.justsoftware.onx.mail.business.model.MailReceiver;
import de.justsoftware.onx.mail.business.model.MailTemplatePath;
import de.justsoftware.onx.mail.business.model.ProfileDataMailModel;
import java.nio.charset.Charset;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;

@ParametersAreNonnullByDefault
public class MailServiceImpl
implements MailService {
    private static final Logger LOG = LoggerFactory.getLogger(MailServiceImpl.class);
    private static final Charset DEFAULT_CHARSET = Charsets.UTF_8;
    private static final ValueOfMap<Class<?>, MailTemplatePath> ANNOTATION_CACHE = new ValueOfMap<Class<?>, MailTemplatePath>(){

        @Override
        protected MailTemplatePath create(Class<?> key) {
            return (MailTemplatePath)Preconditions.checkNotNull((Object)((MailTemplatePath)AnnotationUtils.findAnnotation(key, MailTemplatePath.class)), (Object)(key + " doesn't have MailTemplatePath annotation present"));
        }
    };
    private final EmailRenderService _emailRenderService;
    private final MailSender _mailSender;

    @Autowired
    @ParametersAreNonnullByDefault
    public MailServiceImpl(EmailRenderService emailRenderService, MailSender mailSender) {
        this._emailRenderService = emailRenderService;
        this._mailSender = mailSender;
    }

    @Override
    public void sendEmail(DefaultMailModel mailDataModel) {
        this.sendEmailImmediately(mailDataModel);
    }

    @Override
    public boolean sendEmailImmediately(DefaultMailModel mailDataModel) {
        return this.sendEmail(mailDataModel.getReceiver(), mailDataModel, mailDataModel.getSubject());
    }

    private boolean sendEmail(MailReceiver recipient, Object mailDataModel, String subject) {
        RenderedEmail renderedEmail = this.renderEmail(recipient, mailDataModel);
        if (renderedEmail == null) {
            return false;
        }
        return this._mailSender.sendMail(recipient.getRecipientEmailAddress(), subject, renderedEmail);
    }

    @CheckForNull
    private RenderedEmail renderEmail(MailReceiver recipient, Object mailDataModel) {
        String template = ANNOTATION_CACHE.get(mailDataModel.getClass()).value();
        return this.renderEmail(template, recipient, mailDataModel);
    }

    @CheckForNull
    private RenderedEmail renderEmail(String template, MailReceiver recipient, Object mailDataModel) {
        try {
            return this._emailRenderService.renderEmail(template, mailDataModel, recipient.getLocale(), recipient.getTimeZone(), DEFAULT_CHARSET, null);
        }
        catch (EmailRenderService.EmailRenderException e) {
            LOG.error("Failed to render email with template {} for recipient {}: {}", (Object)new Object[]{template, recipient, e.getMessage()}, (Object)e);
            return null;
        }
    }

    @Override
    public void sendProfileData(ProfileDataMailModel model) {
        MailReceiver recipient = model.getReceiver();
        RenderedEmail renderedSubjectLine = this.renderEmail("profile/profiledata_subject.ftl", recipient, model);
        if (renderedSubjectLine != null) {
            this.sendEmail(recipient, model, renderedSubjectLine.getTextPart());
        }
    }
}

