/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.mail.business;

import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.mail.business.MailTemplateContext;
import de.justsoftware.onx.mail.business.MailType;
import de.justsoftware.onx.person.model.DBPerson;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EMailTemplate {
    private final Collection<DBPerson> _recipients;
    private final String _subject;
    private final MailType _subjectType;
    private final MailTemplateContext _context;
    private final MailType _type;
    private final String _locale;
    private final EntityType _entityType;

    public EMailTemplate(@Nonnull MailType type, @Nullable EntityType entityType, @Nonnull MailTemplateContext context, @Nonnull MailType subjectType, @Nonnull Collection<DBPerson> recipients) {
        this(type, entityType, context, "", subjectType, recipients, null);
    }

    public EMailTemplate(@Nonnull MailType type, @Nullable EntityType entityType, @Nonnull MailTemplateContext context, @Nonnull String subject, @Nonnull Collection<DBPerson> recipients) {
        this(type, entityType, context, subject, MailType.STATIC, recipients, null);
    }

    private EMailTemplate(@Nonnull MailType type, @Nullable EntityType entityType, @Nonnull MailTemplateContext context, @Nullable String subject, @Nonnull MailType subjectType, @Nonnull Collection<DBPerson> recipients, @Nullable String locale) {
        this._entityType = entityType;
        this._type = type;
        this._context = context;
        this._subject = subject;
        this._subjectType = subjectType;
        this._recipients = recipients;
        this._locale = locale;
    }

    @Nonnull
    public MailTemplateContext getContext() {
        return this._context;
    }

    @Nonnull
    public MailType getType() {
        return this._type;
    }

    @CheckForNull
    public String getSubject() {
        return this._subject;
    }

    @Nonnull
    public MailType getSubjectType() {
        return this._subjectType;
    }

    @CheckForNull
    public String getLocale() {
        return this._locale;
    }

    @Nonnull
    public Collection<DBPerson> getRecipients() {
        return this._recipients;
    }

    @CheckForNull
    public EntityType getEntityType() {
        return this._entityType;
    }
}

