/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.link.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.link.integration.persistence.LinkDAO;
import de.justsoftware.onx.link.integration.persistence.ibatis.DBLink;
import de.justsoftware.onx.link.shared.model.LinkId;
import de.justsoftware.onx.link.shared.server.model.LinkModel;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class IbatisLinkDAO
implements LinkDAO {
    private static final String NAMESPACE = "Link.";
    private static final Function<DBLink, LinkModel> TO_BUSINESS_LINK = new Function<DBLink, LinkModel>(){

        public LinkModel apply(@Nullable DBLink link) {
            return IbatisLinkDAO.convertLink(link);
        }
    };
    @Autowired
    @Qualifier(value="sqlMapClient")
    private SqlMapClient _sqlMapClient;

    @Override
    public ImmutableMap<LinkId, LinkModel> getByIds(Set<LinkId> ids) {
        ImmutableMap dbLinks = IbatisDAOUtil.wrappedPartitionQueryForMap(this._sqlMapClient, "Link.getByIds", "id", ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
        return ImmutableMap.copyOf((Map)Maps.transformValues(dbLinks, TO_BUSINESS_LINK));
    }

    @Override
    public void deleteByIds(Iterable<LinkId> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        IbatisDAOUtil.wrappedPartitionDelete(this._sqlMapClient, "Link.deleteByIds", ImmutableSet.copyOf(ids), IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public void updateLinkTitle(LinkId id, String newTitle) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("title", newTitle);
        params.put("modifyDate", new Date());
        IbatisDAOUtil.wrappedUpdate(this._sqlMapClient, "Link.updateLinkTitle", params);
    }

    @Override
    public LinkId persist(String url, String title) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", title);
        params.put("url", url);
        params.put("createDate", new Date());
        return (LinkId)IbatisDAOUtil.wrappedInsert(this._sqlMapClient, "Link.insertLink", params);
    }

    @CheckForNull
    private static LinkModel convertLink(@Nullable DBLink link) {
        if (link == null) {
            return null;
        }
        return new LinkModel(link.getId(), link.getUrl(), link.getTitle(), link.getCreateDate(), link.getModifyDate());
    }
}

