/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.link.business.impl;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.link.business.LinkReadDataService;
import de.justsoftware.onx.link.business.LinkService;
import de.justsoftware.onx.link.business.LinkWriteDataService;
import de.justsoftware.onx.link.shared.model.LinkId;
import de.justsoftware.onx.link.shared.server.model.LinkModel;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class LinkServiceImpl
implements LinkService {
    private final LinkWriteDataService _linkWriteDataService;
    private final LinkReadDataService _linkReadDataService;

    @Autowired
    public LinkServiceImpl(LinkReadDataService linkReadDataService, LinkWriteDataService linkWriteDataService) {
        this._linkReadDataService = linkReadDataService;
        this._linkWriteDataService = linkWriteDataService;
    }

    @Override
    public ImmutableMap<LinkId, LinkModel> getByIds(Set<LinkId> ids) {
        return this._linkReadDataService.getByIds(ids);
    }

    @Override
    public LinkId saveLink(String url, String title) {
        return this._linkWriteDataService.persist(url, title);
    }

    @Override
    public void updateLinkTitle(LinkId id, String newTitle) {
        this._linkWriteDataService.updateLinkTitle(id, newTitle);
    }
}

