/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.like.shared.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.shared.i18n.LocalizedMessages;
import de.justsoftware.onx.like.shared.model.LikeStatus;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class RecentLikersCreator<T> {
    private final LocalizedMessages _localizedMessages;

    public RecentLikersCreator(@Nonnull LocalizedMessages localizedMessages) {
        this._localizedMessages = localizedMessages;
    }

    @Nonnull
    public ImmutableList<? extends T> create(@Nullable LikeStatus likeStatus) {
        if (likeStatus == null) {
            return ImmutableList.of();
        }
        int likeCount = likeStatus.getLikeCount();
        if (likeCount == 0) {
            return ImmutableList.of();
        }
        if (likeStatus.isDoILike() && likeCount == 1) {
            return this.onlyILike();
        }
        ImmutableList.Builder recentLikersBuilder = ImmutableList.builder();
        if (likeStatus.isDoILike()) {
            recentLikersBuilder.add(this.youLike(this._localizedMessages.likeMessages().you()));
        }
        recentLikersBuilder.addAll((Iterable)Collections2.filter((Collection)Collections2.transform(likeStatus.getRecentLikers(), (Function)new Function<PersonTeaserModel, T>(){

            public T apply(PersonTeaserModel input) {
                return RecentLikersCreator.this.otherLiker(input);
            }
        }), (Predicate)Predicates.notNull()));
        int moreCount = likeStatus.getLikeCount() - likeStatus.getRecentLikers().size() - (likeStatus.isDoILike() ? 1 : 0);
        if (moreCount > 0) {
            String text = this._localizedMessages.likeMessages().more(Integer.toString(moreCount));
            recentLikersBuilder.add(this.moreLink(text));
        }
        ImmutableList recentLikers = recentLikersBuilder.build();
        String likeThisMsg = this.likeThisMsg(recentLikers.size());
        return this.showRecentLikers(likeThisMsg, recentLikers);
    }

    @Nonnull
    protected ImmutableList<T> onlyILike() {
        return ImmutableList.of(this.youLike(this._localizedMessages.likeMessages().youLikeThis()));
    }

    @Nonnull
    private String likeThisMsg(int len) {
        if (len < 1) {
            return "";
        }
        if (len == 1) {
            return this._localizedMessages.likeMessages().likeThis1(this.placeholder(0));
        }
        return this._localizedMessages.likeMessages().likeThisMore(this.andList(len));
    }

    @Nonnull
    private String andList(int len) {
        StringBuilder result = new StringBuilder(this.placeholder(0));
        for (int i = 1; i < len - 1; ++i) {
            result.append(", ").append(this.placeholder(i));
        }
        return result.append(this._localizedMessages.likeMessages().and()).append(this.placeholder(len - 1)).toString();
    }

    @Nonnull
    protected abstract ImmutableList<? extends T> showRecentLikers(@Nonnull String var1, @Nonnull ImmutableList<T> var2);

    @Nonnull
    protected abstract String placeholder(int var1);

    @Nonnull
    protected abstract T youLike(@Nonnull String var1);

    @Nonnull
    protected abstract T otherLiker(@Nonnull PersonTeaserModel var1);

    @Nonnull
    protected abstract T moreLink(@Nonnull String var1);
}

