/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.like.integration.persistence.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import de.justsoftware.onx.like.shared.model.SubscriptionType;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DBSubscription {
    public static final Function<DBSubscription, Date> GET_MODIFIED_AT = new NullPermeableFunction<DBSubscription, Date>(){

        @Override
        protected Date applySafe(DBSubscription input) {
            return input.getModifyDate();
        }
    };
    public static final Function<DBSubscription, SubscriptionState> GET_STATE = new NullPermeableFunction<DBSubscription, SubscriptionState>(){

        @Override
        protected SubscriptionState applySafe(DBSubscription input) {
            return input.getState();
        }
    };
    public static final Function<DBSubscription, ItemId> GET_ITEM_ID = new NullPermeableFunction<DBSubscription, ItemId>(){

        @Override
        protected ItemId applySafe(DBSubscription input) {
            return input.getItemId();
        }
    };
    public static final Function<DBSubscription, PersonId> TO_SUBSCRIBER_ID = new NullPermeableFunction<DBSubscription, PersonId>(){

        @Override
        protected PersonId applySafe(DBSubscription input) {
            return input.getSubscriber();
        }
    };
    private ItemId _itemId;
    private PersonId _subscriber;
    private SubscriptionState _state;
    private SubscriptionType _type;
    private Date _createDate;
    private Date _modifyDate;

    @Deprecated
    public DBSubscription() {
    }

    @Nonnull
    public ItemId getItemId() {
        return this._itemId;
    }

    public void setItemId(ItemId itemId) {
        this._itemId = itemId;
    }

    @Nonnull
    public PersonId getSubscriber() {
        return this._subscriber;
    }

    public void setSubscriber(PersonId subscriber) {
        this._subscriber = subscriber;
    }

    @Nonnull
    public Date getModifyDate() {
        return Dates.clone(this._modifyDate);
    }

    public void setModifyDate(Date modifyDate) {
        this._modifyDate = Dates.clone(modifyDate);
    }

    @Nonnull
    public SubscriptionState getState() {
        return this._state;
    }

    public void setState(SubscriptionState state) {
        this._state = state;
    }

    @Nonnull
    public SubscriptionType getType() {
        return this._type;
    }

    public void setType(SubscriptionType type) {
        this._type = type;
    }

    @Nonnull
    public Date getCreateDate() {
        return Dates.clone(this._createDate);
    }

    public void setCreateDate(Date createDate) {
        this._createDate = Dates.clone(createDate);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("itemId", (Object)this._itemId).add("subscriber", (Object)this._subscriber).add("state", (Object)this._state).add("type", (Object)this._type).add("createDate", (Object)this._createDate).add("modifyDate", (Object)this._modifyDate).toString();
    }
}

