/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.like.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.like.business.model.SubscriptionModel;
import de.justsoftware.onx.like.integration.persistence.LikeDAO;
import de.justsoftware.onx.like.integration.persistence.model.DBSubscription;
import de.justsoftware.onx.like.integration.persistence.model.SubscriptionWithDate;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import de.justsoftware.onx.like.shared.model.SubscriptionType;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@ParametersAreNonnullByDefault
@Service(value="ibatisLikeDAO")
public class IbatisLikeDAO
implements LikeDAO {
    private static final NullPermeableFunction<DBSubscription, SubscriptionModel> SUBSCRITPION_MODEL_FUNCTION = new NullPermeableFunction<DBSubscription, SubscriptionModel>(){

        @Override
        protected SubscriptionModel applySafe(DBSubscription input) {
            return new SubscriptionModel(input.getItemId(), input.getSubscriber(), input.getState(), input.getType());
        }
    };
    private final TransactionHelper _transactionHelper;
    private final IbatisStatementBuilder _ibatisStatementBuilder;

    @Autowired
    public IbatisLikeDAO(TransactionHelper transactionHelper, StatementBuilderFactory statementBuilderFactory) {
        this._transactionHelper = transactionHelper;
        this._ibatisStatementBuilder = statementBuilderFactory.ibatistStatementBuilder("Like");
    }

    @Override
    public ImmutableMap<ItemId, Integer> getLikesCount(Set<? extends ItemId> ids) {
        ImmutableMap result = ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getLikeCountByItemIds").partition(ids)).asMap("itemId", "count");
        return ImmutableMap.copyOf((Map)Maps.asMap(ids, (Function)Functions.forMap(result, (Object)0)));
    }

    @Override
    public ImmutableSet<ItemId> getLikesByPersonId(PersonId personId) {
        ImmutableSetMultimap result = ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getLikesByPersonIds").partition(ImmutableSet.of((Object)personId))).asSetMultimap("personId", "itemId");
        return result.get((Object)personId);
    }

    @Override
    public void like(final ItemId id, final PersonId liker) {
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                IbatisLikeDAO.this._ibatisStatementBuilder.insertDbSpecific("like").param("liker", liker, "item", id);
                IbatisLikeDAO.this.updateRecent(id);
            }
        });
    }

    @Override
    public void unlike(final ItemId id, final PersonId liker) {
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                IbatisLikeDAO.this._ibatisStatementBuilder.delete("unlike").param("liker", liker, "item", id);
                IbatisLikeDAO.this.updateRecent(id);
            }
        });
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getSubscriptionsByEntityTypesAndPersonIds(Set<EntityType> entityTypesForSubscriptions, Set<PersonId> personIds, SubscriptionType type) {
        if (CollectionUtil.isEmpty(personIds)) {
            return ImmutableSetMultimap.of();
        }
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getSubscriptionsByEntityTypesAndPersonIds").partition("personIds", personIds, "entityTypes", IbatisDAOUtil.toIbatisList(entityTypesForSubscriptions), "type", (Object)type)).asSetMultimap("itemId", "subscriber");
    }

    @Override
    public void deleteAllForItem(ItemId id) {
        this._ibatisStatementBuilder.delete("deleteAllSubscriptions").param(id);
        this._ibatisStatementBuilder.delete("deleteAllLikes").param(id);
    }

    @Override
    public ImmutableList<SubscriptionModel> getSubscribers(Set<? extends ItemId> items) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getSubscribers").partition(items)).asList(SUBSCRITPION_MODEL_FUNCTION);
    }

    @Override
    public int getSubscribersCount(ItemId id) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("getSubscribersCount").param("id", id, "states", IbatisDAOUtil.toIbatisList(SubscriptionState.SUBSCRIBED_SET))).asCount();
    }

    @Override
    public ImmutableTable<ItemId, PersonId, SubscriptionModel> getExplicitSubscriptions(SetMultimap<? extends ItemId, PersonId> subscriptions) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getSubscriptionsByIds").partition(subscriptions.entries())).asTable(DBSubscription.GET_ITEM_ID, DBSubscription.TO_SUBSCRIBER_ID, SUBSCRITPION_MODEL_FUNCTION);
    }

    private void updateRecent(ItemId id) {
        this._ibatisStatementBuilder.update("unsetRecent").param(id);
        this._ibatisStatementBuilder.updateDbSpecific("setRecent").param(id);
    }

    @Override
    public ImmutableSetMultimap<ItemId, PersonId> getRecentLikers(Set<? extends ItemId> items) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("recentLikers").partition(items)).asSetMultimap("itemId", "personId");
    }

    @Override
    public ImmutableSet<PersonId> getAllLikerIds(ItemId id) {
        return this._ibatisStatementBuilder.select("getAllLikerIds").param(id).asSet();
    }

    @Override
    public ImmutableSetMultimap<ItemId, PersonId> updateSubscriptions(SetMultimap<? extends ItemId, PersonId> subscriptions, SubscriptionState state, SubscriptionType type) {
        this._ibatisStatementBuilder.update("updateSubscriptionStateType").partition("globalIdPersonId", subscriptions.entries(), (Map<String, ?>)ImmutableMap.of((Object)"state", (Object)((Object)state), (Object)"type", (Object)((Object)type), (Object)"modified_at", (Object)new Date()));
        return this.filterInDb(subscriptions);
    }

    @Nonnull
    private ImmutableSetMultimap<ItemId, PersonId> filterInDb(SetMultimap<? extends ItemId, PersonId> subscriptions) {
        final ImmutableTable<ItemId, PersonId, SubscriptionModel> inDb = this.getExplicitSubscriptions(subscriptions);
        return ImmutableSetMultimap.copyOf((Multimap)Multimaps.filterEntries(subscriptions, (Predicate)new NullIsFalsePredicate<Map.Entry<? extends ItemId, PersonId>>(){

            @Override
            protected boolean applySafe(Map.Entry<? extends ItemId, PersonId> input) {
                return !inDb.contains((Object)input.getKey(), (Object)input.getValue());
            }
        }));
    }

    @Override
    public ImmutableSetMultimap<ItemId, PersonId> updateSubscriptionWhenTypeDiffers(SetMultimap<? extends ItemId, PersonId> subscriptions, SubscriptionState state, SubscriptionType type) {
        this._ibatisStatementBuilder.update("updateSubscriptionWhenTypeDiffers").partition("globalIdPersonId", subscriptions.entries(), (Map<String, ?>)ImmutableMap.of((Object)"state", (Object)((Object)state), (Object)"type", (Object)((Object)type), (Object)"modified_at", (Object)new Date()));
        return this.filterInDb(subscriptions);
    }

    @Override
    public ImmutableSetMultimap<ItemId, PersonId> updateSubscriptions(SetMultimap<? extends ItemId, PersonId> subscriptions, SubscriptionState state) {
        this._ibatisStatementBuilder.update("updateSubscriptionState").partition("globalIdPersonId", subscriptions.entries(), (Map<String, ?>)ImmutableMap.of((Object)"state", (Object)((Object)state), (Object)"modified_at", (Object)new Date()));
        return this.filterInDb(subscriptions);
    }

    @Override
    public void insertSubscriptions(SetMultimap<? extends ItemId, PersonId> subscriptions, SubscriptionState state, SubscriptionType type) {
        Date now = new Date();
        this._ibatisStatementBuilder.insertDbSpecific("insertSubscriptions").partition("globalIdPersonId", subscriptions.entries(), (Map<String, ?>)ImmutableMap.of((Object)"state", (Object)((Object)state), (Object)"type", (Object)((Object)type), (Object)"created_at", (Object)now, (Object)"modified_at", (Object)now));
    }

    @Override
    public void insertSubscriptionsForPerson(SetMultimap<? extends ItemId, SubscriptionType> subscriptions, SubscriptionState state, PersonId personId) {
        Date now = new Date();
        this._ibatisStatementBuilder.insertDbSpecific("insertSubscriptionsForPerson").partition("itemIdSubscriptionType", subscriptions.entries(), (Map<String, ?>)ImmutableMap.of((Object)"state", (Object)((Object)state), (Object)"subscriber_id", (Object)personId, (Object)"created_at", (Object)now, (Object)"modified_at", (Object)now));
    }

    @Override
    public void subscribeAndOverwriteOldSubscriptions(Iterable<SubscriptionWithDate> subscriptions) {
        this._ibatisStatementBuilder.batch(s -> {
            subscriptions.forEach(subscription -> this._ibatisStatementBuilder.insertDbSpecific("insertOneSubscription").param(subscription));
            subscriptions.forEach(subscription -> this._ibatisStatementBuilder.update("updateOldSubscription").param(subscription));
        });
    }
}

