/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.like.integration.persistence;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.like.business.model.SubscriptionModel;
import de.justsoftware.onx.like.integration.persistence.model.SubscriptionWithDate;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import de.justsoftware.onx.like.shared.model.SubscriptionType;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface LikeDAO {
    @Nonnull
    public ImmutableMap<ItemId, Integer> getLikesCount(Set<? extends ItemId> var1);

    @Nonnull
    public ImmutableSet<ItemId> getLikesByPersonId(PersonId var1);

    public void like(ItemId var1, PersonId var2);

    public void unlike(ItemId var1, PersonId var2);

    @Nonnull
    public ImmutableList<SubscriptionModel> getSubscribers(Set<? extends ItemId> var1);

    public int getSubscribersCount(ItemId var1);

    public void deleteAllForItem(ItemId var1);

    @Nonnull
    public ImmutableSetMultimap<ItemId, PersonId> getRecentLikers(Set<? extends ItemId> var1);

    @Nonnull
    public ImmutableSet<PersonId> getAllLikerIds(ItemId var1);

    @Nonnull
    public ImmutableTable<ItemId, PersonId, SubscriptionModel> getExplicitSubscriptions(SetMultimap<? extends ItemId, PersonId> var1);

    @Nonnull
    public ImmutableSetMultimap<EntityId, PersonId> getSubscriptionsByEntityTypesAndPersonIds(@Nullable Set<EntityType> var1, Set<PersonId> var2, SubscriptionType var3);

    @Nonnull
    public ImmutableSetMultimap<ItemId, PersonId> updateSubscriptions(SetMultimap<? extends ItemId, PersonId> var1, SubscriptionState var2, SubscriptionType var3);

    @Nonnull
    public ImmutableSetMultimap<ItemId, PersonId> updateSubscriptionWhenTypeDiffers(SetMultimap<? extends ItemId, PersonId> var1, SubscriptionState var2, SubscriptionType var3);

    @Nonnull
    public ImmutableSetMultimap<ItemId, PersonId> updateSubscriptions(SetMultimap<? extends ItemId, PersonId> var1, SubscriptionState var2);

    public void insertSubscriptions(SetMultimap<? extends ItemId, PersonId> var1, SubscriptionState var2, SubscriptionType var3);

    public void insertSubscriptionsForPerson(SetMultimap<? extends ItemId, SubscriptionType> var1, SubscriptionState var2, PersonId var3);

    public void subscribeAndOverwriteOldSubscriptions(Iterable<SubscriptionWithDate> var1);
}

