/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.like.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.authorization.business.AuthorizationKey;
import de.justsoftware.onx.authorization.business.BasePersonIndependentAuthorizationContext;
import de.justsoftware.onx.authorization.business.PersonIndependentAuthorizationContext;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.ListAndCountAndIndex;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.StartpageId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticItemAction;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.business.events.EntityMembershipChangedEvent;
import de.justsoftware.onx.container.shared.model.DefaultItemIdVisitor;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.FailedAndSuccessfulActionsDetails;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.IdParseException;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.events.PersonActivatedEvent;
import de.justsoftware.onx.events.PersonDeactivatedOrDeletedEvent;
import de.justsoftware.onx.events.SubscriberUpdateEvent;
import de.justsoftware.onx.events.UpdateEvent;
import de.justsoftware.onx.events.business.UpdateEventHandler;
import de.justsoftware.onx.like.business.LikeReadDataService;
import de.justsoftware.onx.like.business.LikeService;
import de.justsoftware.onx.like.business.LikeWriteDataService;
import de.justsoftware.onx.like.business.model.SubscriptionModel;
import de.justsoftware.onx.like.integration.persistence.model.SubscriptionWithDate;
import de.justsoftware.onx.like.shared.model.LikeStatus;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import de.justsoftware.onx.like.shared.model.SubscriptionStatus;
import de.justsoftware.onx.like.shared.model.SubscriptionType;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.secret.business.AesSectretKey;
import de.justsoftware.onx.secret.business.SecretKeyName;
import de.justsoftware.onx.secret.business.SecretService;
import de.justsoftware.onx.util.server.AESRandomIvEncodeDecoder;
import de.justsoftware.onx.util.server.Base64EncoderDecoder;
import de.justsoftware.onx.util.server.EncoderDecoder;
import de.justsoftware.onx.util.server.JucoSecurityException;
import de.justsoftware.onx.util.server.Utf8StringToByteArrayEncoder;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.onx.workstream.business.WorkstreamDataService;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="likeService")
@ParametersAreNonnullByDefault
public class LikeServiceImpl
implements ServerEventHandler,
LikeService {
    private static final ImmutableSet<? extends Action> LIKE_ACTIONS = ImmutableSet.of((Object)StaticItemAction.LIKE_SUBSCRIBE, (Object)StaticItemAction.UNLIKE_UNSUBSCRIBE, (Object)StaticItemAction.LIKE_SUBSCRIBE_READ);
    private static final int MAX_RECENT_PER_ID = 2;
    private static final Function<ItemId, Optional<SubscriberUpdateEvent>> UPDATE_EVENT_FOR_ITEM_ID = new DefaultItemIdVisitor<Optional<SubscriberUpdateEvent>>(){

        @Override
        public Optional<SubscriberUpdateEvent> visit(EntityId entityId) {
            return this.onChange(entityId);
        }

        @Override
        public Optional<SubscriberUpdateEvent> visit(ProfileId profileId) {
            return this.onChange(profileId);
        }

        @Override
        public Optional<SubscriberUpdateEvent> visit(StartpageId startpageId) {
            return this.onChange(startpageId.asPersonId().asProfileId());
        }

        @Override
        public Optional<SubscriberUpdateEvent> visit(WorkstreamMessageId workstreamMessageId) {
            return this.onChange(workstreamMessageId);
        }

        @Override
        public Optional<SubscriberUpdateEvent> visit(DriveDocumentId driveDocumentId) {
            return this.onChange(driveDocumentId);
        }

        @Nonnull
        private Optional<SubscriberUpdateEvent> onChange(@Nonnull ItemId itemId) {
            return Optional.of((Object)new SubscriberUpdateEvent(itemId));
        }

        @Override
        public Optional<SubscriberUpdateEvent> visitDefault(ItemId globalId) {
            return Optional.absent();
        }
    };
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private ItemService _itemService;
    @Autowired
    private LikeWriteDataService _likeWriteService;
    @Autowired
    private LikeReadDataService _likeReadService;
    @Autowired
    private PersonService _personService;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private UpdateEventHandler _searchUpdateHandler;
    @Autowired
    private AuthorizationContextProvider _authCtxProvider;
    @Autowired
    private SecretService _secretService;
    @Autowired
    private WorkstreamDataService _workstreamDataService;

    @Override
    public void setLikeAndSubscription(ItemId id, boolean like, AuthorizationCheckContextWithUserId auhtCtx) {
        PersonId liker = auhtCtx.getUserId();
        auhtCtx.check(id, (Action)(like ? StaticItemAction.LIKE_SUBSCRIBE : StaticItemAction.UNLIKE_UNSUBSCRIBE));
        if (like) {
            this._likeWriteService.like(id, liker);
            this.subscribeToItems((Set<? extends ItemId>)ImmutableSet.of((Object)id), auhtCtx);
        } else {
            this._likeWriteService.unlike(id, liker);
            this.setSubscriptionState((Set<? extends ItemId>)ImmutableSet.of((Object)id), SubscriptionState.UNSUBSCRIBED, auhtCtx);
        }
    }

    @Override
    public void subscribeToItems(Set<? extends ItemId> ids, AuthorizationCheckContextWithUserId authCtx) {
        this.setSubscriptionStateInternal(ids, SubscriptionState.SUBSCRIBED, authCtx);
    }

    @Override
    public FailedAndSuccessfulActionsDetails<ItemId, SubscriptionStatus> setSubscriptionState(Set<? extends ItemId> ids, SubscriptionState state, AuthorizationCheckContextWithUserId authCtx) {
        ImmutableSet<? extends ItemId> filteredIds = this.setSubscriptionStateInternal(ids, state, authCtx);
        BasicConstants basicConstants = this._i18nService.getLocalizedMessages(authCtx.getLocale()).basicConstants();
        FailedAndSuccessfulActionsDetails.Builder<ItemId, Serializable> result = FailedAndSuccessfulActionsDetails.getBuilder();
        ImmutableMap<ItemId, SubscriptionStatus> subscriptions = this.getExplicitSubscriptionStatus((Iterable<? extends ItemId>)filteredIds, authCtx);
        for (ItemId id : filteredIds) {
            result.addDetails(id, (SubscriptionStatus)subscriptions.get((Object)id));
        }
        for (ItemId id : Sets.difference(ids, filteredIds)) {
            result.addErrorMessage(id, basicConstants.noPermission());
        }
        return result.build();
    }

    @Nonnull
    private ImmutableSet<? extends ItemId> setSubscriptionStateInternal(Set<? extends ItemId> ids, SubscriptionState state, AuthorizationCheckContextWithUserId authCtx) {
        if (ids.isEmpty()) {
            return ImmutableSet.of();
        }
        StaticItemAction action = state == SubscriptionState.SUBSCRIBED ? StaticItemAction.LIKE_SUBSCRIBE : StaticItemAction.UNLIKE_UNSUBSCRIBE;
        ImmutableSet<? extends ItemId> filteredIds = authCtx.filterAllowedIds(ids, action);
        PersonId subscriber = authCtx.getUserId();
        ImmutableSetMultimap subscriptions = ImmutableSetMultimap.builder().putAll((Object)subscriber, filteredIds).build().inverse();
        this._likeWriteService.setSubscriptionStateAndType((SetMultimap<? extends ItemId, PersonId>)subscriptions, state, SubscriptionType.DEFAULT, false);
        if (state.isSubscribed()) {
            this.subscribeToParentWorkstreamMessage(filteredIds, state, authCtx);
        }
        this.updateSearch(filteredIds);
        return filteredIds;
    }

    private void subscribeToParentWorkstreamMessage(ImmutableSet<? extends ItemId> filteredIds, SubscriptionState state, AuthorizationCheckContextWithUserId authCtx) {
        this.setSubscriptionStateInternal((Set<? extends ItemId>)ImmutableSet.copyOf((Collection)this._workstreamDataService.getMicroblogEntryIdsByAttachments((Set<? extends ItemId>)filteredIds).values()), state, authCtx);
    }

    private void updateSearch(ImmutableSet<? extends ItemId> filteredIds) {
        this._searchUpdateHandler.onChanges((Iterable<? extends UpdateEvent<?>>)FluentIterable.from(filteredIds).transform(UPDATE_EVENT_FOR_ITEM_ID).transformAndConcat(Optional::asSet));
    }

    @Nonnull
    private Multimap<ItemId, PersonTeaserModel> filterRecentLikers(ImmutableSet<? extends ItemId> items, AuthorizationCheckContextWithUserId authorizationContext) {
        ImmutableSetMultimap<ItemId, PersonId> unfiltered = this._likeReadService.getRecentLikers((Set<? extends ItemId>)items);
        ArrayListMultimap filtered = ArrayListMultimap.create();
        HashSet<PersonId> likers = new HashSet<PersonId>();
        block0: for (Map.Entry e : unfiltered.asMap().entrySet()) {
            int count = 0;
            for (PersonId p : (Collection)e.getValue()) {
                if (count >= 2) continue block0;
                if (p.equals(authorizationContext.getUserId())) continue;
                filtered.put((Object)((ItemId)e.getKey()), (Object)p);
                likers.add(p);
                ++count;
            }
        }
        return Multimaps.transformValues((ListMultimap)filtered, (Function)Functions.forMap(this._profileTeaserService.getPersonTeasersByIds(likers, authorizationContext)));
    }

    @Override
    public <T extends ItemId> ImmutableMap<T, LikeStatus> getLikes(Iterable<T> ids, AuthorizationCheckContextWithUserId authorizationCheckContext) {
        ImmutableMap<T, Item<T>> items = this._itemService.getByIds(ids);
        return this.getLikes(items, authorizationCheckContext);
    }

    @Override
    public <T extends ItemId> ImmutableMap<T, LikeStatus> getLikesForItems(Iterable<? extends Item<? extends T>> items, AuthorizationCheckContextWithUserId authorizationCheckContext) {
        ImmutableMap itemMap = Maps.uniqueIndex(items, Identifiables.toId());
        return this.getLikes(itemMap, authorizationCheckContext);
    }

    @Nonnull
    private <T extends ItemId> ImmutableMap<T, LikeStatus> getLikes(ImmutableMap<T, ? extends Item<? extends T>> items, AuthorizationCheckContextWithUserId authorizationCheckContext) {
        Iterable<Item<T>> allowedItems = this.allowedItems(authorizationCheckContext, items);
        ImmutableSet allowedIds = FluentIterable.from(allowedItems).transform(Identifiables.toId()).filter(Predicates.notNull()).toSet();
        ImmutableSet<ItemId> myLikes = this._likeReadService.getLikesByPersonId(authorizationCheckContext.getUserId());
        ImmutableMap<ItemId, Integer> likesCount = this._likeReadService.getLikesCount((Set<? extends ItemId>)allowedIds);
        Multimap<ItemId, PersonTeaserModel> recentLikers = this.filterRecentLikers((ImmutableSet<? extends ItemId>)allowedIds, authorizationCheckContext);
        ImmutableSetMultimap<Optional<T>, ? extends Action> may = authorizationCheckContext.may(allowedItems, LIKE_ACTIONS);
        return FluentIterable.from((Iterable)allowedIds).toMap((Function)new NullPermeableFunction<T, LikeStatus>((Set)myLikes, (ImmutableSetMultimap)may, (Map)likesCount, (Multimap)recentLikers){
            final /* synthetic */ Set val$myLikes;
            final /* synthetic */ ImmutableSetMultimap val$may;
            final /* synthetic */ Map val$likesCount;
            final /* synthetic */ Multimap val$recentLikers;
            {
                this.val$myLikes = set;
                this.val$may = immutableSetMultimap;
                this.val$likesCount = map;
                this.val$recentLikers = multimap;
            }

            @Override
            protected LikeStatus applySafe(T input) {
                return new LikeStatus(this.val$myLikes.contains(input), (ImmutableSet<Action>)this.val$may.get((Object)Optional.of(input)), Numbers.intValue((Number)this.val$likesCount.get(input)), (ImmutableList<PersonTeaserModel>)ImmutableList.copyOf((Collection)this.val$recentLikers.get(input)));
            }
        });
    }

    @Nonnull
    private <T extends ItemId> Iterable<? extends Item<? extends T>> allowedItems(AuthorizationCheckContext authorizationCheckContext, ImmutableMap<T, ? extends Item<? extends T>> items) {
        return authorizationCheckContext.filterAllowedItems(items.values(), StaticItemAction.LIKE_SUBSCRIBE_READ);
    }

    @Override
    public ImmutableMap<ItemId, Integer> getLikeCount(Set<? extends ItemId> ids, AuthorizationCheckContext authCtx) {
        Iterable<Item<? extends ItemId>> allowed = this.allowedItems(authCtx, this._itemService.getByIds(ids));
        ImmutableSet allowedIds = FluentIterable.from(allowed).transform(Identifiables.toId()).filter(Predicates.notNull()).toSet();
        return this._likeReadService.getLikesCount((Set<? extends ItemId>)allowedIds);
    }

    @Override
    public ImmutableMap<ItemId, SubscriptionStatus> getExplicitSubscriptionStatus(Iterable<? extends ItemId> ids, AuthorizationCheckContextWithUserId authorizationCheckContext) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        PersonId personId = authorizationCheckContext.getUserId();
        ImmutableTable<ItemId, PersonId, SubscriptionModel> explicitSubscriptions = this._likeReadService.getExplicitSubscriptions((SetMultimap<? extends ItemId, PersonId>)ImmutableSetMultimap.builder().putAll((Object)personId, ids).build().inverse());
        ImmutableSetMultimap<Optional<? extends ItemId>, ? extends Action> may = authorizationCheckContext.mayByIds(ids, LIKE_ACTIONS);
        for (ItemId itemId : ids) {
            SubscriptionModel subscriptionModel = (SubscriptionModel)explicitSubscriptions.get((Object)itemId, (Object)personId);
            ImmutableSet permissions = may.get((Object)Optional.fromNullable((Object)itemId));
            SubscriptionState state = subscriptionModel == null || !permissions.contains((Object)StaticItemAction.LIKE_SUBSCRIBE_READ) ? SubscriptionState.UNSUBSCRIBED : subscriptionModel.getState();
            result.put((Object)itemId, (Object)new SubscriptionStatus(state, (ImmutableSet<Action>)permissions, true));
        }
        return result.build();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonActivated(PersonActivatedEvent e) {
        this._likeReadService.refreshSubscriptionsCount();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonDeactivated(PersonDeactivatedOrDeletedEvent e) {
        this._likeReadService.refreshSubscriptionsCount();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityMembershipChanged(EntityMembershipChangedEvent e) {
        ImmutableSetMultimap itemsAndPersons = ImmutableSetMultimap.builder().putAll((Object)e.getEntityId(), (Iterable)e.getNewRoles().keySet()).putAll((Object)e.getEntityId(), (Iterable)e.getOldRoles().keySet()).build();
        if (!itemsAndPersons.isEmpty()) {
            this.removeUnallowedSubscriptions((SetMultimap<? extends ItemId, PersonId>)itemsAndPersons, this._authCtxProvider.getPersonIndependentAuthorizationContext());
        }
    }

    @Override
    public void removeUnallowedSubscriptions(SetMultimap<? extends ItemId, PersonId> itemsAndPersons, BasePersonIndependentAuthorizationContext autCtx) {
        ImmutableCollection subscriptions = this._likeReadService.getExplicitSubscriptions(itemsAndPersons).values();
        if (!subscriptions.isEmpty()) {
            new AllowedSubscriptionsPredicate(autCtx, (Iterable<SubscriptionModel>)subscriptions).removeUnallowedSubscriptions();
        }
    }

    @Override
    public ImmutableListMultimap<PersonId, Item<?>> getAllowedInheritedMailSubscribers(PersonIndependentAuthorizationContext authCtx, ItemId id, Set<PersonId> exclude) {
        List<Item<?>> itemAndParents;
        try {
            itemAndParents = this._itemService.getItemAndParents(id);
        }
        catch (InvalidIDException e) {
            return ImmutableListMultimap.of();
        }
        if (CollectionUtil.isEmpty(itemAndParents)) {
            return ImmutableListMultimap.of();
        }
        ImmutableSet likeParam = FluentIterable.from(itemAndParents).transform(Identifiables.toId()).toSet();
        Predicate filter = exclude != null ? Predicates.compose((Predicate)Predicates.not((Predicate)Predicates.in(exclude)), SubscriptionModel.GET_SUBSCRIBER_ID) : Predicates.alwaysTrue();
        ImmutableList<SubscriptionModel> subscribers = this.getAllowedSubscribers(authCtx, (Set<? extends ItemId>)likeParam, (Predicate<? super SubscriptionModel>)filter);
        ImmutableListMultimap mappedByPerson = Multimaps.index(subscribers, SubscriptionModel.GET_SUBSCRIBER_ID);
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (Map.Entry personRow : mappedByPerson.asMap().entrySet()) {
            result.putAll((Object)((PersonId)personRow.getKey()), LikeServiceImpl.isSubscribedWithMail(itemAndParents, (Iterable)personRow.getValue()));
        }
        return result.build();
    }

    @Nonnull
    private static ImmutableList<Item<?>> isSubscribedWithMail(Iterable<? extends Item<?>> itemAndParents, Iterable<? extends SubscriptionModel> subscriptions) {
        ImmutableList.Builder result = ImmutableList.builder();
        ImmutableMap mappedSubscriptions = Maps.uniqueIndex(subscriptions, SubscriptionModel.GET_ITEM_ID);
        for (Item<?> item : itemAndParents) {
            SubscriptionModel subscription = (SubscriptionModel)mappedSubscriptions.get(item.getId());
            if (subscription == null) continue;
            if (subscription.getState().isBlockMail()) {
                return result.build();
            }
            if (!subscription.getState().isSubscribed()) continue;
            result.add(item);
        }
        return result.build();
    }

    @Nonnull
    private static ImmutableList<Item<?>> isSubscribed(Iterable<? extends Item<?>> itemAndParents, Iterable<? extends SubscriptionModel> subscriptions) {
        ImmutableList.Builder result = ImmutableList.builder();
        ImmutableMap mappedSubscriptions = Maps.uniqueIndex(subscriptions, SubscriptionModel.GET_ITEM_ID);
        for (Item<?> item : itemAndParents) {
            SubscriptionModel subscription = (SubscriptionModel)mappedSubscriptions.get(item.getId());
            if (subscription == null || !subscription.getState().isSubscribed()) continue;
            result.add(item);
        }
        return result.build();
    }

    @Nonnull
    private ImmutableList<SubscriptionModel> getAllowedSubscribers(BasePersonIndependentAuthorizationContext authorizationContext, Set<? extends ItemId> itemIds, Predicate<? super SubscriptionModel> filter) {
        List interestingSubscriptions = this._likeReadService.getSubscribers(itemIds).stream().filter(filter).collect(Collectors.toList());
        return (ImmutableList)Lists.partition(interestingSubscriptions, (int)100).stream().flatMap(subscriptionModels -> {
            AllowedSubscriptionsPredicate allowed = new AllowedSubscriptionsPredicate(authorizationContext, (Iterable<SubscriptionModel>)subscriptionModels);
            allowed.removeUnallowedSubscriptions();
            return subscriptionModels.stream().filter(Predicates.or((Predicate)Predicates.not(SubscriptionModel.IS_SUBSCRIBED), (Predicate)allowed));
        }).collect(ImmutableList.toImmutableList());
    }

    @Override
    public <T extends ItemId> ImmutableSetMultimap<T, PersonId> getAllowedDirectSubscribers(PersonIndependentAuthorizationContext authorizationContext, Set<T> itemIds) {
        ImmutableList<SubscriptionModel> subscribers = this.getAllowedSubscribers(authorizationContext, itemIds, (Predicate<? super SubscriptionModel>)Predicates.alwaysTrue());
        ImmutableListMultimap byItem = FluentIterable.from(subscribers).filter(Predicates.compose((Predicate)Predicates.equalTo((Object)((Object)SubscriptionState.SUBSCRIBED)), SubscriptionModel.GET_STATE)).index(SubscriptionModel.GET_ITEM_ID);
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (ItemId itemId : itemIds) {
            result.putAll((Object)itemId, (Iterable)FluentIterable.from((Iterable)byItem.get((Object)itemId)).transform(SubscriptionModel.GET_SUBSCRIBER_ID));
        }
        return result.build();
    }

    @Override
    public int getDirectSubscribersCount(ItemId id) {
        return this._likeReadService.getSubscribersCount(id);
    }

    @Override
    public boolean isSubscribed(ItemId itemId, PersonId subscriber) {
        if (subscriber == null) {
            return false;
        }
        try {
            return this.isSubscribed(this._itemService.getItemAndParents(itemId), subscriber);
        }
        catch (InvalidIDException e) {
            return false;
        }
    }

    @Override
    public boolean isSubscribed(Iterable<? extends Item<?>> itemAndParents, PersonId subscriber) {
        ImmutableTable<ItemId, PersonId, SubscriptionModel> subscriptions = this._likeReadService.getExplicitSubscriptions((SetMultimap<? extends ItemId, PersonId>)ImmutableSetMultimap.builder().putAll((Object)subscriber, (Iterable)FluentIterable.from(itemAndParents).transform(Identifiables.toId()).filter(GlobalId.class)).build().inverse());
        return !LikeServiceImpl.isSubscribed(itemAndParents, (Iterable<? extends SubscriptionModel>)subscriptions.values()).isEmpty();
    }

    @Nonnull
    private EncoderDecoder<String, String> createTokenEncoderDecoder() {
        AesSectretKey secret = (AesSectretKey)this._secretService.getSecretKey(SecretKeyName.LIKE_UNSUBSCRIBE_LINK);
        return Utf8StringToByteArrayEncoder.INSTANCE.wrap(new AESRandomIvEncodeDecoder(secret)).wrap(Base64EncoderDecoder.INSTANCE);
    }

    @Override
    public String generateUnsubscribeToken(ItemId id, PersonId subscriberId) {
        return this.createTokenEncoderDecoder().encode(id + ";" + subscriberId.getId());
    }

    @Override
    public PersonId unsubscribeByToken(String token) {
        try {
            String plainText = this.createTokenEncoderDecoder().decode(token);
            String[] parts = plainText.split(";");
            if (parts.length != 2) {
                return null;
            }
            ItemId itemId = ItemId.parse(parts[0]);
            if (itemId == null) {
                return null;
            }
            PersonId subscriberId = new PersonId(Long.parseLong(parts[1]));
            this.setSubscriptionState((Set<? extends ItemId>)ImmutableSet.of((Object)itemId), SubscriptionState.SUBSCRIBED_WITHOUT_MAIL, this._authCtxProvider.getAuthorizationContextForUser(subscriberId));
            return subscriberId;
        }
        catch (IdParseException | JucoSecurityException | IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public ListAndCountAndIndex<PersonTeaserModel> getAllLikers(ItemId id, int offset, int limit, AuthorizationCheckContextWithLocale authorizationContext) {
        authorizationContext.check(id, (Action)StaticItemAction.LIKE_SUBSCRIBE_READ);
        ImmutableList allIds = FluentIterable.from(this._likeReadService.getAllLikerIds(id)).toSortedList((Comparator)Ordering.usingToString());
        List ids = CollectionUtil.subList(allIds, offset, offset + limit);
        ImmutableList teasers = FluentIterable.from(ids).transform(arg_0 -> this._profileTeaserService.getPersonTeasersByIds((Set<PersonId>)ImmutableSet.copyOf(ids), authorizationContext).get(arg_0)).filter(Objects::nonNull).toList();
        return new ListAndCountAndIndex<PersonTeaserModel>(allIds.size(), (Collection<PersonTeaserModel>)teasers, offset);
    }

    @Override
    public void subscribeAndOverwriteOldSubscriptions(Iterable<SubscriptionWithDate> subscriptions) {
        ImmutableSet items = FluentIterable.from(subscriptions).transform(SubscriptionWithDate::getItemId).toSet();
        ImmutableMap<ItemId, WorkstreamMessageId> microblogEntrys = this._workstreamDataService.getMicroblogEntryIdsByAttachments((Set<? extends ItemId>)items);
        FluentIterable allSubcriptions = FluentIterable.from(subscriptions).transformAndConcat(s -> {
            WorkstreamMessageId m = (WorkstreamMessageId)microblogEntrys.get((Object)s.getItemId());
            return m == null ? ImmutableList.of() : ImmutableList.of((Object)new SubscriptionWithDate(s.getSubscriberId(), m, s.getSubscriptionDate()));
        }).append(subscriptions);
        this._likeWriteService.subscribeAndOverwriteOldSubscriptions((Iterable<SubscriptionWithDate>)allSubcriptions);
    }

    @ParametersAreNonnullByDefault
    private final class AllowedSubscriptionsPredicate
    extends NullIsFalsePredicate<SubscriptionModel> {
        private final ImmutableMap<ItemId, Item<? extends ItemId>> _items;
        private final ImmutableMap<PersonId, DBPerson> _persons;
        private final ImmutableSet<AuthorizationKey<Item<?>, Action>> _allowed;
        private final FluentIterable<SubscriptionModel> _subscriptions;

        private AllowedSubscriptionsPredicate(BasePersonIndependentAuthorizationContext authCtx, Iterable<SubscriptionModel> allSubscriptions) {
            this._subscriptions = FluentIterable.from(allSubscriptions).filter(SubscriptionModel.IS_SUBSCRIBED);
            this._items = LikeServiceImpl.this._itemService.getByIds(this._subscriptions.transform(SubscriptionModel.GET_ITEM_ID));
            this._persons = LikeServiceImpl.this._personService.getPersonsByIds((Set<PersonId>)this._subscriptions.transform(SubscriptionModel.GET_SUBSCRIBER_ID).toSet());
            ImmutableSet.Builder authKeyBuilder = ImmutableSet.builder();
            for (SubscriptionModel subscription : this._subscriptions) {
                authKeyBuilder.add(this.likeSubscribeAuthorizationKey(subscription));
            }
            this._allowed = authCtx.may(authKeyBuilder.build());
        }

        private void removeUnallowedSubscriptions() {
            ImmutableSetMultimap notAllowed = (ImmutableSetMultimap)Streams.stream(this._subscriptions).filter(this.negate()).collect(ImmutableSetMultimap.toImmutableSetMultimap(SubscriptionModel.GET_ITEM_ID, SubscriptionModel.GET_SUBSCRIBER_ID));
            if (!notAllowed.isEmpty()) {
                LikeServiceImpl.this._likeWriteService.setSubscriptionStateAndType((SetMultimap<? extends ItemId, PersonId>)notAllowed, SubscriptionState.UNSUBSCRIBED, SubscriptionType.DEFAULT, false);
            }
        }

        @Override
        protected boolean applySafe(SubscriptionModel input) {
            return this._allowed.contains(this.likeSubscribeAuthorizationKey(input));
        }

        @Nonnull
        private AuthorizationKey<Item<?>, Action> likeSubscribeAuthorizationKey(SubscriptionModel subscription) {
            return new AuthorizationKey((Item)this._items.get((Object)subscription.getItemId()), (DBPerson)this._persons.get((Object)subscription.getSubscriberId()), StaticItemAction.LIKE_SUBSCRIBE);
        }
    }
}

